// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securitycenter/v2/securitycenter_service.proto

#include "google/cloud/securitycenter/v2/security_center_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace securitycenter_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SecurityCenterConnectionIdempotencyPolicy::
    ~SecurityCenterConnectionIdempotencyPolicy() = default;

std::unique_ptr<SecurityCenterConnectionIdempotencyPolicy>
SecurityCenterConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SecurityCenterConnectionIdempotencyPolicy>(*this);
}

Idempotency
SecurityCenterConnectionIdempotencyPolicy::BatchCreateResourceValueConfigs(
    google::cloud::securitycenter::v2::
        BatchCreateResourceValueConfigsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::BulkMuteFindings(
    google::cloud::securitycenter::v2::BulkMuteFindingsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::CreateBigQueryExport(
    google::cloud::securitycenter::v2::CreateBigQueryExportRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::CreateFinding(
    google::cloud::securitycenter::v2::CreateFindingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::CreateMuteConfig(
    google::cloud::securitycenter::v2::CreateMuteConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::CreateNotificationConfig(
    google::cloud::securitycenter::v2::CreateNotificationConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::CreateSource(
    google::cloud::securitycenter::v2::CreateSourceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::DeleteBigQueryExport(
    google::cloud::securitycenter::v2::DeleteBigQueryExportRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::DeleteMuteConfig(
    google::cloud::securitycenter::v2::DeleteMuteConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::DeleteNotificationConfig(
    google::cloud::securitycenter::v2::DeleteNotificationConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SecurityCenterConnectionIdempotencyPolicy::DeleteResourceValueConfig(
    google::cloud::securitycenter::v2::
        DeleteResourceValueConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetBigQueryExport(
    google::cloud::securitycenter::v2::GetBigQueryExportRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetSimulation(
    google::cloud::securitycenter::v2::GetSimulationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetValuedResource(
    google::cloud::securitycenter::v2::GetValuedResourceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetMuteConfig(
    google::cloud::securitycenter::v2::GetMuteConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetNotificationConfig(
    google::cloud::securitycenter::v2::GetNotificationConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetResourceValueConfig(
    google::cloud::securitycenter::v2::GetResourceValueConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GetSource(
    google::cloud::securitycenter::v2::GetSourceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::GroupFindings(
    google::cloud::securitycenter::v2::GroupFindingsRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListAttackPaths(
    google::cloud::securitycenter::v2::ListAttackPathsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListBigQueryExports(
    google::cloud::securitycenter::v2::ListBigQueryExportsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListFindings(
    google::cloud::securitycenter::v2::ListFindingsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListMuteConfigs(
    google::cloud::securitycenter::v2::ListMuteConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListNotificationConfigs(
    google::cloud::securitycenter::v2::
        ListNotificationConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListResourceValueConfigs(
    google::cloud::securitycenter::v2::
        ListResourceValueConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListSources(
    google::cloud::securitycenter::v2::ListSourcesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::ListValuedResources(
    google::cloud::securitycenter::v2::ListValuedResourcesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::SetFindingState(
    google::cloud::securitycenter::v2::SetFindingStateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::SetMute(
    google::cloud::securitycenter::v2::SetMuteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::UpdateBigQueryExport(
    google::cloud::securitycenter::v2::UpdateBigQueryExportRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::UpdateExternalSystem(
    google::cloud::securitycenter::v2::UpdateExternalSystemRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::UpdateFinding(
    google::cloud::securitycenter::v2::UpdateFindingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::UpdateMuteConfig(
    google::cloud::securitycenter::v2::UpdateMuteConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::UpdateNotificationConfig(
    google::cloud::securitycenter::v2::UpdateNotificationConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SecurityCenterConnectionIdempotencyPolicy::UpdateResourceValueConfig(
    google::cloud::securitycenter::v2::
        UpdateResourceValueConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::UpdateSecurityMarks(
    google::cloud::securitycenter::v2::UpdateSecurityMarksRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterConnectionIdempotencyPolicy::UpdateSource(
    google::cloud::securitycenter::v2::UpdateSourceRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SecurityCenterConnectionIdempotencyPolicy>
MakeDefaultSecurityCenterConnectionIdempotencyPolicy() {
  return std::make_unique<SecurityCenterConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycenter_v2
}  // namespace cloud
}  // namespace google
