// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v2/cloud_speech.proto

#include "google/cloud/speech/v2/internal/speech_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace speech_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SpeechTracingConnection::SpeechTracingConnection(
    std::shared_ptr<speech_v2::SpeechConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::CreateRecognizer(
    google::cloud::speech::v2::CreateRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreateRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateRecognizer(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::CreateRecognizer(
    NoAwaitTag,
    google::cloud::speech::v2::CreateRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreateRecognizer");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateRecognizer(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::CreateRecognizer(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreateRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateRecognizer(operation));
}

StreamRange<google::cloud::speech::v2::Recognizer>
SpeechTracingConnection::ListRecognizers(
    google::cloud::speech::v2::ListRecognizersRequest request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::ListRecognizers");
  internal::OTelScope scope(span);
  auto sr = child_->ListRecognizers(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::speech::v2::Recognizer>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::speech::v2::Recognizer>
SpeechTracingConnection::GetRecognizer(
    google::cloud::speech::v2::GetRecognizerRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::GetRecognizer");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRecognizer(request));
}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::UpdateRecognizer(
    google::cloud::speech::v2::UpdateRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdateRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateRecognizer(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::UpdateRecognizer(
    NoAwaitTag,
    google::cloud::speech::v2::UpdateRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdateRecognizer");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateRecognizer(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::UpdateRecognizer(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdateRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateRecognizer(operation));
}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::DeleteRecognizer(
    google::cloud::speech::v2::DeleteRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeleteRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteRecognizer(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::DeleteRecognizer(
    NoAwaitTag,
    google::cloud::speech::v2::DeleteRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeleteRecognizer");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteRecognizer(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::DeleteRecognizer(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeleteRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteRecognizer(operation));
}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::UndeleteRecognizer(
    google::cloud::speech::v2::UndeleteRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeleteRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UndeleteRecognizer(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::UndeleteRecognizer(
    NoAwaitTag,
    google::cloud::speech::v2::UndeleteRecognizerRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeleteRecognizer");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UndeleteRecognizer(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::Recognizer>>
SpeechTracingConnection::UndeleteRecognizer(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeleteRecognizer");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UndeleteRecognizer(operation));
}

StatusOr<google::cloud::speech::v2::RecognizeResponse>
SpeechTracingConnection::Recognize(
    google::cloud::speech::v2::RecognizeRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::Recognize");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Recognize(request));
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::speech::v2::StreamingRecognizeRequest,
    google::cloud::speech::v2::StreamingRecognizeResponse>>
SpeechTracingConnection::AsyncStreamingRecognize() {
  return child_->AsyncStreamingRecognize();
}

future<StatusOr<google::cloud::speech::v2::BatchRecognizeResponse>>
SpeechTracingConnection::BatchRecognize(
    google::cloud::speech::v2::BatchRecognizeRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::BatchRecognize");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->BatchRecognize(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::BatchRecognize(
    NoAwaitTag,
    google::cloud::speech::v2::BatchRecognizeRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::BatchRecognize");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->BatchRecognize(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::BatchRecognizeResponse>>
SpeechTracingConnection::BatchRecognize(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::BatchRecognize");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->BatchRecognize(operation));
}

StatusOr<google::cloud::speech::v2::Config> SpeechTracingConnection::GetConfig(
    google::cloud::speech::v2::GetConfigRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::GetConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConfig(request));
}

StatusOr<google::cloud::speech::v2::Config>
SpeechTracingConnection::UpdateConfig(
    google::cloud::speech::v2::UpdateConfigRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::UpdateConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateConfig(request));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::CreateCustomClass(
    google::cloud::speech::v2::CreateCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreateCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCustomClass(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::CreateCustomClass(
    NoAwaitTag,
    google::cloud::speech::v2::CreateCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreateCustomClass");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateCustomClass(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::CreateCustomClass(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreateCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateCustomClass(operation));
}

StreamRange<google::cloud::speech::v2::CustomClass>
SpeechTracingConnection::ListCustomClasses(
    google::cloud::speech::v2::ListCustomClassesRequest request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::ListCustomClasses");
  internal::OTelScope scope(span);
  auto sr = child_->ListCustomClasses(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::speech::v2::CustomClass>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::speech::v2::CustomClass>
SpeechTracingConnection::GetCustomClass(
    google::cloud::speech::v2::GetCustomClassRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::GetCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCustomClass(request));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::UpdateCustomClass(
    google::cloud::speech::v2::UpdateCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdateCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCustomClass(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::UpdateCustomClass(
    NoAwaitTag,
    google::cloud::speech::v2::UpdateCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdateCustomClass");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateCustomClass(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::UpdateCustomClass(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdateCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateCustomClass(operation));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::DeleteCustomClass(
    google::cloud::speech::v2::DeleteCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeleteCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCustomClass(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::DeleteCustomClass(
    NoAwaitTag,
    google::cloud::speech::v2::DeleteCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeleteCustomClass");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteCustomClass(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::DeleteCustomClass(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeleteCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteCustomClass(operation));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::UndeleteCustomClass(
    google::cloud::speech::v2::UndeleteCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeleteCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UndeleteCustomClass(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::UndeleteCustomClass(
    NoAwaitTag,
    google::cloud::speech::v2::UndeleteCustomClassRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeleteCustomClass");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UndeleteCustomClass(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::CustomClass>>
SpeechTracingConnection::UndeleteCustomClass(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeleteCustomClass");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UndeleteCustomClass(operation));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::CreatePhraseSet(
    google::cloud::speech::v2::CreatePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreatePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreatePhraseSet(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::CreatePhraseSet(
    NoAwaitTag,
    google::cloud::speech::v2::CreatePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreatePhraseSet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreatePhraseSet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::CreatePhraseSet(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::CreatePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreatePhraseSet(operation));
}

StreamRange<google::cloud::speech::v2::PhraseSet>
SpeechTracingConnection::ListPhraseSets(
    google::cloud::speech::v2::ListPhraseSetsRequest request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::ListPhraseSets");
  internal::OTelScope scope(span);
  auto sr = child_->ListPhraseSets(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::speech::v2::PhraseSet>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::speech::v2::PhraseSet>
SpeechTracingConnection::GetPhraseSet(
    google::cloud::speech::v2::GetPhraseSetRequest const& request) {
  auto span = internal::MakeSpan("speech_v2::SpeechConnection::GetPhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPhraseSet(request));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::UpdatePhraseSet(
    google::cloud::speech::v2::UpdatePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdatePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdatePhraseSet(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::UpdatePhraseSet(
    NoAwaitTag,
    google::cloud::speech::v2::UpdatePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdatePhraseSet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdatePhraseSet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::UpdatePhraseSet(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UpdatePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdatePhraseSet(operation));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::DeletePhraseSet(
    google::cloud::speech::v2::DeletePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeletePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeletePhraseSet(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::DeletePhraseSet(
    NoAwaitTag,
    google::cloud::speech::v2::DeletePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeletePhraseSet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeletePhraseSet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::DeletePhraseSet(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::DeletePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeletePhraseSet(operation));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::UndeletePhraseSet(
    google::cloud::speech::v2::UndeletePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeletePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UndeletePhraseSet(request));
}

StatusOr<google::longrunning::Operation>
SpeechTracingConnection::UndeletePhraseSet(
    NoAwaitTag,
    google::cloud::speech::v2::UndeletePhraseSetRequest const& request) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeletePhraseSet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UndeletePhraseSet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::speech::v2::PhraseSet>>
SpeechTracingConnection::UndeletePhraseSet(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("speech_v2::SpeechConnection::UndeletePhraseSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UndeletePhraseSet(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<speech_v2::SpeechConnection> MakeSpeechTracingConnection(
    std::shared_ptr<speech_v2::SpeechConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SpeechTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v2_internal
}  // namespace cloud
}  // namespace google
