// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#include "google/cloud/vmwareengine/v1/internal/vmware_engine_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/vmwareengine/v1/vmwareengine.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace vmwareengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VmwareEngineLogging::VmwareEngineLogging(
    std::shared_ptr<VmwareEngineStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::vmwareengine::v1::ListPrivateCloudsResponse>
VmwareEngineLogging::ListPrivateClouds(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListPrivateCloudsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ListPrivateCloudsRequest const&
                 request) {
        return child_->ListPrivateClouds(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineLogging::GetPrivateCloud(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetPrivateCloudRequest const&
                 request) {
        return child_->GetPrivateCloud(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreatePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&
                 request) {
        return child_->AsyncCreatePrivateCloud(cq, std::move(context),
                                               std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreatePrivateCloud(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&
                 request) {
        return child_->CreatePrivateCloud(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdatePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&
                 request) {
        return child_->AsyncUpdatePrivateCloud(cq, std::move(context),
                                               std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdatePrivateCloud(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&
                 request) {
        return child_->UpdatePrivateCloud(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeletePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&
                 request) {
        return child_->AsyncDeletePrivateCloud(cq, std::move(context),
                                               std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeletePrivateCloud(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&
                 request) {
        return child_->DeletePrivateCloud(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUndeletePrivateCloud(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
                 request) {
        return child_->AsyncUndeletePrivateCloud(cq, std::move(context),
                                                 std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UndeletePrivateCloud(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
                 request) {
        return child_->UndeletePrivateCloud(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListClustersResponse>
VmwareEngineLogging::ListClusters(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListClustersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ListClustersRequest const& request) {
        return child_->ListClusters(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineLogging::GetCluster(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetClusterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::GetClusterRequest const& request) {
        return child_->GetCluster(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateClusterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::CreateClusterRequest const&
                 request) {
        return child_->AsyncCreateCluster(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> VmwareEngineLogging::CreateCluster(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateClusterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::CreateClusterRequest const&
                 request) {
        return child_->CreateCluster(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateClusterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::UpdateClusterRequest const&
                 request) {
        return child_->AsyncUpdateCluster(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> VmwareEngineLogging::UpdateCluster(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateClusterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::UpdateClusterRequest const&
                 request) {
        return child_->UpdateCluster(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeleteClusterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::DeleteClusterRequest const&
                 request) {
        return child_->AsyncDeleteCluster(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> VmwareEngineLogging::DeleteCluster(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeleteClusterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::DeleteClusterRequest const&
                 request) {
        return child_->DeleteCluster(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListNodesResponse>
VmwareEngineLogging::ListNodes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListNodesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ListNodesRequest const& request) {
        return child_->ListNodes(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::Node> VmwareEngineLogging::GetNode(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetNodeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetNodeRequest const& request) {
        return child_->GetNode(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListExternalAddressesResponse>
VmwareEngineLogging::ListExternalAddresses(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListExternalAddressesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ListExternalAddressesRequest const&
              request) {
        return child_->ListExternalAddresses(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::
             FetchNetworkPolicyExternalAddressesResponse>
VmwareEngineLogging::FetchNetworkPolicyExternalAddresses(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::
        FetchNetworkPolicyExternalAddressesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 FetchNetworkPolicyExternalAddressesRequest const& request) {
        return child_->FetchNetworkPolicyExternalAddresses(context, options,
                                                           request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>
VmwareEngineLogging::GetExternalAddress(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetExternalAddressRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetExternalAddressRequest const&
                 request) {
        return child_->GetExternalAddress(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateExternalAddress(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
              request) {
        return child_->AsyncCreateExternalAddress(cq, std::move(context),
                                                  std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateExternalAddress(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
              request) {
        return child_->CreateExternalAddress(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateExternalAddress(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
              request) {
        return child_->AsyncUpdateExternalAddress(cq, std::move(context),
                                                  std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateExternalAddress(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
              request) {
        return child_->UpdateExternalAddress(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteExternalAddress(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
              request) {
        return child_->AsyncDeleteExternalAddress(cq, std::move(context),
                                                  std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeleteExternalAddress(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
              request) {
        return child_->DeleteExternalAddress(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListSubnetsResponse>
VmwareEngineLogging::ListSubnets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListSubnetsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ListSubnetsRequest const& request) {
        return child_->ListSubnets(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineLogging::GetSubnet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetSubnetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetSubnetRequest const& request) {
        return child_->GetSubnet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateSubnet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request) {
        return child_->AsyncUpdateSubnet(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> VmwareEngineLogging::UpdateSubnet(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request) {
        return child_->UpdateSubnet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListExternalAccessRulesResponse>
VmwareEngineLogging::ListExternalAccessRules(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListExternalAccessRulesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ListExternalAccessRulesRequest const&
              request) {
        return child_->ListExternalAccessRules(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>
VmwareEngineLogging::GetExternalAccessRule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetExternalAccessRuleRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::GetExternalAccessRuleRequest const&
              request) {
        return child_->GetExternalAccessRule(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateExternalAccessRule(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 CreateExternalAccessRuleRequest const& request) {
        return child_->AsyncCreateExternalAccessRule(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateExternalAccessRule(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 CreateExternalAccessRuleRequest const& request) {
        return child_->CreateExternalAccessRule(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateExternalAccessRule(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 UpdateExternalAccessRuleRequest const& request) {
        return child_->AsyncUpdateExternalAccessRule(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateExternalAccessRule(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 UpdateExternalAccessRuleRequest const& request) {
        return child_->UpdateExternalAccessRule(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteExternalAccessRule(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 DeleteExternalAccessRuleRequest const& request) {
        return child_->AsyncDeleteExternalAccessRule(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeleteExternalAccessRule(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 DeleteExternalAccessRuleRequest const& request) {
        return child_->DeleteExternalAccessRule(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListLoggingServersResponse>
VmwareEngineLogging::ListLoggingServers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListLoggingServersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ListLoggingServersRequest const&
                 request) {
        return child_->ListLoggingServers(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::LoggingServer>
VmwareEngineLogging::GetLoggingServer(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetLoggingServerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetLoggingServerRequest const&
                 request) {
        return child_->GetLoggingServer(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateLoggingServer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
                 request) {
        return child_->AsyncCreateLoggingServer(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateLoggingServer(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
                 request) {
        return child_->CreateLoggingServer(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateLoggingServer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
                 request) {
        return child_->AsyncUpdateLoggingServer(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateLoggingServer(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
                 request) {
        return child_->UpdateLoggingServer(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteLoggingServer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
                 request) {
        return child_->AsyncDeleteLoggingServer(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeleteLoggingServer(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
                 request) {
        return child_->DeleteLoggingServer(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListNodeTypesResponse>
VmwareEngineLogging::ListNodeTypes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListNodeTypesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ListNodeTypesRequest const&
                 request) {
        return child_->ListNodeTypes(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineLogging::GetNodeType(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request) {
        return child_->GetNodeType(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineLogging::ShowNsxCredentials(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const&
                 request) {
        return child_->ShowNsxCredentials(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineLogging::ShowVcenterCredentials(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
              request) {
        return child_->ShowVcenterCredentials(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncResetNsxCredentials(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
                 request) {
        return child_->AsyncResetNsxCredentials(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::ResetNsxCredentials(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
                 request) {
        return child_->ResetNsxCredentials(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncResetVcenterCredentials(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
              request) {
        return child_->AsyncResetVcenterCredentials(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::ResetVcenterCredentials(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
              request) {
        return child_->ResetVcenterCredentials(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>
VmwareEngineLogging::GetDnsForwarding(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetDnsForwardingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetDnsForwardingRequest const&
                 request) {
        return child_->GetDnsForwarding(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateDnsForwarding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
                 request) {
        return child_->AsyncUpdateDnsForwarding(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateDnsForwarding(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
                 request) {
        return child_->UpdateDnsForwarding(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>
VmwareEngineLogging::GetNetworkPeering(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetNetworkPeeringRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetNetworkPeeringRequest const&
                 request) {
        return child_->GetNetworkPeering(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListNetworkPeeringsResponse>
VmwareEngineLogging::ListNetworkPeerings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListNetworkPeeringsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ListNetworkPeeringsRequest const&
                 request) {
        return child_->ListNetworkPeerings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateNetworkPeering(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
                 request) {
        return child_->AsyncCreateNetworkPeering(cq, std::move(context),
                                                 std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateNetworkPeering(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
                 request) {
        return child_->CreateNetworkPeering(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteNetworkPeering(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
                 request) {
        return child_->AsyncDeleteNetworkPeering(cq, std::move(context),
                                                 std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeleteNetworkPeering(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
                 request) {
        return child_->DeleteNetworkPeering(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateNetworkPeering(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
                 request) {
        return child_->AsyncUpdateNetworkPeering(cq, std::move(context),
                                                 std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateNetworkPeering(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
                 request) {
        return child_->UpdateNetworkPeering(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListPeeringRoutesResponse>
VmwareEngineLogging::ListPeeringRoutes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListPeeringRoutesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ListPeeringRoutesRequest const&
                 request) {
        return child_->ListPeeringRoutes(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateHcxActivationKey(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
              request) {
        return child_->AsyncCreateHcxActivationKey(cq, std::move(context),
                                                   std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateHcxActivationKey(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
              request) {
        return child_->CreateHcxActivationKey(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListHcxActivationKeysResponse>
VmwareEngineLogging::ListHcxActivationKeys(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest const&
              request) {
        return child_->ListHcxActivationKeys(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineLogging::GetHcxActivationKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
                 request) {
        return child_->GetHcxActivationKey(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineLogging::GetNetworkPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const&
                 request) {
        return child_->GetNetworkPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListNetworkPoliciesResponse>
VmwareEngineLogging::ListNetworkPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest const&
                 request) {
        return child_->ListNetworkPolicies(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateNetworkPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
                 request) {
        return child_->AsyncCreateNetworkPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateNetworkPolicy(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
                 request) {
        return child_->CreateNetworkPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateNetworkPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
                 request) {
        return child_->AsyncUpdateNetworkPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateNetworkPolicy(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
                 request) {
        return child_->UpdateNetworkPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteNetworkPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
                 request) {
        return child_->AsyncDeleteNetworkPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeleteNetworkPolicy(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
                 request) {
        return child_->DeleteNetworkPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListManagementDnsZoneBindingsResponse>
VmwareEngineLogging::ListManagementDnsZoneBindings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListManagementDnsZoneBindingsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 ListManagementDnsZoneBindingsRequest const& request) {
        return child_->ListManagementDnsZoneBindings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
VmwareEngineLogging::GetManagementDnsZoneBinding(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetManagementDnsZoneBindingRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 GetManagementDnsZoneBindingRequest const& request) {
        return child_->GetManagementDnsZoneBinding(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateManagementDnsZoneBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::
        CreateManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 CreateManagementDnsZoneBindingRequest const& request) {
        return child_->AsyncCreateManagementDnsZoneBinding(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateManagementDnsZoneBinding(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::
        CreateManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 CreateManagementDnsZoneBindingRequest const& request) {
        return child_->CreateManagementDnsZoneBinding(context, options,
                                                      request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateManagementDnsZoneBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::
        UpdateManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 UpdateManagementDnsZoneBindingRequest const& request) {
        return child_->AsyncUpdateManagementDnsZoneBinding(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateManagementDnsZoneBinding(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::
        UpdateManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 UpdateManagementDnsZoneBindingRequest const& request) {
        return child_->UpdateManagementDnsZoneBinding(context, options,
                                                      request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteManagementDnsZoneBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::
        DeleteManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 DeleteManagementDnsZoneBindingRequest const& request) {
        return child_->AsyncDeleteManagementDnsZoneBinding(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeleteManagementDnsZoneBinding(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::
        DeleteManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 DeleteManagementDnsZoneBindingRequest const& request) {
        return child_->DeleteManagementDnsZoneBinding(context, options,
                                                      request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncRepairManagementDnsZoneBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::
        RepairManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 RepairManagementDnsZoneBindingRequest const& request) {
        return child_->AsyncRepairManagementDnsZoneBinding(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::RepairManagementDnsZoneBinding(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::
        RepairManagementDnsZoneBindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 RepairManagementDnsZoneBindingRequest const& request) {
        return child_->RepairManagementDnsZoneBinding(context, options,
                                                      request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreateVmwareEngineNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 CreateVmwareEngineNetworkRequest const& request) {
        return child_->AsyncCreateVmwareEngineNetwork(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreateVmwareEngineNetwork(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 CreateVmwareEngineNetworkRequest const& request) {
        return child_->CreateVmwareEngineNetwork(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdateVmwareEngineNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 UpdateVmwareEngineNetworkRequest const& request) {
        return child_->AsyncUpdateVmwareEngineNetwork(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdateVmwareEngineNetwork(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 UpdateVmwareEngineNetworkRequest const& request) {
        return child_->UpdateVmwareEngineNetwork(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeleteVmwareEngineNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::vmwareengine::v1::
                 DeleteVmwareEngineNetworkRequest const& request) {
        return child_->AsyncDeleteVmwareEngineNetwork(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeleteVmwareEngineNetwork(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 DeleteVmwareEngineNetworkRequest const& request) {
        return child_->DeleteVmwareEngineNetwork(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineLogging::GetVmwareEngineNetwork(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
              request) {
        return child_->GetVmwareEngineNetwork(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListVmwareEngineNetworksResponse>
VmwareEngineLogging::ListVmwareEngineNetworks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 ListVmwareEngineNetworksRequest const& request) {
        return child_->ListVmwareEngineNetworks(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncCreatePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
              request) {
        return child_->AsyncCreatePrivateConnection(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::CreatePrivateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
              request) {
        return child_->CreatePrivateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineLogging::GetPrivateConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
                 request) {
        return child_->GetPrivateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::ListPrivateConnectionsResponse>
VmwareEngineLogging::ListPrivateConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest const&
              request) {
        return child_->ListPrivateConnections(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncUpdatePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
              request) {
        return child_->AsyncUpdatePrivateConnection(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::UpdatePrivateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
              request) {
        return child_->UpdatePrivateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncDeletePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
              request) {
        return child_->AsyncDeletePrivateConnection(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::DeletePrivateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
              request) {
        return child_->DeletePrivateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<
    google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesResponse>
VmwareEngineLogging::ListPrivateConnectionPeeringRoutes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::
        ListPrivateConnectionPeeringRoutesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::
                 ListPrivateConnectionPeeringRoutesRequest const& request) {
        return child_->ListPrivateConnectionPeeringRoutes(context, options,
                                                          request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncGrantDnsBindPermission(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
              request) {
        return child_->AsyncGrantDnsBindPermission(cq, std::move(context),
                                                   std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::GrantDnsBindPermission(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
              request) {
        return child_->GrantDnsBindPermission(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>
VmwareEngineLogging::GetDnsBindPermission(
    grpc::ClientContext& context, Options const& options,
    google::cloud::vmwareengine::v1::GetDnsBindPermissionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::vmwareengine::v1::GetDnsBindPermissionRequest const&
                 request) {
        return child_->GetDnsBindPermission(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncRevokeDnsBindPermission(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
              request) {
        return child_->AsyncRevokeDnsBindPermission(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
VmwareEngineLogging::RevokeDnsBindPermission(
    grpc::ClientContext& context, Options options,
    google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
              request) {
        return child_->RevokeDnsBindPermission(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
VmwareEngineLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> VmwareEngineLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1_internal
}  // namespace cloud
}  // namespace google
