// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package traces

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceTracesOKCode is the HTTP code returned for type ReplaceTracesOK
const ReplaceTracesOKCode int = 200

/*
ReplaceTracesOK Traces replaced

swagger:response replaceTracesOK
*/
type ReplaceTracesOK struct {

	/*
	  In: Body
	*/
	Payload *models.Traces `json:"body,omitempty"`
}

// NewReplaceTracesOK creates ReplaceTracesOK with default headers values
func NewReplaceTracesOK() *ReplaceTracesOK {

	return &ReplaceTracesOK{}
}

// WithPayload adds the payload to the replace traces o k response
func (o *ReplaceTracesOK) WithPayload(payload *models.Traces) *ReplaceTracesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace traces o k response
func (o *ReplaceTracesOK) SetPayload(payload *models.Traces) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTracesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTracesAcceptedCode is the HTTP code returned for type ReplaceTracesAccepted
const ReplaceTracesAcceptedCode int = 202

/*
ReplaceTracesAccepted Configuration change accepted and reload requested

swagger:response replaceTracesAccepted
*/
type ReplaceTracesAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Traces `json:"body,omitempty"`
}

// NewReplaceTracesAccepted creates ReplaceTracesAccepted with default headers values
func NewReplaceTracesAccepted() *ReplaceTracesAccepted {

	return &ReplaceTracesAccepted{}
}

// WithReloadID adds the reloadId to the replace traces accepted response
func (o *ReplaceTracesAccepted) WithReloadID(reloadID string) *ReplaceTracesAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace traces accepted response
func (o *ReplaceTracesAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace traces accepted response
func (o *ReplaceTracesAccepted) WithPayload(payload *models.Traces) *ReplaceTracesAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace traces accepted response
func (o *ReplaceTracesAccepted) SetPayload(payload *models.Traces) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTracesAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTracesBadRequestCode is the HTTP code returned for type ReplaceTracesBadRequest
const ReplaceTracesBadRequestCode int = 400

/*
ReplaceTracesBadRequest Bad request

swagger:response replaceTracesBadRequest
*/
type ReplaceTracesBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTracesBadRequest creates ReplaceTracesBadRequest with default headers values
func NewReplaceTracesBadRequest() *ReplaceTracesBadRequest {

	return &ReplaceTracesBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace traces bad request response
func (o *ReplaceTracesBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceTracesBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace traces bad request response
func (o *ReplaceTracesBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace traces bad request response
func (o *ReplaceTracesBadRequest) WithPayload(payload *models.Error) *ReplaceTracesBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace traces bad request response
func (o *ReplaceTracesBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTracesBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTracesNotFoundCode is the HTTP code returned for type ReplaceTracesNotFound
const ReplaceTracesNotFoundCode int = 404

/*
ReplaceTracesNotFound The specified resource was not found

swagger:response replaceTracesNotFound
*/
type ReplaceTracesNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTracesNotFound creates ReplaceTracesNotFound with default headers values
func NewReplaceTracesNotFound() *ReplaceTracesNotFound {

	return &ReplaceTracesNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace traces not found response
func (o *ReplaceTracesNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceTracesNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace traces not found response
func (o *ReplaceTracesNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace traces not found response
func (o *ReplaceTracesNotFound) WithPayload(payload *models.Error) *ReplaceTracesNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace traces not found response
func (o *ReplaceTracesNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTracesNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceTracesDefault General Error

swagger:response replaceTracesDefault
*/
type ReplaceTracesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTracesDefault creates ReplaceTracesDefault with default headers values
func NewReplaceTracesDefault(code int) *ReplaceTracesDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceTracesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace traces default response
func (o *ReplaceTracesDefault) WithStatusCode(code int) *ReplaceTracesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace traces default response
func (o *ReplaceTracesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace traces default response
func (o *ReplaceTracesDefault) WithConfigurationVersion(configurationVersion string) *ReplaceTracesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace traces default response
func (o *ReplaceTracesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace traces default response
func (o *ReplaceTracesDefault) WithPayload(payload *models.Error) *ReplaceTracesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace traces default response
func (o *ReplaceTracesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTracesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
