// Copyright (c) 2012 Jeff Ichnowski
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
//     * Redistributions of source code must retain the above
//       copyright notice, this list of conditions and the following
//       disclaimer.
//
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials
//       provided with the distribution.
//
//     * Neither the name of the OWASP nor the names of its
//       contributors may be used to endorse or promote products
//       derived from this software without specific prior written
//       permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
// FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
// COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.

package org.owasp.encoder;

import junit.framework.Test;
import junit.framework.TestCase;

/**
 * JavaEncoderTest -- test suite for the JavaEncoder.
 *
 * @author Jeff Ichnowski
 */
public class JavaEncoderTest extends TestCase {
    public static Test suite() {
        return new EncoderTestSuiteBuilder(new JavaEncoder(), "-safe-", "'")
            .encode("\\'", "\'")
            .encode("\\\"", "\"")
            .encode("\\\\", "\\")
            .encode("abc123XYZ", "abc123XYZ")
            .encode("\\b", "\\b", "\b")
            .encode("\\t", "\\t", "\t")
            .encode("\\n", "\\n", "\n")
            .encode("\\f", "\\f", "\f")
            .encode("\\r", "\\r", "\r")
            .encode("\\0", "\\0", "\0")
            .encode("\\17", "\\17", "\17")
            .encode("\\377", "\\377", "\377")
            .encode("\\u1234", "\\u1234", "\u1234")
            .encode("\\uabcd", "\\uabcd", "\uabcd")
            .encode("invalid-surrogate", "\\udc00", "\udc00") // are okay
            .encode("\\0\\0", "\\0\\0", "\0\0")
            .encode("\\0 + '0'", "\\0000", "\0000")
            .encode("\\37 + '0'", "\\0370", "\0370")

            .encoded(0, Character.MAX_CODE_POINT)
            .valid(' ', '~')
            .encoded("\"\'\\")

            .validSuite()
            .encodedSuite()

            .build();
    }
}
