// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/ruleset_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTENTWAREHOUSE_V1_RULE_SET_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTENTWAREHOUSE_V1_RULE_SET_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/contentwarehouse/v1/ruleset_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RuleSetServiceConnectionIdempotencyPolicy {
 public:
  virtual ~RuleSetServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<RuleSetServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateRuleSet(
      google::cloud::contentwarehouse::v1::CreateRuleSetRequest const& request);

  virtual google::cloud::Idempotency GetRuleSet(
      google::cloud::contentwarehouse::v1::GetRuleSetRequest const& request);

  virtual google::cloud::Idempotency UpdateRuleSet(
      google::cloud::contentwarehouse::v1::UpdateRuleSetRequest const& request);

  virtual google::cloud::Idempotency DeleteRuleSet(
      google::cloud::contentwarehouse::v1::DeleteRuleSetRequest const& request);

  virtual google::cloud::Idempotency ListRuleSets(
      google::cloud::contentwarehouse::v1::ListRuleSetsRequest request);
};

std::unique_ptr<RuleSetServiceConnectionIdempotencyPolicy>
MakeDefaultRuleSetServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTENTWAREHOUSE_V1_RULE_SET_CONNECTION_IDEMPOTENCY_POLICY_H
