// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/flow.proto

#include "google/cloud/dialogflow_cx/flows_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FlowsClient::FlowsClient(std::shared_ptr<FlowsConnection> connection,
                         Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
FlowsClient::~FlowsClient() = default;

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::CreateFlow(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::Flow const& flow, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateFlowRequest request;
  request.set_parent(parent);
  *request.mutable_flow() = flow;
  return connection_->CreateFlow(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::CreateFlow(
    google::cloud::dialogflow::cx::v3::CreateFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateFlow(request);
}

Status FlowsClient::DeleteFlow(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteFlowRequest request;
  request.set_name(name);
  return connection_->DeleteFlow(request);
}

Status FlowsClient::DeleteFlow(
    google::cloud::dialogflow::cx::v3::DeleteFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFlow(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::ListFlows(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListFlowsRequest request;
  request.set_parent(parent);
  return connection_->ListFlows(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::ListFlows(
    google::cloud::dialogflow::cx::v3::ListFlowsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFlows(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::GetFlow(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetFlowRequest request;
  request.set_name(name);
  return connection_->GetFlow(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::GetFlow(
    google::cloud::dialogflow::cx::v3::GetFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFlow(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::UpdateFlow(
    google::cloud::dialogflow::cx::v3::Flow const& flow,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateFlowRequest request;
  *request.mutable_flow() = flow;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateFlow(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsClient::UpdateFlow(
    google::cloud::dialogflow::cx::v3::UpdateFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFlow(request);
}

future<StatusOr<google::protobuf::Struct>> FlowsClient::TrainFlow(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::TrainFlowRequest request;
  request.set_name(name);
  return connection_->TrainFlow(request);
}

future<StatusOr<google::protobuf::Struct>> FlowsClient::TrainFlow(
    google::cloud::dialogflow::cx::v3::TrainFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TrainFlow(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::FlowValidationResult>
FlowsClient::ValidateFlow(
    google::cloud::dialogflow::cx::v3::ValidateFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ValidateFlow(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::FlowValidationResult>
FlowsClient::GetFlowValidationResult(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetFlowValidationResultRequest request;
  request.set_name(name);
  return connection_->GetFlowValidationResult(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::FlowValidationResult>
FlowsClient::GetFlowValidationResult(
    google::cloud::dialogflow::cx::v3::GetFlowValidationResultRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFlowValidationResult(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ImportFlowResponse>>
FlowsClient::ImportFlow(
    google::cloud::dialogflow::cx::v3::ImportFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportFlow(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ExportFlowResponse>>
FlowsClient::ExportFlow(
    google::cloud::dialogflow::cx::v3::ExportFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportFlow(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
