// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policysimulator/v1/simulator.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYSIMULATOR_V1_INTERNAL_SIMULATOR_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYSIMULATOR_V1_INTERNAL_SIMULATOR_CONNECTION_IMPL_H

#include "google/cloud/policysimulator/v1/internal/simulator_retry_traits.h"
#include "google/cloud/policysimulator/v1/internal/simulator_stub.h"
#include "google/cloud/policysimulator/v1/simulator_connection.h"
#include "google/cloud/policysimulator/v1/simulator_connection_idempotency_policy.h"
#include "google/cloud/policysimulator/v1/simulator_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace policysimulator_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SimulatorConnectionImpl : public policysimulator_v1::SimulatorConnection {
 public:
  ~SimulatorConnectionImpl() override = default;

  SimulatorConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<policysimulator_v1_internal::SimulatorStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::policysimulator::v1::Replay> GetReplay(
      google::cloud::policysimulator::v1::GetReplayRequest const& request)
      override;

  future<StatusOr<google::cloud::policysimulator::v1::Replay>> CreateReplay(
      google::cloud::policysimulator::v1::CreateReplayRequest const& request)
      override;

  StreamRange<google::cloud::policysimulator::v1::ReplayResult>
  ListReplayResults(google::cloud::policysimulator::v1::ListReplayResultsRequest
                        request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<policysimulator_v1_internal::SimulatorStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policysimulator_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYSIMULATOR_V1_INTERNAL_SIMULATOR_CONNECTION_IMPL_H
