// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/schema.proto

#include "google/cloud/pubsub/internal/schema_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SchemaServiceTracingStub::SchemaServiceTracingStub(
    std::shared_ptr<SchemaServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::pubsub::v1::Schema> SchemaServiceTracingStub::CreateSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::CreateSchemaRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.SchemaService", "CreateSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateSchema(context, request));
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceTracingStub::GetSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::GetSchemaRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.SchemaService", "GetSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetSchema(context, request));
}

StatusOr<google::pubsub::v1::ListSchemasResponse>
SchemaServiceTracingStub::ListSchemas(
    grpc::ClientContext& context,
    google::pubsub::v1::ListSchemasRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.SchemaService", "ListSchemas");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSchemas(context, request));
}

StatusOr<google::pubsub::v1::ListSchemaRevisionsResponse>
SchemaServiceTracingStub::ListSchemaRevisions(
    grpc::ClientContext& context,
    google::pubsub::v1::ListSchemaRevisionsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.SchemaService",
                                     "ListSchemaRevisions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSchemaRevisions(context, request));
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceTracingStub::CommitSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::CommitSchemaRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.SchemaService", "CommitSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CommitSchema(context, request));
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceTracingStub::RollbackSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::RollbackSchemaRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.SchemaService",
                                     "RollbackSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RollbackSchema(context, request));
}

StatusOr<google::pubsub::v1::Schema>
SchemaServiceTracingStub::DeleteSchemaRevision(
    grpc::ClientContext& context,
    google::pubsub::v1::DeleteSchemaRevisionRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.SchemaService",
                                     "DeleteSchemaRevision");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteSchemaRevision(context, request));
}

Status SchemaServiceTracingStub::DeleteSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::DeleteSchemaRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.SchemaService", "DeleteSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteSchema(context, request));
}

StatusOr<google::pubsub::v1::ValidateSchemaResponse>
SchemaServiceTracingStub::ValidateSchema(
    grpc::ClientContext& context,
    google::pubsub::v1::ValidateSchemaRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.SchemaService",
                                     "ValidateSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ValidateSchema(context, request));
}

StatusOr<google::pubsub::v1::ValidateMessageResponse>
SchemaServiceTracingStub::ValidateMessage(
    grpc::ClientContext& context,
    google::pubsub::v1::ValidateMessageRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.SchemaService",
                                     "ValidateMessage");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ValidateMessage(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<SchemaServiceStub> MakeSchemaServiceTracingStub(
    std::shared_ptr<SchemaServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<SchemaServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
