Summary: GNU ccScript - a GNU Common C++ framework for embedded scripting
Name: ccscript2
Version: 2.5.7
Release: 15
Group: Development/Libraries
URL: http://www.gnu.org/software/ccscript
Source: ftp://ftp.gnu.org/gnu/ccscript/ccscript-%{PACKAGE_VERSION}.tar.gz
Prefix: %{_prefix}
Copyright: GPL
BuildRoot: %{_tmppath}/ccscript-root
Packager: David Sugar <dyfet@ostel.com>
Requires: commoncpp2 >= 1.0.0

%package devel
Requires: ccscript2, commoncpp2-devel
Group: Development/Libraries
Summary: headers and link libraries for GNU ccScript.


%description
The GNU ccScript package offers a class extensible threaded embedded
scripting engine for use with GNU Common C++.  This engine is also used in 
GNU Bayonne (the GNU telephony applicatiion server package) and other 
parts of GNUCOMM (the GNU telephony meta-project). This engine differs 
from traditional scripting systems in that it is used to script near 
real-time state-event systems through deterministic callback step 
execution rather than the linear and non-deterministic fashion of embedded 
script systems such as tcl, libguile, etc.

%description devel
This package holds documentation, header files, and static link libraries
for building applications that use GNU ccScript.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -n ccscript-%{PACKAGE_VERSION}
./configure --prefix=%{_prefix}

%build
uname -a|grep SMP && make -j 2 || make

%install
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man3
make prefix=$RPM_BUILD_ROOT/%{_prefix} \
	mandir=$RPM_BUILD_ROOT/%{_mandir} install
make prefix=$RPM_BUILD_ROOT/%{_prefix} \
	mandir=$RPM_BUILD_ROOT/%{_mandir} man
strip $RPM_BUILD_ROOT/%{_prefix}/lib/libcc*.so.*

%files
%defattr(-,root,root,0755)
%{_prefix}/lib/libcc*so*
%{_prefix}/bin/ccscript
%{_prefix}/lib/ccscript2

%files devel
%defattr(-,root,root,0755)
%doc AUTHORS COPYING NEWS README TODO ChangeLog
%{_prefix}/lib/libcc*a
%{_prefix}/include/cc++2/cc++/script.h
%{_mandir}/man3/*.3cc*

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig -n ${exec_prefix}/lib

%postun
/sbin/ldconfig -n ${exec_prefix}/lib

