;;; 
;;; $Id: examples.lsp,v 1.1.1.9 1996/05/08 12:22:50 pierpa Exp $
;;; 
;;; Some examples for show-tree.
;;; 
;;; Examples 1..n, n < 3 will show two trees produced by xref.
;;; Xref is a lisp cross-referencer available from the lisp repository.
;;; 
;;; Examples 3..n, n < 5 will show a random ordered binary tree.
;;; 
;;; Examples 5..6 will show two good ole cons trees.
;;; 

(require :show-tree)

(defun show-examples ()
  (let ((show-tree::*default-handle-events* nil))
    (example-6)
    (example-5)
    (example-4.5)
    (example-4)
    (example-3)
    (example-2.6)
    (example-2.5)
    (example-2)
    (example-1)
    (show-tree:handle-events :until-shutdown t)
    ))

    
;;; If you have xref installed, you can use the following
;;; function to show the call graph of a file containing
;;; lisp code.

#|
(require :xref)

(defun show-callers (file)
  (xref:xref-file file)
  (show-tree:show-tree #'xref-is-leaf-p #'xref-branches #'xref-label
	     (list "top level" (xref:make-caller-tree))))

|#

;;; functions for trees produced by xref.

(defun xref-is-leaf-p (tree)
  (not (listp tree)))

(defun xref-branches (tree)
  (cadr tree))

(defun xref-label (tree)
  (if (xref-is-leaf-p tree)
      tree
      (car tree)))

(defun xref-make-tree (root branches)
  (list root branches))

;;; Some example trees

(defvar tree-uprint
  (list "top level"			; Xref returns a forest, not a tree,
	'(("TEST-1"			;  so I add a top node.
	   (("UPRINT"
	     (("SET-STYLE"
	       (("STYLE-VANILLA"
		 ("GLOBULO-VANILLA" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*")))))
		 )
		("STYLE-ARROWS"
		 (("STYLE-VANILLA"
		   ("GLOBULO-VANILLA"
		    ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		    ) ))  )
		("STYLE-PC"
		 (("STYLE-VANILLA"
		   ("GLOBULO-VANILLA"
		    ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		    )  )
		  "GLOBULO-PC" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		  ) )
		("STYLE-DEC"
		 (("STYLE-PC"
		   (("STYLE-VANILLA"
		     ("GLOBULO-VANILLA"
		      ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		      )  )
		    "GLOBULO-PC" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		    )  )
		  "GLOBULO-DEC" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		  )  ) ) )
	      "MAKE-PAGE"
	      ("DRAW"
	       (("DRAW-CONS"
		 ("WIDTH"
		  ("GRAF-CONS"
		   (("BOX"
		     (("GLOBULO" ("*GLOBULO*"))
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("ONE-ROW"
		       ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
					 ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
					 ("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) )
					 ("INS-N-CHAR"
					  (("INS-CHAR"
					    ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							      "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							      ) ))  )
					 ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
					 )  ) ) )
		    "SYSTEM::BACKQUOTE"
		    ) )
		  "SIMPLE-THING-P"
		  ("DRAW-SIMPLE-THING"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) )
		  "DRAW"
		  ("XHJOIN"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("GLOBULO" ("*GLOBULO*"))
		    ("HJOIN"
		     (("HLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-N-CHAR"
			 (("INS-CHAR"
			   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					     "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					     )  ) ) ))  )
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("INS-CHAR"
		       ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					 "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					 ) )
		      ("VLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-CHAR"
			 ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					   "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					   ) ) ) ) ) ) ) )
		  "THICKNESS"
		  ("XVJOIN"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("GLOBULO" ("*GLOBULO*"))
		    ("VJOIN"
		     (("VLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-CHAR"
			 ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					   "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					   )  ) ) )
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("INS-CHAR"
		       ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					 "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					 ) )
		      ("HLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-N-CHAR"
			 (("INS-CHAR"
			   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					     "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					     )  ) ) ) ) ) ) ) ) ))  )
		("DRAW-SIMPLE-THING"
		 (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		  ("INS-STRING"
		   ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				     ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				     ("INS-CHAR"
				      ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							"PAGE-CARATTERI" "POSIZIONE-COLUMN"
							) ) ) ) ) )
		("DRAW-COMPLEX-THING"
		 ("BOUNDING-RECTANGLE"
		  ("BOX"
		   (("GLOBULO" ("*GLOBULO*"))
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("ONE-ROW"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) )
				       ("INS-N-CHAR"
					(("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) ))  )
				       ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
				       ) ) ) )
		  "SYSTEM::BACKQUOTE" ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		  ("INS-STRING"
		   ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				     ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				     ("INS-CHAR"
				      ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							"PAGE-CARATTERI" "POSIZIONE-COLUMN"
							) ) ) ) ) )
		("DRAW-VECTOR"
		 (("LIST-OF-THE-WIDTHS-OF-THE-VECTOR" ("WIDTH")) "COMPUTE-COLUMNS"
		  ("BOX"
		   (("GLOBULO" ("*GLOBULO*"))
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("ONE-ROW"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) )
				       ("INS-N-CHAR"
					(("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) ))  )
				       ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
				       ) ) ) )
		  ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		  ("INS-CHAR"
		   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE" "PAGE-CARATTERI"
				     "POSIZIONE-COLUMN"
				     ) )
		  "SIMPLE-THING-P"
		  ("DRAW-SIMPLE-THING"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) )
		  "DRAW"
		  ("XVJOIN"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("GLOBULO" ("*GLOBULO*"))
		    ("VJOIN"
		     (("VLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-CHAR"
			 ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					   "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					   )  ) ) )
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("INS-CHAR"
		       ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					 "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					 ) )
		      ("HLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-N-CHAR"
			 (("INS-CHAR"
			   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					     "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					     ) ) ) ) ) ) ) ))  )
		  "THICKNESS"
		  ) )
		("DRAW-HASH-TABLE"
		 (":UNNAMED-LAMBDA"
		  ("DRAW-TABLE"
		   (("COMPUTE-TABLE-ROWS-AND-COLUMNS-DIMENSIONS" ("BOUNDING-RECTANGLE"))
		    ("BOX"
		     (("GLOBULO" ("*GLOBULO*"))
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("ONE-ROW"
		       ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
					 ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
					 ("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) )
					 ("INS-N-CHAR"
					  (("INS-CHAR"
					    ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							      "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							      ) ))  )
					 ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
					 ) ) ) )
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) ) ) )
		("DRAW-STRUCTURE"
		 (("GET-STRUCTURE-INFO" (":UNNAMED-LAMBDA" "SLOT-VALUE"))
		  ("DRAW-TABLE"
		   (("COMPUTE-TABLE-ROWS-AND-COLUMNS-DIMENSIONS" ("BOUNDING-RECTANGLE"))
		    ("BOX"
		     (("GLOBULO" ("*GLOBULO*"))
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("ONE-ROW"
		       ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
					 ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
					 ("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) )
					 ("INS-N-CHAR"
					  (("INS-CHAR"
					    ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							      "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							      ) ))  )
					 ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
					 ) ) ) )
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) ) ) ) ) )
	      ("WRITE-PAGE"
	       ("PAGE-CARATTERI"
		("SQUEEZE"
		 (("UNIQ" ("KEY" "PRED"))
		  ("TELETYPE-ORDERED-P" ("POSIZIONE-ROW" "POSIZIONE-COLUMN"))
		  "CARATTERE-POSIZIONE"
		  ("THESE-TWO-CHARACTERS-ARE-IN-THE-SAME-POSITION-P"
		   ("CARATTERE-POSIZIONE")
		   ) ) )
		("WRITE-CHARACTERS"
		 ("POSIZIONE-ROW" "CARATTERE-POSIZIONE" "POSIZIONE-COLUMN"
				  "CARATTERE-CARATTERE"
				  )  ))  ) ) ) ) )
	  ("VERSION"
	   (("UPRINT"
	     (("SET-STYLE"
	       (("STYLE-VANILLA"
		 ("GLOBULO-VANILLA" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*")))))
		 )
		("STYLE-ARROWS"
		 (("STYLE-VANILLA"
		   ("GLOBULO-VANILLA"
		    ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		    ) ))  )
		("STYLE-PC"
		 (("STYLE-VANILLA"
		   ("GLOBULO-VANILLA"
		    ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		    )  )
		  "GLOBULO-PC" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		  ) )
		("STYLE-DEC"
		 (("STYLE-PC"
		   (("STYLE-VANILLA"
		     ("GLOBULO-VANILLA"
		      ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		      )  )
		    "GLOBULO-PC" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		    )  )
		  "GLOBULO-DEC" ("SET-THICKNESS-ARROWS" (("GLOBULO" ("*GLOBULO*"))))
		  )  ) ) )
	      "MAKE-PAGE"
	      ("DRAW"
	       (("DRAW-CONS"
		 ("WIDTH"
		  ("GRAF-CONS"
		   (("BOX"
		     (("GLOBULO" ("*GLOBULO*"))
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("ONE-ROW"
		       ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
					 ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
					 ("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) )
					 ("INS-N-CHAR"
					  (("INS-CHAR"
					    ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							      "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							      ) ))  )
					 ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
					 )  ) ) )
		    "SYSTEM::BACKQUOTE"
		    ) )
		  "SIMPLE-THING-P"
		  ("DRAW-SIMPLE-THING"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) )
		  "DRAW"
		  ("XHJOIN"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("GLOBULO" ("*GLOBULO*"))
		    ("HJOIN"
		     (("HLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-N-CHAR"
			 (("INS-CHAR"
			   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					     "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					     )  ) ) ))  )
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("INS-CHAR"
		       ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					 "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					 ) )
		      ("VLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-CHAR"
			 ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					   "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					   ) ) ) ) ) ) ) )
		  "THICKNESS"
		  ("XVJOIN"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("GLOBULO" ("*GLOBULO*"))
		    ("VJOIN"
		     (("VLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-CHAR"
			 ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					   "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					   )  ) ) )
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("INS-CHAR"
		       ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					 "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					 ) )
		      ("HLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-N-CHAR"
			 (("INS-CHAR"
			   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					     "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					     )  ) ) ) ) ) ) ) ) ))  )
		("DRAW-SIMPLE-THING"
		 (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		  ("INS-STRING"
		   ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				     ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				     ("INS-CHAR"
				      ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							"PAGE-CARATTERI" "POSIZIONE-COLUMN"
							) ) ) ) ) )
		("DRAW-COMPLEX-THING"
		 ("BOUNDING-RECTANGLE"
		  ("BOX"
		   (("GLOBULO" ("*GLOBULO*"))
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("ONE-ROW"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) )
				       ("INS-N-CHAR"
					(("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) ))  )
				       ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
				       ) ) ) )
		  "SYSTEM::BACKQUOTE" ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		  ("INS-STRING"
		   ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				     ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				     ("INS-CHAR"
				      ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							"PAGE-CARATTERI" "POSIZIONE-COLUMN"
							) ) ) ) ) )
		("DRAW-VECTOR"
		 (("LIST-OF-THE-WIDTHS-OF-THE-VECTOR" ("WIDTH")) "COMPUTE-COLUMNS"
		  ("BOX"
		   (("GLOBULO" ("*GLOBULO*"))
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("ONE-ROW"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) )
				       ("INS-N-CHAR"
					(("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) ))  )
				       ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
				       ) ) ) )
		  ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		  ("INS-CHAR"
		   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE" "PAGE-CARATTERI"
				     "POSIZIONE-COLUMN"
				     ) )
		  "SIMPLE-THING-P"
		  ("DRAW-SIMPLE-THING"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) )
		  "DRAW"
		  ("XVJOIN"
		   (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("GLOBULO" ("*GLOBULO*"))
		    ("VJOIN"
		     (("VLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-CHAR"
			 ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					   "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					   )  ) ) )
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("INS-CHAR"
		       ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					 "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					 ) )
		      ("HLINE"
		       (("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
			("INS-N-CHAR"
			 (("INS-CHAR"
			   ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
					     "PAGE-CARATTERI" "POSIZIONE-COLUMN"
					     ) ) ) ) ) ) ) ))  )
		  "THICKNESS"
		  ) )
		("DRAW-HASH-TABLE"
		 (":UNNAMED-LAMBDA"
		  ("DRAW-TABLE"
		   (("COMPUTE-TABLE-ROWS-AND-COLUMNS-DIMENSIONS" ("BOUNDING-RECTANGLE"))
		    ("BOX"
		     (("GLOBULO" ("*GLOBULO*"))
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("ONE-ROW"
		       ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
					 ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
					 ("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) )
					 ("INS-N-CHAR"
					  (("INS-CHAR"
					    ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							      "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							      ) ))  )
					 ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
					 ) ) ) )
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) ) ) )
		("DRAW-STRUCTURE"
		 (("GET-STRUCTURE-INFO" (":UNNAMED-LAMBDA" "SLOT-VALUE"))
		  ("DRAW-TABLE"
		   (("COMPUTE-TABLE-ROWS-AND-COLUMNS-DIMENSIONS" ("BOUNDING-RECTANGLE"))
		    ("BOX"
		     (("GLOBULO" ("*GLOBULO*"))
		      ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		      ("ONE-ROW"
		       ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
					 ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
					 ("INS-CHAR"
					  ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							    "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							    ) )
					 ("INS-N-CHAR"
					  (("INS-CHAR"
					    ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							      "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							      ) ))  )
					 ("FORWARD-CURSOR" ("POSIZIONE-COLUMN" "PAGE-POSIZIONE"))
					 ) ) ) )
		    ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
		    ("INS-CHAR"
		     ("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
				       "PAGE-CARATTERI" "POSIZIONE-COLUMN"
				       ) )
		    ("INS-STRING"
		     ("PAGE-POSIZIONE" "POSIZIONE-ROW" "POSIZIONE-COLUMN"
				       ("SET-CURSOR" ("PAGE-POSIZIONE" "CREA-POS"))
				       ("INS-CHAR"
					("MAKE-CARATTERE" "COPY-POSIZIONE" "PAGE-POSIZIONE"
							  "PAGE-CARATTERI" "POSIZIONE-COLUMN"
							  ) ) ) ) ) ) ) ) ) )
	      ("WRITE-PAGE"
	       ("PAGE-CARATTERI"
		("SQUEEZE"
		 (("UNIQ" ("KEY" "PRED"))
		  ("TELETYPE-ORDERED-P" ("POSIZIONE-ROW" "POSIZIONE-COLUMN"))
		  "CARATTERE-POSIZIONE"
		  ("THESE-TWO-CHARACTERS-ARE-IN-THE-SAME-POSITION-P"
		   ("CARATTERE-POSIZIONE")
		   ) ) )
		("WRITE-CHARACTERS"
		 ("POSIZIONE-ROW" "CARATTERE-POSIZIONE" "POSIZIONE-COLUMN"
				  "CARATTERE-CARATTERE"
				  ) ))  ) ) ) ) )
	  "ONE-LINE-P" "INSTALL"
	  )))

(defvar tree-cav
  (list "top level"
	'(("ESISTE-CAMMINO"
	   ("CODA-VUOTA" "LCONC" ("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA")) "CODA-VUOTA?"
	    "STCONC" ("LIBERA?" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA")) "POSIZIONE-RIGA"
	    "POSIZIONE-COLONNA"
	    )  )
	  ("CAV"
	   (("GIRO-DI-CAVALLO"
	     (("CREA-POSIZIONE" ("MAKE-POSIZIONE"))
	      ("INIZIALIZZA"
	       ("SYSTEM::BACKQUOTE"
		("INIZIALIZZA-MOSSE-1"
		 (("FUNZ-ORD"
		   ("POSIZIONE-RIGA" "POSIZIONE-COLONNA" "DISTANZA-DAL-BORDO"
				     ":UNNAMED-LAMBDA" "ORD" ("DISTANZA-EUCLIDEA" ("SQR"))
				     )  )
		  ":UNNAMED-LAMBDA" "ORDINE-ESTERNO"
		  ("CALCOLA-MOSSE-POSSIBILI"
		   (("LISTA->POS" ("MAKE-POSIZIONE")) ":UNNAMED-LAMBDA"
		    "DENTRO-LA-SCACCHIERA?"
		    ) )
		  ("MISCHIA" ("LABELS")) "ORDINE-INTERNO"
		  ) )
		"INIZIALIZZA-STRADE-APERTE"
		) )
	      ("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
	      )  )
	    ("CREA-POSIZIONE" ("MAKE-POSIZIONE"))
	    ) )
	  ("SCA" ("SCRIVI")) "CALCOLA-QUANTI-CICLI-FARE-PRIMA-DI-POTARE"
	  ("CERCA-DI-POTARE"
	   (("CERCA-POSIZIONI-CHIUSE"
	     (("CREA-POSIZIONE" ("MAKE-POSIZIONE"))
	      ("POSIZIONE-CHIUSA?"
	       (("LIBERA?" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA")) ":UNNAMED-LAMBDA"
		("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
		)  ) ) )
	    ("INDIETRO"
	     (("LIBERA"
	       ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"
				 ("AUMENTA-SBOCCHI-TRA-I-VICINI-DI"
				  (("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
				   ("STRADE-APERTE" ("SYSTEM::BACKQUOTE"))
				   ) ))  ) ) )
	    ("POSIZIONE-CHIUSA?"
	     (("LIBERA?" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA")) ":UNNAMED-LAMBDA"
	      ("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
	      ) ) ) )
	  ("AVANTI"
	   (("LIBERA?" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
	    ("ORDINA-I-VICINI"
	     (":UNNAMED-LAMBDA"
	      ("QUANTI-VICINI-LIBERI"
	       (("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
		("LIBERA?" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
		) ) ) )
	    ("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA")) "OCCUPA"
	    ) )
	  ("DIMINUISCI-SBOCCHI-FORSE-TRA-I-VICINI-DI"
	   (("VICINI" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
	    ("STRADE-APERTE" ("SYSTEM::BACKQUOTE"))
	    ("LIBERA?" ("POSIZIONE-RIGA" "POSIZIONE-COLONNA"))
	    ) )
	  "TRACCIA"
	  ("EUREKA"
	   (("EUREKA3"
	     ("MAKE-SOLUZIONE" "UNIVERSAL-TIME-STRING" "LIB:FORMAT-BROKEN-INTERNAL-TIME")
	     ) ))
	  "EUREKA2" ("SCRIVI-TEMPO" ("LIB:FORMAT-BROKEN-INTERNAL-TIME" "BIP"))
	  ("EUREKA1" ("FLET")) "TCONC" "CODA->LISTA"
	  )))

(defun example-1 ()
  (show-tree:show-tree #'xref-is-leaf-p #'xref-branches #'xref-label
	     tree-cav
	     :Style :Round-Bus
	     :Title "Example 1"
	     ))

(defun example-2 ()
  (show-tree:show-tree #'xref-is-leaf-p #'xref-branches #'xref-label
	     tree-uprint
	     :Style :Bus
	     :Title "Example 2"
	     ))

(defun example-2.5 ()
  (show-tree:show-tree #'xref-is-leaf-p #'xref-branches #'xref-label
	     tree-uprint
	     :Style :Bus
	     :Title "Example 2.5.   It's not a bug, the leaves are supposed to overlap."
	     :vertical 0
	     :horizontal 20))

(defun example-2.6 ()
  (show-tree:show-tree #'xref-is-leaf-p #'xref-branches #'xref-label
	     tree-uprint
	     :Style :Segments
	     :Title "Example 2.6"
	     :vertical 1
	     :horizontal 40
	     :shadow 0
	     :hsize 900
	     :vsize 680
	     :font "-*-fixed-medium-r-*-*-7-*-*-*-*-*-*-*"
	     :window-pos :root
	     ))

;;================================================================

(defun bin-empty-tree ()
  :the-empty-binary-tree)
  
(defun bin-is-empty-p (tree)
  (eq tree :the-empty-binary-tree))

(defun bin-make-tree (root smaller greater)
  (list root smaller greater))

(defun bin-smaller (tree)
  (second tree))

(defun bin-greater (tree)
  (third tree))

(defun bin-root (tree)
  (first tree))

(defun bin-branches (tree)
  (rest tree))

(defun insert (item tree pred)
  (cond ((bin-is-empty-p tree)
	 (bin-make-tree item (bin-empty-tree) (bin-empty-tree)))
	(t
	 (cond ((funcall pred item (bin-root tree))
		(bin-make-tree (bin-root tree)
			       (insert item (bin-smaller tree) pred)
			       (bin-greater tree)))
	       ((funcall pred (bin-root tree) item)
		(bin-make-tree (bin-root tree)
			       (bin-smaller tree)
			       (insert item (bin-greater tree) pred)))
	       (t
		tree)))))

;;================================================================
;; A definition to please show-tree

(defun bin-label (tree)
  (cond ((bin-is-empty-p tree)
	 "  ")
	(t
	 (princ-to-string (bin-root tree)))))

;================================================================

(defun binexample (&rest chiavi
		   &key (quanti 100)
			(max 10000)
			(horizontal 20)
			(vertical 2)
			(title "Is this example 3 or example 4?")
		   &allow-other-keys)
  (declare (ignorable horizontal vertical)) ; XXXXXXX
  (apply #'show-tree:show-tree #'bin-is-empty-p #'bin-branches #'bin-label

	 (do ((i quanti (- i 1))
	      (tree (bin-empty-tree) (insert (random max) tree #'<)))
	     ((zerop i) tree))
	 
	 :title title
	 :hsize 600
	 :vsize 600
	 :horizontal horizontal
	 :vertical vertical
	 ;;:shadow nil
	 :allow-other-keys t
	 chiavi))

(defun example-3 ()
  (binexample :quanti 30
	      :style :Barrel-Arcs
	      :title "Example 3"
	      :shadow nil
	      ))

(defun example-4 ()
  (binexample :quanti 200
	      :style :Segments
	      :title "Example 4"
	      :window-pos :root
	      :shadow 4
	      ))

(defun example-4.5 ()
  (binexample :quanti 2000
	      :style :Segments
	      :title "Example 4.5"
	      :font "-*-*-*-*-*-*-2-*-*-*-*-*-*-*"
	      :vertical 1
	      :horizontal 20
	      :shadow nil
	      ))


;;================================================================

(defun show-sexpr (sexpr &rest keys)
  (apply #'show-tree:show-tree
	 #'atom
	 (lambda (x) (list (cdr x) (car x)))
	 (lambda (x) (if (atom x)
			 (format nil "~W" x)
			 "--"))
	 sexpr
	 :Horizontal 40
	 :Style :Segments
	 :window-pos :bottom
	 keys))

(defun example-5 ()
  (show-sexpr '(lambda (x) (+ x x))
	      :hsize 360
	      :vsize 230
	      :title "A close up view (magn. 10X) of (lambda (x) (+ x x)) "
	      ))

(defun example-6 ()
  (show-sexpr '
   (defun show-sexpr (sexpr &rest keys)
     (apply #'show-tree:show-tree
	    #'atom
	    (lambda (x) (list (cdr x) (car x)))
	    (lambda (x) (if (atom x)
			    (format nil "~W" x)
			    "--"))
	    sexpr
	    :Horizontal 40
	    :Style :Segments
	    keys))
   ))
