/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.logicaleffort.Instance;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.logicaleffort.Net;
import com.sun.electric.tool.logicaleffort.Pin;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LESizer {
    private Alg optimizationAlg;
    private PrintStream out;
    private Job job;
    private LENetlister netlist;

    protected LESizer(Alg alg, LENetlister netlist, Job job) {
        this.optimizationAlg = alg;
        this.netlist = netlist;
        this.job = job;
        this.out = new PrintStream(System.out);
    }

    protected boolean optimizeLoops(float maxDeltaX, int N, boolean verbose, float alpha, float keeperRatio) {
        float currentLoopDeltaX;
        float lastLoopDeltaX = currentLoopDeltaX = maxDeltaX + 1.0f;
        int divergingIters = 0;
        int loopcount = 0;
        while (currentLoopDeltaX > maxDeltaX && loopcount < N) {
            if (((LETool.AnalyzeCell)this.job).checkAbort(null)) {
                return false;
            }
            currentLoopDeltaX = 0.0f;
            long startTime = System.currentTimeMillis();
            System.out.print("  Iteration " + loopcount);
            if (verbose) {
                System.out.println(":");
            }
            Iterator instancesIter = this.netlist.getAllInstances().values().iterator();
            while (instancesIter.hasNext()) {
                float deltaX;
                float currentX;
                ArrayList outputPins;
                Instance instance = (Instance)instancesIter.next();
                String instanceName = instance.getName();
                if (!instance.isLeGate() || (outputPins = instance.getOutputPins()).size() != 1) continue;
                Pin outputPin = (Pin)outputPins.get(0);
                Net net = outputPin.getNet();
                ArrayList netpins = net.getAllPins();
                ArrayList<Instance> drivers = new ArrayList<Instance>();
                Iterator it = netpins.iterator();
                while (it.hasNext()) {
                    Instance inst;
                    Pin pin = (Pin)it.next();
                    if (pin.getDir() != Pin.Dir.OUTPUT || (inst = pin.getInstance()).getType() != instance.getType() || inst.getParallelGroup() != instance.getParallelGroup()) continue;
                    drivers.add(inst);
                }
                float newX = 0.0f;
                if (instance.getType() == Instance.Type.LEKEEPER) {
                    HashMap<String, ArrayList<Instance>> drivingGroups = new HashMap<String, ArrayList<Instance>>();
                    float smallestX = 0.0f;
                    Iterator it2 = netpins.iterator();
                    while (it2.hasNext()) {
                        ArrayList<Instance> groupList;
                        Instance inst;
                        Pin pin = (Pin)it2.next();
                        if (pin.getDir() != Pin.Dir.OUTPUT || (inst = pin.getInstance()).getType() != Instance.Type.LEGATE && inst.getType() != Instance.Type.STATICGATE) continue;
                        int i = inst.getParallelGroup();
                        Integer integer = new Integer(i);
                        if (i <= 0) {
                            if (smallestX == 0.0f) {
                                smallestX = inst.getLeX();
                            }
                            if (inst.getLeX() < smallestX) {
                                smallestX = inst.getLeX();
                            }
                        }
                        if ((groupList = (ArrayList<Instance>)drivingGroups.get(integer.toString())) == null) {
                            groupList = new ArrayList<Instance>();
                            drivingGroups.put(integer.toString(), groupList);
                        }
                        groupList.add(inst);
                    }
                    Set keys = drivingGroups.keySet();
                    Iterator it3 = keys.iterator();
                    while (it3.hasNext()) {
                        ArrayList groupList = (ArrayList)drivingGroups.get(it3.next());
                        if (groupList == null) continue;
                        float sizeX = 0.0f;
                        Iterator it22 = groupList.iterator();
                        while (it22.hasNext()) {
                            Instance inst = (Instance)it22.next();
                            sizeX += inst.getLeX();
                        }
                        if (smallestX == 0.0f) {
                            smallestX = sizeX;
                        }
                        if (!(sizeX < smallestX)) continue;
                        smallestX = sizeX;
                    }
                    if (smallestX == 0.0f) {
                        System.out.println("Error: LEKEEPER \"" + instance.getName() + "\" does not fight against any drivers");
                    }
                    newX = smallestX * this.netlist.getKeeperRatio() / (float)drivers.size();
                }
                if (instance.getType() == Instance.Type.LEGATE) {
                    float totalcap = 0.0f;
                    Iterator netpinsIter = netpins.iterator();
                    while (netpinsIter.hasNext()) {
                        Pin netpin = (Pin)netpinsIter.next();
                        Instance netpinInstance = netpin.getInstance();
                        float load = netpinInstance.getLeX() * netpin.getLE() * (float)netpinInstance.getMfactor();
                        if (netpin.getDir() == Pin.Dir.OUTPUT) {
                            load *= alpha;
                        }
                        totalcap += load;
                    }
                    newX = instance.getParallelGroup() <= 0 ? totalcap / instance.getLeSU() : totalcap / instance.getLeSU() / (float)drivers.size();
                    newX /= (float)instance.getMfactor();
                }
                if ((currentX = instance.getLeX()) == 0.0f) {
                    currentX = 0.001f;
                }
                float f = currentLoopDeltaX = (deltaX = Math.abs((newX - currentX) / currentX)) > currentLoopDeltaX ? deltaX : currentLoopDeltaX;
                if (verbose) {
                    this.out.println("Optimized " + instanceName + ": size:  " + TextUtils.formatDouble(instance.getLeX(), 3) + "x ==> " + TextUtils.formatDouble(newX, 3) + "x");
                }
                instance.setLeX(newX);
            }
            String elapsed = TextUtils.getElapsedTime(System.currentTimeMillis() - startTime);
            System.out.println("  ...done (" + elapsed + "), delta: " + currentLoopDeltaX);
            if (verbose) {
                System.out.println("-----------------------------------");
            }
            ++loopcount;
            if (currentLoopDeltaX >= lastLoopDeltaX) {
                if (divergingIters > 2) {
                    System.out.println("  Sizing diverging, aborting");
                    return false;
                }
                ++divergingIters;
            }
            lastLoopDeltaX = currentLoopDeltaX;
        }
        return true;
    }

    protected List getEndNets() {
        ArrayList endNets = new ArrayList();
        Iterator netIter = this.netlist.getAllNets().values().iterator();
        while (netIter.hasNext()) {
            Net net = (Net)netIter.next();
        }
        return null;
    }

    protected void printDesign() {
        this.out.println("Instances in design are:");
        Iterator instancesIter = this.netlist.getAllInstances().values().iterator();
        while (instancesIter.hasNext()) {
            Instance instance = (Instance)instancesIter.next();
            String instanceName = instance.getName();
            StringBuffer buf = new StringBuffer();
            this.out.println("\t" + instanceName + " ==> " + TextUtils.formatDouble(instance.getLeX(), 3) + "x");
            ArrayList pins = instance.getAllPins();
            Iterator pinsIter = pins.iterator();
            while (pinsIter.hasNext()) {
                Pin pin = (Pin)pinsIter.next();
                this.out.println("\t\t" + pin.getName() + " ==> " + pin.getNetName());
            }
        }
    }

    protected int printDesignSizes(String filename) {
        try {
            FileWriter fileWriter = new FileWriter(filename);
            Iterator instancesIter = this.netlist.getAllInstances().values().iterator();
            while (instancesIter.hasNext()) {
                Instance instance = (Instance)instancesIter.next();
                String instanceName = instance.getName();
                float leX = instance.getLeX();
                fileWriter.write(instanceName + " " + leX + "\n");
                fileWriter.flush();
            }
            fileWriter.close();
        }
        catch (IOException e) {
            this.out.println("Writing to file " + filename + ": " + e.getMessage());
            return 1;
        }
        return 0;
    }

    protected int printDesignSkill(String filename, String libname, String cellname) {
        return 0;
    }

    protected void testcoverage() {
    }

    public static void test1() {
        System.out.println("Running GASP test circuit");
        System.out.println("=========================");
        float su = 4.0f;
        LENetlister netlist = new LENetlister(Alg.EQUALGATEDELAYS, null);
        Pin pin_a = new Pin("A", Pin.Dir.INPUT, 1.0f, "nand1_out");
        Pin pin_y = new Pin("Y", Pin.Dir.OUTPUT, 1.0f, "inv1_out");
        ArrayList<Pin> pins = new ArrayList<Pin>();
        pins.add(pin_a);
        pins.add(pin_y);
        netlist.addInstance("inv1", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_a = new Pin("A", Pin.Dir.INPUT, 1.0f, "pu_out");
        pin_y = new Pin("Y", Pin.Dir.OUTPUT, 1.0f, "inv2_out");
        pins = new ArrayList();
        pins.add(pin_a);
        pins.add(pin_y);
        netlist.addInstance("inv2", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_a = new Pin("A", Pin.Dir.INPUT, 1.0f, "nand1_out");
        pin_y = new Pin("Y", Pin.Dir.OUTPUT, 1.0f, "inv3_out");
        pins = new ArrayList();
        pins.add(pin_a);
        pins.add(pin_y);
        netlist.addInstance("inv3", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_a = new Pin("A", Pin.Dir.INPUT, 1.333f, "inv2_out");
        Pin pin_b = new Pin("B", Pin.Dir.INPUT, 1.333f, "pd_out");
        Pin pin_y2 = new Pin("Y", Pin.Dir.OUTPUT, 2.0f, "nand1_out");
        ArrayList<Pin> pins2 = new ArrayList<Pin>();
        pins2.add(pin_a);
        pins2.add(pin_b);
        pins2.add(pin_y2);
        netlist.addInstance("nand1", Instance.Type.LEGATE, su, 1.0f, pins2, null);
        Pin pin_g = new Pin("G", Pin.Dir.INPUT, 0.667f, "nand1_out");
        Pin pin_d = new Pin("D", Pin.Dir.OUTPUT, 0.667f, "pu_out");
        pins = new ArrayList();
        pins.add(pin_g);
        pins.add(pin_d);
        netlist.addInstance("pu", Instance.Type.LEGATE, su, 1.0f, pins, null);
        pin_g = new Pin("G", Pin.Dir.INPUT, 0.333f, "inv3_out");
        pin_d = new Pin("D", Pin.Dir.OUTPUT, 0.333f, "pd_out");
        pins = new ArrayList();
        pins.add(pin_g);
        pins.add(pin_d);
        netlist.addInstance("pd", Instance.Type.LEGATE, su, 1.0f, pins, null);
        Pin pin_c = new Pin("C", Pin.Dir.INPUT, 1.0f, "pd_out");
        ArrayList<Pin> pins3 = new ArrayList<Pin>();
        pins3.add(pin_c);
        netlist.addInstance("cap1", Instance.Type.LOAD, su, 0.0f, pins3, null);
        pin_c = new Pin("C", Pin.Dir.INPUT, 1.0f, "pu_out");
        pins3 = new ArrayList();
        pins3.add(pin_c);
        netlist.addInstance("cap2", Instance.Type.LOAD, su, 0.0f, pins3, null);
        pin_c = new Pin("C", Pin.Dir.INPUT, 1.0f, "inv1_out");
        pins3 = new ArrayList();
        pins3.add(pin_c);
        netlist.addInstance("cap3", Instance.Type.LOAD, su, 100.0f, pins3, null);
        netlist.getSizer().printDesign();
        netlist.getSizer().optimizeLoops(0.01f, 30, true, 0.7f, 0.1f);
        System.out.println("After optimization:");
        netlist.getSizer().printDesign();
    }

    protected static class Alg {
        private final String name;
        protected static final Alg EQUALGATEDELAYS = new Alg("Equal Gate Delays");
        protected static final Alg PATHDELAY = new Alg("Path Delay");

        private Alg(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

