/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.tool.ncc.basic.Messenger;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.Port;
import com.sun.electric.tool.ncc.jemNets.Transistor;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Wire
extends NetObject {
    private Set content = new HashSet();
    private Port port;
    private boolean isGlobal;

    public Wire(String name, boolean isGlobal) {
        super(name);
        this.isGlobal = isGlobal;
    }

    public Iterator getParts() {
        return this.content.iterator();
    }

    public Iterator getConnected() {
        return this.getParts();
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean disconnect(Part p) {
        return this.content.remove(p);
    }

    public void add(Part p) {
        Wire.error(p == null, "Wires can't add null Part");
        this.content.add(p);
    }

    public Port addExportName(String portName) {
        if (this.port == null) {
            this.port = new Port(portName, this);
        } else {
            this.port.addExportName(portName);
        }
        return this.port;
    }

    public Port getPort() {
        return this.port;
    }

    public NetObject.Type getNetObjType() {
        return NetObject.Type.WIRE;
    }

    public void killMe() {
        Wire.error(this.content.size() != 0, "Can't kill: wire connected to a Part");
        Wire.error(this.port != null, "Can't kill: wire connected to a Port");
        Wire.error(this.isGlobal(), "Can't kill: wire declared GLOBAL in Electric");
        this.getParent().remove(this);
    }

    public int numPartsWithGateAttached() {
        int with = 0;
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            if (!p.touchesAtGate(this)) continue;
            ++with;
        }
        return with;
    }

    public int stepUp() {
        int gates = 0;
        int diffusion = 0;
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Object oo = it.next();
            if (!(oo instanceof Transistor)) continue;
            Transistor t = (Transistor)oo;
            if (t.touchesAtGate(this)) {
                ++gates;
            }
            if (!t.touchesAtDiffusion(this)) continue;
            ++diffusion;
        }
        return gates - diffusion;
    }

    public void checkMe(Circuit parent) {
        Wire.error(this.getParent() != parent, "wrong parent");
        Iterator it = this.getParts();
        while (it.hasNext()) {
            NetObject nn = (NetObject)it.next();
            Wire.error(!(nn instanceof Part), "expecting only parts");
            Part pp = (Part)nn;
            Wire.error(pp.numPinsConnected(this) == 0, "Part not connected back to wire");
        }
    }

    public boolean touches(Part p) {
        return this.content.contains(p);
    }

    public boolean touches(Port p) {
        return this.port == p;
    }

    public Integer computeHashCode() {
        int sum = 0;
        Iterator it = this.getParts();
        while (it.hasNext()) {
            Part pp = (Part)it.next();
            sum += pp.getHashFor(this);
        }
        return new Integer(sum);
    }

    public int numParts() {
        return this.content.size();
    }

    public int numPartPins() {
        int numPins = 0;
        Iterator it = this.getParts();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            numPins += p.numPinsConnected(this);
        }
        return numPins;
    }

    public String nameString() {
        return "Wire " + this.getName();
    }

    public String connectionString(int maxParts) {
        if (this.content.size() == 0) {
            return " unconnected";
        }
        String s = " connected to";
        if (this.numParts() > maxParts) {
            s = s + " " + this.content.size() + " parts starting with";
        }
        s = s + ": ";
        Iterator it = this.getParts();
        for (int i = 0; it.hasNext() && i < maxParts; ++i) {
            Part p = (Part)it.next();
            String cc = p.nameString();
            s = s + " (" + cc + " " + p.connectionString(this) + ") ";
        }
        return s;
    }

    public void printMe(int x, Messenger messenger) {
        int maxPins = 3;
        messenger.print(this.nameString());
        messenger.println(this.connectionString(maxPins));
    }
}

