/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PrimitiveArc
extends ArcProto {
    private Technology.ArcLayer[] layers;
    private String fullName;
    HashMap arcPinPrefs = new HashMap();

    private PrimitiveArc(Technology tech, String protoName, double defaultWidth, Technology.ArcLayer[] layers) {
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitiveArc name " + protoName + " is not safe to write into JELIB");
        }
        this.protoName = protoName;
        this.fullName = tech.getTechName() + ":" + protoName;
        this.widthOffset = 0.0;
        this.tech = tech;
        this.layers = layers;
        this.setFactoryDefaultWidth(defaultWidth);
    }

    public static PrimitiveArc newInstance(Technology tech, String protoName, double defaultWidth, Technology.ArcLayer[] layers) {
        if (tech.findArcProto(protoName) != null) {
            System.out.println("Error: technology " + tech.getTechName() + " has multiple arcs named " + protoName);
            return null;
        }
        if (defaultWidth < 0.0) {
            System.out.println("PrimitiveArc " + tech.getTechName() + ":" + protoName + " has negative width");
            return null;
        }
        PrimitiveArc ap = new PrimitiveArc(tech, protoName, defaultWidth, layers);
        tech.addArcProto(ap);
        return ap;
    }

    public Technology.ArcLayer[] getLayers() {
        return this.layers;
    }

    public Iterator layerIterator() {
        return new LayerIterator(this.layers);
    }

    public Technology.ArcLayer findArcLayer(Layer layer) {
        for (int j = 0; j < this.layers.length; ++j) {
            Technology.ArcLayer oneLayer = this.layers[j];
            if (oneLayer.getLayer() != layer) continue;
            return oneLayer;
        }
        return null;
    }

    private Pref getArcPinPref() {
        Pref pref = (Pref)this.arcPinPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeStringPref("PinFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), "");
            this.arcPinPrefs.put(this, pref);
        }
        return pref;
    }

    public void setPinProto(PrimitiveNode np) {
        Pref pref = this.getArcPinPref();
        pref.setString(np.getName());
    }

    public PrimitiveNode findOverridablePinProto() {
        PrimitiveNode np;
        Pref pref = this.getArcPinPref();
        String primName = pref.getString();
        if (primName != null && primName.length() > 0 && (np = this.tech.findNodeProto(primName)) != null) {
            return np;
        }
        return this.findPinProto();
    }

    public PrimitiveNode findPinProto() {
        Iterator it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitivePort pp;
            PrimitiveNode pn = (PrimitiveNode)it.next();
            if (!pn.isPin() || !(pp = (PrimitivePort)pn.getPorts().next()).connectsTo(this)) continue;
            return pn;
        }
        return null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return "PrimitiveArc " + this.describe();
    }

    public static class LayerIterator
    implements Iterator {
        Technology.ArcLayer[] array;
        int pos;

        public LayerIterator(Technology.ArcLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }
}

