/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.MultiTaskJob;
import com.sun.electric.tool.drc.CellLayersContainer;
import com.sun.electric.tool.drc.CheckCellLayerEnumerator;
import com.sun.electric.tool.drc.DRC;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MTDRCTool
extends MultiTaskJob<Layer, MTDRCResult, MTDRCResult> {
    protected Cell topCell;
    protected long globalStartTime;
    protected CellLayersContainer cellLayersCon = new CellLayersContainer();
    protected final boolean printLog = false;

    public MTDRCTool(String jobName, Cell c, Consumer<MTDRCResult> consumer) {
        super(jobName, DRC.getDRCTool(), Job.Type.CHANGE, consumer);
        this.topCell = c;
    }

    @Override
    public void prepareTasks() {
        Technology tech = this.topCell.getTechnology();
        this.cellLayersCon = new CellLayersContainer();
        CheckCellLayerEnumerator layerCellCheck = new CheckCellLayerEnumerator(this.cellLayersCon);
        HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)layerCellCheck);
        Set<String> layers = this.cellLayersCon.getLayersSet(this.topCell);
        this.globalStartTime = System.currentTimeMillis();
        for (String layerS : layers) {
            Layer layer = tech.findLayer(layerS);
            this.startTask(layer.getName(), layer);
        }
    }

    @Override
    public MTDRCResult mergeTaskResults(Map<Layer, MTDRCResult> taskResults) {
        int numTE = 0;
        int numTW = 0;
        for (Map.Entry<Layer, MTDRCResult> e : taskResults.entrySet()) {
            MTDRCResult p = e.getValue();
            numTE += p.numErrors;
            numTW += p.numWarns;
        }
        System.out.println("Total DRC Errors: " + numTE);
        System.out.println("Total DRC Warnings: " + numTW);
        return new MTDRCResult(numTE, numTW);
    }

    @Override
    public MTDRCResult runTask(Layer taskKey) {
        if (this.skipLayer(taskKey)) {
            return null;
        }
        return this.runTaskInternal(taskKey);
    }

    abstract MTDRCResult runTaskInternal(Layer var1);

    abstract boolean checkArea();

    boolean skipLayer(Layer theLayer) {
        if (theLayer == null) {
            return false;
        }
        if (theLayer.getFunction().isDiff() && theLayer.getName().toLowerCase().equals("p-active-well")) {
            return true;
        }
        if (theLayer.getFunction().isGatePoly()) {
            return true;
        }
        return this.checkArea() && theLayer.getFunction().isContact();
    }

    public static class MTDRCResult {
        private int numErrors;
        private int numWarns;

        MTDRCResult(int numE, int numW) {
            this.numErrors = numE;
            this.numWarns = numW;
        }

        public int getNumErrors() {
            return this.numErrors;
        }

        public int getNumWarnings() {
            return this.numWarns;
        }
    }
}

