/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.InteriorNodeCursor;
import com.sun.electric.database.geometry.btree.LeafNodeCursor;
import com.sun.electric.database.geometry.btree.NodeCursor;
import com.sun.electric.database.geometry.btree.unboxed.AssociativeCommutativeOperation;
import com.sun.electric.database.geometry.btree.unboxed.AssociativeOperation;
import com.sun.electric.database.geometry.btree.unboxed.Pair;
import com.sun.electric.database.geometry.btree.unboxed.Unboxed;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedComparable;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedFunction;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.io.PrintStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTree<K extends Serializable & Comparable, V extends Serializable, S extends Serializable> {
    final CachingPageStorage ps;
    final UnboxedComparable<K> uk;
    final AssociativeOperation<S> ao;
    final UnboxedFunction<Pair<K, V>, S> summarize;
    final Unboxed<V> uv;
    final UnboxedInt ui = UnboxedInt.instance;
    private LeafNodeCursor<K, V, S> leafNodeCursor;
    private InteriorNodeCursor<K, V, S> interiorNodeCursor1;
    private InteriorNodeCursor<K, V, S> interiorNodeCursor2;
    int rootpage;
    private final byte[] keybuf;
    private final byte[] keybuf2;
    private final byte[] sbuf;
    private final byte[] largestKey;
    private int largestKeyPage = -1;
    private int size = 0;
    static long insertionFastPath = 0L;
    static long insertionSlowPath = 0L;
    static long splitEven = 0L;
    static long splitUnEven = 0L;

    public BTree(CachingPageStorage ps, UnboxedComparable<K> uk, Unboxed<V> uv, UnboxedFunction<Pair<K, V>, S> summarize, AssociativeOperation<S> combine) {
        AssociativeOperation<S> ao = combine;
        this.summarize = summarize;
        if (ao != null && !(ao instanceof AssociativeCommutativeOperation)) {
            throw new RuntimeException("Only commutative summary operations are supported (allows one-pass insertion)");
        }
        this.ps = ps;
        this.uk = uk;
        this.ao = ao;
        this.uv = uv;
        this.leafNodeCursor = new LeafNodeCursor(this);
        this.interiorNodeCursor1 = new InteriorNodeCursor(this);
        this.interiorNodeCursor2 = new InteriorNodeCursor(this);
        this.rootpage = ps.createPage();
        this.keybuf = new byte[uk.getSize()];
        this.keybuf2 = new byte[uk.getSize()];
        this.sbuf = ao == null ? null : new byte[ao.getSize()];
        this.largestKey = new byte[uk.getSize()];
        this.leafNodeCursor.initBuf(ps.getPage(this.rootpage, false), true);
        this.leafNodeCursor.writeBack();
    }

    public int getNumFromKeys(K min, K max) {
        if (min == null && max == null) {
            return this.size;
        }
        throw new RuntimeException("not implemented");
    }

    public int size() {
        return this.getNumFromKeys(null, null);
    }

    public V getValFromKey(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, null, Op.GET_VAL_FROM_KEY, 0));
    }

    public V getValFromKeyFloor(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, null, Op.GET_VAL_FROM_KEY_FLOOR, 0));
    }

    public V getValFromKeyCeiling(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, null, Op.GET_VAL_FROM_KEY_CEIL, 0));
    }

    public int getOrdFromKey(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (Integer)this.walk(this.keybuf, 0, null, Op.GET_ORD_FROM_KEY, 0);
    }

    public int getOrdFromKeyFloor(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (Integer)this.walk(this.keybuf, 0, null, Op.GET_ORD_FROM_KEY_FLOOR, 0);
    }

    public int getOrdFromKeyCeiling(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (Integer)this.walk(this.keybuf, 0, null, Op.GET_ORD_FROM_KEY_CEIL, 0);
    }

    public V getKeyFromKeyNext(K key) {
        throw new RuntimeException("not implemented");
    }

    public V getKeyFromKeyPrev(K key) {
        throw new RuntimeException("not implemented");
    }

    public V getValFromOrd(int ord) {
        return (V)((Serializable)this.walk(null, 0, null, Op.GET_VAL_FROM_ORD, ord));
    }

    public K getKeyFromOrd(int ord) {
        return (K)((Serializable)this.walk(null, 0, null, Op.GET_KEY_FROM_ORD, ord));
    }

    public void insert(K key, V val) {
        this.uk.serialize(key, this.keybuf, 0);
        this.walk(this.keybuf, 0, val, Op.INSERT, 0);
        ++this.size;
    }

    public V replace(K key, V val) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, val, Op.REPLACE, 0));
    }

    public V remove(K key) {
        throw new RuntimeException("not implemented");
    }

    public void clear() {
        throw new RuntimeException("not implemented");
    }

    public S getSummaryFromKeys(K min, K max) {
        this.uk.serialize(min, this.keybuf, 0);
        this.uk.serialize(max, this.keybuf2, 0);
        this.walk(this.keybuf, 0, null, Op.SUMMARIZE_LEFT, 0, this.keybuf2, 0, this.sbuf, 0);
        this.walk(this.keybuf, 0, null, Op.SUMMARIZE_MID, 0, this.keybuf2, 0, this.sbuf, 0);
        this.walk(this.keybuf, 0, null, Op.SUMMARIZE_RIGHT, 0, this.keybuf2, 0, this.sbuf, 0);
        return (S)this.ao.deserialize(this.sbuf, 0);
    }

    private Object walk(byte[] key, int key_ofs, V val, Op op, int ord) {
        return this.walk(key, key_ofs, val, op, ord, null, 0, null, 0);
    }

    private Object walk(byte[] key, int key_ofs, V val, Op op, int ord, byte[] key2, int key2_ofs, byte[] ret, int ret_ofs) {
        int pageid = this.rootpage;
        int idx = -1;
        int global_ord = 0;
        LeafNodeCursor<K, V, S> leafNodeCursor = this.leafNodeCursor;
        InteriorNodeCursor<K, V, S> interiorNodeCursor = this.interiorNodeCursor1;
        InteriorNodeCursor<K, V, S> parentNodeCursor = this.interiorNodeCursor2;
        NodeCursor cur = null;
        boolean rightEdge = true;
        boolean cheat = false;
        int comp = 0;
        if (this.largestKeyPage != -1 && op == Op.INSERT) {
            leafNodeCursor.setBuf(this.ps.getPage(this.largestKeyPage, true));
            comp = this.uk.compare(key, key_ofs, this.largestKey, 0);
            if (comp >= 0 && !leafNodeCursor.isFull()) {
                pageid = this.largestKeyPage;
                parentNodeCursor.forgetCachedPage();
                cheat = true;
                cur = leafNodeCursor;
            }
        }
        while (true) {
            if (cur == null || cur.getCachedPage() == null || cur.getPageId() != pageid) {
                CachingPageStorage.CachedPage cp = this.ps.getPage(pageid, true);
                cur = LeafNodeCursor.isLeafNode(cp) ? leafNodeCursor : interiorNodeCursor;
                cur.setBuf(cp);
            }
            if ((op == Op.INSERT || op == Op.REPLACE) && cur.isFull()) {
                int splitPoint;
                int old;
                assert (cur != parentNodeCursor);
                boolean splitting_last_or_root = false;
                if (pageid == this.rootpage) {
                    parentNodeCursor.initRoot();
                    parentNodeCursor.setBucketPageId(0, pageid);
                    idx = 0;
                    old = this.size;
                    splitting_last_or_root = true;
                } else {
                    assert (!parentNodeCursor.isFull());
                    splitting_last_or_root = idx >= parentNodeCursor.getNumBuckets() - 1;
                    int n = old = splitting_last_or_root ? -1 : parentNodeCursor.getNumValsBelowBucket(idx);
                }
                if (op == Op.INSERT && old != -1) {
                    --old;
                }
                int ofs = parentNodeCursor.insertNewBucketAt(idx + 1);
                int oldpage = cur.getPageId();
                int n = splitPoint = rightEdge ? cur.getNumBuckets() - 1 : cur.getMaxBuckets() / 2;
                if (rightEdge) {
                    ++splitUnEven;
                } else {
                    ++splitEven;
                }
                if (this.ao != null) {
                    byte[] monbuf = new byte[this.ao.getSize()];
                    cur.getSummary(0, monbuf, 0);
                    for (int i = 1; i < splitPoint; ++i) {
                        cur.getSummary(i, monbuf, 0);
                        parentNodeCursor.multiplySummaryCommutative(idx, monbuf, 0);
                    }
                }
                int num = cur.split(parentNodeCursor.getBuf(), ofs, splitPoint);
                parentNodeCursor.setNumValsBelowBucket(idx, num);
                int newpage = cur.getPageId();
                if (this.largestKeyPage == oldpage) {
                    this.largestKeyPage = newpage;
                }
                parentNodeCursor.setBucketPageId(idx + 1, newpage);
                if (!splitting_last_or_root) {
                    parentNodeCursor.setNumValsBelowBucket(idx + 1, old - num);
                }
                if (!(this.ao == null || parentNodeCursor.isRightMost() && idx + 1 >= parentNodeCursor.getNumBuckets() - 1)) {
                    byte[] monbuf = new byte[this.ao.getSize()];
                    cur.getSummary(0, monbuf, 0);
                    for (int i = 1; i < cur.getNumBuckets() - (cur.isRightMost() ? 1 : 0); ++i) {
                        cur.getSummary(i, monbuf, 0);
                        parentNodeCursor.multiplySummaryCommutative(idx + 1, monbuf, 0);
                    }
                }
                cur.writeBack();
                parentNodeCursor.writeBack();
                pageid = this.rootpage;
                cheat = false;
                continue;
            }
            if (cheat) {
                idx = leafNodeCursor.getNumBuckets() - 1;
                comp = 1;
            } else if (!op.isGetFromOrd()) {
                idx = cur.search(key, key_ofs);
                comp = cur.compare(key, key_ofs, idx);
            } else if (!cur.isLeafNode()) {
                int k;
                for (idx = 0; idx < interiorNodeCursor.getNumBuckets() - 1 && ord >= (k = interiorNodeCursor.getNumValsBelowBucket(idx)); ord -= k, ++idx) {
                }
            }
            if (cur.isLeafNode()) {
                switch (op) {
                    case GET_VAL_FROM_ORD: {
                        return ord >= leafNodeCursor.getNumBuckets() ? null : leafNodeCursor.getVal(ord);
                    }
                    case GET_KEY_FROM_ORD: {
                        return ord >= leafNodeCursor.getNumBuckets() ? null : leafNodeCursor.getKey(ord);
                    }
                    case GET_VAL_FROM_KEY: {
                        return comp == 0 ? leafNodeCursor.getVal(idx) : null;
                    }
                    case GET_VAL_FROM_KEY_FLOOR: {
                        return leafNodeCursor.getVal(idx);
                    }
                    case GET_VAL_FROM_KEY_CEIL: {
                        throw new RuntimeException("not implemented");
                    }
                    case GET_ORD_FROM_KEY: {
                        return comp == 0 ? new Integer(idx + global_ord) : new Integer(-1);
                    }
                    case GET_ORD_FROM_KEY_FLOOR: {
                        return new Integer(idx + global_ord);
                    }
                    case GET_ORD_FROM_KEY_CEIL: {
                        return comp == 0 ? new Integer(idx + global_ord) : new Integer(idx + global_ord + 1);
                    }
                }
                if (op == Op.INSERT && comp == 0) {
                    throw new RuntimeException("attempt to re-insert a value at key " + leafNodeCursor.getKey(idx));
                }
                if (op == Op.REPLACE && comp != 0) {
                    throw new RuntimeException("attempt to replace a value that did not exist");
                }
                if (op == Op.INSERT) {
                    if (cheat) {
                        ++insertionFastPath;
                    } else {
                        ++insertionSlowPath;
                    }
                }
                if (this.largestKeyPage == -1 || cheat) {
                    System.arraycopy(key, key_ofs, this.largestKey, 0, this.largestKey.length);
                }
                if (this.largestKeyPage == -1) {
                    this.largestKeyPage = pageid;
                }
                if (comp == 0) {
                    if (val == null) {
                        throw new RuntimeException("deletion is not yet implemented");
                    }
                    return leafNodeCursor.setVal(idx, val);
                }
                leafNodeCursor.insertVal(idx + 1, key, key_ofs, val);
                return null;
            }
            if (op == Op.REMOVE) {
                throw new RuntimeException("need to adjust 'least value under X' on the way down for deletions");
            }
            if (op == Op.INSERT) {
                boolean wb = false;
                if (idx < interiorNodeCursor.getNumBuckets() - 1) {
                    interiorNodeCursor.setNumValsBelowBucket(idx, interiorNodeCursor.getNumValsBelowBucket(idx) + 1);
                    wb = true;
                }
                if (!(this.ao == null || idx >= interiorNodeCursor.getNumBuckets() - 1 && interiorNodeCursor.isRightMost())) {
                    throw new RuntimeException("not implemented");
                }
                if (wb) {
                    interiorNodeCursor.writeBack();
                }
            }
            if (op.isGetOrd()) {
                for (int i = 0; i < idx; ++i) {
                    global_ord += interiorNodeCursor.getNumValsBelowBucket(i);
                }
            }
            rightEdge &= idx == interiorNodeCursor.getNumBuckets() - 1;
            pageid = interiorNodeCursor.getBucketPageId(idx);
            InteriorNodeCursor<K, V, S> ic = interiorNodeCursor;
            interiorNodeCursor = parentNodeCursor;
            parentNodeCursor = ic;
            if (!$assertionsDisabled && interiorNodeCursor == parentNodeCursor) break;
        }
        throw new AssertionError();
    }

    public static void clearStats() {
        splitUnEven = 0L;
        splitEven = 0L;
        insertionFastPath = 0L;
        insertionSlowPath = 0L;
    }

    public static void dumpStats(PrintStream pw) {
        pw.println("BTree stats: insertion fastpath = " + insertionFastPath + "/" + (insertionFastPath + insertionSlowPath) + " = " + (int)((float)(insertionFastPath * 100L) / (float)(insertionFastPath + insertionSlowPath)) + "%");
        pw.println("             intelligent splits = " + splitUnEven + "/" + (splitUnEven + splitEven) + " = " + (int)((float)(splitUnEven * 100L) / (float)(splitUnEven + splitEven)) + "%");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Op {
        GET_VAL_FROM_KEY,
        GET_VAL_FROM_KEY_FLOOR,
        GET_VAL_FROM_KEY_CEIL,
        GET_ORD_FROM_KEY,
        GET_ORD_FROM_KEY_FLOOR,
        GET_ORD_FROM_KEY_CEIL,
        GET_VAL_FROM_ORD,
        GET_KEY_FROM_ORD,
        GET_NEXT,
        GET_PREV,
        REMOVE,
        INSERT,
        REPLACE,
        SUMMARIZE_LEFT,
        SUMMARIZE_MID,
        SUMMARIZE_RIGHT;


        public boolean isGetFromOrd() {
            switch (this) {
                case GET_VAL_FROM_ORD: 
                case GET_KEY_FROM_ORD: {
                    return true;
                }
            }
            return false;
        }

        public boolean isGetOrd() {
            switch (this) {
                case GET_ORD_FROM_KEY: 
                case GET_ORD_FROM_KEY_FLOOR: 
                case GET_ORD_FROM_KEY_CEIL: {
                    return true;
                }
            }
            return false;
        }

        public boolean isGetFromKey() {
            switch (this) {
                case GET_ORD_FROM_KEY: 
                case GET_ORD_FROM_KEY_FLOOR: 
                case GET_ORD_FROM_KEY_CEIL: 
                case GET_VAL_FROM_KEY: 
                case GET_VAL_FROM_KEY_FLOOR: 
                case GET_VAL_FROM_KEY_CEIL: {
                    return true;
                }
            }
            return false;
        }

        public boolean isGetFromKeyFloor() {
            switch (this) {
                case GET_ORD_FROM_KEY_FLOOR: 
                case GET_VAL_FROM_KEY_FLOOR: {
                    return true;
                }
            }
            return false;
        }

        public boolean isGetFromKeyCeil() {
            switch (this) {
                case GET_ORD_FROM_KEY_CEIL: 
                case GET_VAL_FROM_KEY_CEIL: {
                    return true;
                }
            }
            return false;
        }
    }
}

