;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                          CL-PVM 1.6                                   ;;
;;            Institute for Computational Mathematics                    ;;
;;                Kent State University, Kent, OH                        ;;
;;                 Authors:  Liwei Li                                    ;;
;;                           Paul Wang                                   ;;
;;                 (C) 1996 All Rights Reserved                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(proclaim '(optimize (safety 2)))
;;;;;;;;;;;;;;;; File:  gpvm3.lsp  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; C-types allowed in lisp interface are                       ;;
;; int, char, float, double, object, void                      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; lisp hack to use % to produce quoted strings (%abc is "abc");;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(eval-when (compile)
(set-macro-character
	   #\%
           #'(lambda (stream char) (values (read-line stream))))
)

(defun fillstr(str chr ps)
 (setf (aref str ps) (character chr)))

(defun fillnum(arr num ps)
 (setf (aref arr ps) num))

(defun filldnum(arr num ps)
 (setf (aref arr ps) (float num 0.1d0)))

(defun carset(des src)
 (set (car des) src))

(defun lst2arr(lst)
 (if (listp lst)
     (setq lst (make-array (list-length lst) :initial-contents lst)))
 (setq lst (car (list lst))))


(Clines
%#include <string.h>
)
(Clines
%#include <stdlib.h>
)
(Clines
%#include <ctype.h>
)
(Clines
%#include <stddef.h>
)
(Clines
%#include </vol/pvm/include/pvm3.h>
)
(Clines
%#include </vol/pvm/include/pvmtev.h>
)
(Clines
%#include <sys/time.h>
)
(Clines
%#include </vol/pvm/include/pvmsdpro.h>
)

(defCfun "int call_advise(route)
int route;" 0
%	int info;
%	info=pvm_advise(route);
%	Creturn( info );
)
(defentry pvm-advise(int)  (int call_advise))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_getinst(group, tid)
object group; int tid;" 0
%       int inum;
%       char *group_inter;
%       group_inter=(char *)calloc(((group->st).st_dim)+1, sizeof(char));
%       strncpy(group_inter, group->st.st_self, group->st.st_dim);
%       group_inter[(group->st).st_dim]='\0';
%       inum=pvm_getinst(group_inter, tid);
%       Creturn( inum );
)
(defentry pvm-getinst(object int)  (int call_getinst))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_barrier(group, count)
  object group; int count;" 0
%        int info;
%        char *group_inter;
%        group_inter=(char *)calloc(((group->st).st_dim)+1, sizeof(char));
%        strncpy(group_inter, group->st.st_self, group->st.st_dim);
%        group_inter[(group->st).st_dim]='\0';
%        info=pvm_barrier(group_inter, count);
%        Creturn(info);
)
(defentry pvm-barrier(object int)  (int call_barrier))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_gettid(group, inum)
object group; int inum;" 0
%	int tid;
%	char *group_inter;
%       group_inter=(char *)calloc(((group->st).st_dim)+1, sizeof(char));
%       strncpy(group_inter, group->st.st_self, group->st.st_dim);
%       group_inter[(group->st).st_dim]='\0';
%	tid=pvm_gettid(group_inter, inum);
%	Creturn( tid );
)
(defentry pvm-gettid(object int)  (int call_gettid))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_gsize(group)
object group;" 0
%	int size;
%	char *group_inter;
%       group_inter=(char *)calloc(((group->st).st_dim)+1, sizeof(char));
%       strncpy(group_inter, group->st.st_self, group->st.st_dim);
%       group_inter[(group->st).st_dim]='\0';
%	size=pvm_gsize(group_inter);
%	Creturn( size );
)
(defentry pvm-gsize(object)  (int call_gsize))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defCfun "int call_joingroup(group)
object group;" 0
%	int inum;
%	char *group_inter;
%       group_inter=(char *)calloc(((group->st).st_dim)+1, sizeof(char));
%       strncpy(group_inter, group->st.st_self, group->st.st_dim);
%       group_inter[(group->st).st_dim]='\0';
%	inum=pvm_joingroup(group_inter);
%	Creturn( inum );
)
(defentry pvm-joingroup(object)  (int call_joingroup))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defCfun "int call_lvgroup(group)
object group;" 0
%	int info;
%	char *group_inter;
%       group_inter=(char *)calloc(((group->st).st_dim)+1, sizeof(char));
%       strncpy(group_inter, group->st.st_self, group->st.st_dim);
%       group_inter[(group->st).st_dim]='\0';
%	info=pvm_lvgroup(group_inter);
%	Creturn( info );
)
(defentry pvm-lvgroup(object)  (int call_lvgroup))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
