/* Define the machine-dependent type `jmp_buf'.  Alpha version.
   Copyright (C) 1992, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef _SETJMP_H
# error "Never include <bits/setjmp.h> directly; use <setjmp.h> instead."
#endif

/* The previous bits/setjmp.h had __jmp_buf defined as a structure.
   We use an array of 'long int' instead, to make writing the
   assembler easier. Naturally, user code should not depend on
   either representation. */

/*
 * Integer registers:
 *    $0 is the return value (va);
 *    $1-$8, $22-$25, $28 are call-used (t0-t7, t8-t11, at);
 *    $9-$14 we save here (s0-s5);
 *    $15 is the FP and we save it here (fp or s6);
 *    $16-$21 are input arguments (call-used) (a0-a5);
 *    $26 is the return PC and we save it here (ra);
 *    $27 is the procedure value (i.e., the address of __setjmp) (pv or t12);
 *    $29 is the global pointer, which the caller will reconstruct
 *        from the return address restored in $26 (gp);
 *    $30 is the stack pointer and we save it here (sp);
 *    $31 is always zero (zero).
 *
 * Floating-point registers:
 *    $f0 is the floating return value;
 *    $f1, $f10-$f15, $f22-$f30 are call-used;
 *    $f2-$f9 we save here;
 *    $f16-$21 are input args (call-used);
 *    $f31 is always zero.
 *
 * Note that even on Alpha hardware that does not have an FPU (there
 * isn't such a thing currently) it is required to implement the FP
 * registers.
 */

#if defined __USE_MISC || defined __ASSEMBLY__
# define JB_S0  0
# define JB_S1  1
# define JB_S2  2
# define JB_S3  3
# define JB_S4  4
# define JB_S5  5
# define JB_PC  6
# define JB_FP  7
# define JB_SP  8
# define JB_F2  9
# define JB_F3  10
# define JB_F4  11
# define JB_F5  12
# define JB_F6  13
# define JB_F7  14
# define JB_F8  15
# define JB_F9  16
#endif

#ifndef __ASSEMBLY__
typedef long int __jmp_buf[17];

/* Test if longjmp to JMPBUF would unwind the frame containing a local
   variable at ADDRESS.  */
#define _JMPBUF_UNWINDS(_jmpbuf, _address)				\
     ((void *)(_address) < (void *)((_jmpbuf)[JB_SP]))
#endif
