//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "regexpstatebuilder.H"

#include <ctype.h>

#include "langelems.h"
#include "statelangelem.h"
#include "stringlistlangelem.h"
#include "delimitedlangelem.h"
#include "regexpstate.h"
#include "stringdef.h"
#include "tostringcollection.h"
#include "regexpreprocessor.h"
#include "keys.h"
#include "messages.h"

using namespace std;

static const string buildex(const string &s);
static const string buildex_pre(const string &s);

void add_exp(RegExpStatePtr state, const string &orig, const string &exp, RegExpFormatterPtr f)
{
  try {
    state->add_exp(exp, f);
  } catch (boost::bad_expression &e) {
    printError("wrong original expression: " + orig);
    throw e;
  }
}

bool freeze_state(RegExpStatePtr state)
{
  bool ok = true;
  try {
    state->freeze();
  } catch (boost::bad_expression &e) {
    ok = false;
  }

  return ok;
}

RegExpStateBuilder::RegExpStateBuilder()
{
}

RegExpStateBuilder::~RegExpStateBuilder()
{
}

RegExpStatePtr
RegExpStateBuilder::build(LangElems *elems)
{
  if (! elems)
    return RegExpStatePtr();

  RegExpStatePtr state(new RegExpState);
  state->add_normal_formatter(RegExpFormatterPtr(new RegExpFormatter(NORMAL)));
  build(elems, state);

  return state;
}

void
RegExpStateBuilder::build(LangElems *elems, RegExpStatePointer state)
{
  if (elems)
    for (LangElems::const_iterator it = elems->begin(); it != elems->end(); ++it)
      build_DB(*it, state);

  bool problems = !freeze_state(state);

  if (!problems)
    return;

  if (elems) {
    // try to find out where the problem is...
    RegExpStatePtr temp_state(new RegExpState());
    for (LangElems::const_iterator it = elems->begin(); it != elems->end(); ++it) {
      build(*it, temp_state);
      try {
        temp_state->freeze();
      } catch (boost::bad_expression &e) {
        printError("problem in this expression: " + (*it)->toString());
        throw e;
      }
    }
  } else
    throw boost::bad_expression("internal error");
}

void
RegExpStateBuilder::build(LangElem *elem, RegExpStatePointer state)
{
}

const string buildex(const string &s)
{
  return "(" + s + ")";
}

const string buildex_pre(const string &s)
{
  return buildex(RegexPreProcessor::preprocess(s));
}

const string buildex_isolated(const string &s)
{
  return "\\<" + s + "\\>";
}

bool is_to_isolate(const string &s) {
  if (s.size()) {
    if ((isalnum(s[0]) || s[0] == '_') && (isalnum(s[s.size()-1]) || s[s.size()-1] == '_'))
      return true;
  }

  return false;
}

int escaped_string_size(const string &s) {
  if (s.size() && s[0] == '\\')
    return s.size() - 1;

  return s.size();
}

void
RegExpStateBuilder::build(StringListLangElem *elem, RegExpStatePointer state)
{
  const string &name = elem->getName();
  StringDefs *alternatives = elem->getAlternatives();
  string stringdef = toStringCollection<StringDefs>(alternatives, '|');
  if (!elem->isCaseSensitive())
    stringdef = RegexPreProcessor::make_nonsensitive(stringdef);
  string exp_string = buildex_pre(stringdef);
  if (is_to_isolate(stringdef))
    exp_string = buildex_isolated(exp_string);

  RegExpFormatterPtr formatter(new RegExpFormatter(name));

  add_exp(state, exp_string, buildex_pre(exp_string), formatter);
  build(static_cast<StateStartLangElem *>(elem), state);
}

void
RegExpStateBuilder::build(DelimitedLangElem *elem, RegExpStatePointer state)
{
  RegExpStatePtr inner;

  const string &name = elem->getName();

  StringDef *start = elem->getStart();
  StringDef *end = elem->getEnd();
  StringDef *escape = elem->getEscape();

  string start_string;
  if (start)
    start_string = start->toString();

  string exp_string = start_string;

  string end_string;
  if (end)
    end_string = end->toString();
  string escape_string;
  if (escape)
    escape_string = escape->toString();

  if (! elem->isMultiline() && escaped_string_size(start_string) == 1 &&
        escaped_string_size(end_string) == 1) {
    if (!escape) {
      exp_string = start_string + "([^" +
          start_string +
          (end_string != start_string ? end_string : "") +
          "])*" + end_string;
    } else {
      exp_string = start_string + "([^" +
          escape_string +
          start_string +
          (end_string != start_string ? escape_string + end_string : "") +
          "]|"+ escape_string + "." +
          ")*" + end_string;
    }
  } else {
    inner = RegExpStatePtr(new RegExpState); // for internal elements
    inner->current_formatter = 1;
    inner->add_normal_formatter(RegExpFormatterPtr(new RegExpFormatter(NORMAL)));

    RegExpFormatterPtr exit(new RegExpFormatter(name, RegExpStatePtr(), true, elem->exitAll()));
    if (end)
      add_exp(inner, end_string, buildex_pre(end_string), exit);
    else
      inner->add_exp(buildex("\\z"), exit);

    if (escape) {
      add_exp(inner, escape_string, buildex_pre(escape_string + "."),
              RegExpFormatterPtr(new RegExpFormatter(name)));
    }

    if (elem->isNested()) {
      RegExpFormatterPtr nested(new RegExpFormatter(name, inner));
      add_exp(inner, start_string, buildex_pre(start_string), nested);
    }
  }

  if (inner) {
    freeze_state(inner);
  }

  RegExpFormatterPtr formatter(new RegExpFormatter(name, inner));
  add_exp(state, exp_string, buildex_pre(exp_string), formatter);
  build(static_cast<StateStartLangElem *>(elem), state);
}

void
RegExpStateBuilder::build(StateStartLangElem *elem, RegExpStatePointer state)
{
  RegExpFormatterPtr formatter = state->getLastFormatter();

  bool exit_all = elem->exitAll();
  bool exit = elem->doExit();

  if (exit_all)
    formatter->exit_state = formatter->exit_all = true;
  if (exit)
    formatter->exit_state = true;
}

void
RegExpStateBuilder::build(StateLangElem *elem, RegExpStatePointer state)
{
  StateStartLangElem *statestart = elem->getStateStart();

  build_DB(statestart, state);

  LangElems *elems = elem->getElems();
  RegExpFormatterPtr last = state->getLastFormatter();
  if (!last->getNextState()) {
    last->setNextState(RegExpStatePtr(new RegExpState)); // for internal elements
    last->getNextState()->add_normal_formatter(RegExpFormatterPtr(new RegExpFormatter(NORMAL)));
  }
  RegExpStatePtr inner(last->getNextState());
  inner->current_formatter = (elem->isState() ? 0 : 1);

  build(elems, inner);
}



