//
// C++ Implementation: textformatter
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "textformatter.h"

#include "maingeneratormap.h"

using namespace std;

TextFormatter::TextFormatter(TextFormatterPtr f) :
  decorator(f)
{
}

TextFormatter::~TextFormatter()
{
}

void
TextFormatter::setFormatter(TextFormatterPtr f)
{
  if (decorator.get())
    decorator->setFormatter(f);
  else
    decorator = f;
}

void
TextFormatter::format(const string &elem, const string &text)
{
  if (! text.size())
    return;

  generatormap->generateEntire(elem, _preformat(text));
}

void
TextFormatter::format_nl(const string &text)
{
  string preformat_text = _preformat(text);

  if (preformat_text == text)
    preformat_text = "\n";

  generatormap->generateNL(preformat_text);
}

const string
TextFormatter::_preformat(const string &text)
{
  if (! text.size())
    return text;

  string preformat_text = text;
  TextFormatter *inner = this;
  while (inner) // start the chain of preformatting
  {
    preformat_text = inner->preformat(preformat_text);
    inner = inner->decorator.get();
  }

  return preformat_text;
}

const string
TextFormatter::preformat(const string &text)
{
  return text;
}
