#ifndef TAGS_H
#define TAGS_H

#include "my_set.h"

#include <string>
#include <list>
#include <boost/shared_ptr.hpp>

typedef enum { ISBOLD=1, ISITALIC, ISUNDERLINE, ISFIXED, ISNOTFIXED } TagStyle;
typedef std::list<TagStyle> TagStyles;
typedef boost::shared_ptr<TagStyles> TagStylesPtr;
typedef TagStyles::const_iterator TagStylesIterator;

using std::string;

class Tag
{
 protected:
  string TagName ;
  string color ;
  TagStylesPtr tagStyles;

 public:
  Tag( const string &n ) : TagName( n ) {}
  Tag( const string &n, const string &c );

  void setStyles( TagStylesPtr t ) { tagStyles = t; }
  const TagStylesPtr getTagStyles() const { return tagStyles; }

  string GetName() const { return TagName ; }
  string GetColor() const { return color ; }
  void SetColor( const string &col ) { color = col ; }
  void Print() ;
} ;

struct TagLess
{
  typedef std::less<string> value_compare;

  value_compare value_comp;

 public:
  bool operator() (const Tag *t1, const Tag *t2) const
  { return value_comp(t1->GetName(),t2->GetName()); }
};

class Tags : protected set<Tag *, TagLess>
{
  typedef set<Tag *, TagLess> container_type;

 public:
  using container_type::begin;
  using container_type::end;
  using container_type::const_iterator;

  Tags() {}
  ~Tags();
  bool AddTag( Tag *t ) { return insert( t ).second ;  }
  Tag *GetTag( const string &name ) ;
} ;

inline Tag *
Tags::GetTag( const string &name )
{
  Tag *temp = new Tag (name);
  const_iterator p = find (temp);
  delete temp;
  if (p != end ())
    return *p;

  return 0;
}

#endif
