/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Arguments;
import com.google.caliper.Benchmark;
import com.google.caliper.ConfigurationException;
import com.google.caliper.ConfiguredBenchmark;
import com.google.caliper.Scenario;
import com.google.caliper.SimpleBenchmark;
import com.google.caliper.UserException;
import com.google.caliper.VmFactory;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ScenarioSelection {
    private final Set<String> userVms;
    private final Multimap<String, String> vmParameters;
    private final String suiteClassName;
    private final Multimap<String, String> userParameterArguments;
    private Multimap<String, String> userParameters;
    private final int trials;
    private Benchmark suite;

    public ScenarioSelection(Arguments arguments) {
        this(arguments.getUserVms(), arguments.getVmParameters(), arguments.getSuiteClassName(), arguments.getUserParameters(), arguments.getTrials());
    }

    public ScenarioSelection(Set<String> userVms, Multimap<String, String> vmParameters, String suiteClassName, Multimap<String, String> userParameterArguments, int trials) {
        this.userVms = userVms;
        this.vmParameters = vmParameters;
        this.suiteClassName = suiteClassName;
        this.userParameterArguments = userParameterArguments;
        this.trials = trials;
    }

    public List<Scenario> select() {
        this.prepareSuite();
        this.userParameters = this.computeUserParameters();
        return this.createScenarios();
    }

    public Scenario normalizeScenario(Scenario scenario) {
        if (this.suite instanceof SimpleBenchmark) {
            return ((SimpleBenchmark)this.suite).normalizeScenario(scenario);
        }
        return scenario;
    }

    public Set<String> getUserParameterNames() {
        if (this.userParameters == null) {
            throw new IllegalStateException();
        }
        return this.userParameters.keySet();
    }

    public Set<String> getVmParameterNames() {
        return this.vmParameters.keySet();
    }

    public ConfiguredBenchmark createBenchmark(Scenario scenario) {
        return this.suite.createBenchmark(scenario.getVariables(this.getUserParameterNames()));
    }

    private void prepareSuite() {
        Object s;
        Class<?> benchmarkClass;
        try {
            benchmarkClass = ScenarioSelection.getClassByName(this.suiteClassName);
        }
        catch (ExceptionInInitializerError e) {
            throw new UserException.ExceptionFromUserCodeException(e.getCause());
        }
        catch (ClassNotFoundException ignored) {
            throw new UserException.NoSuchClassException(this.suiteClassName);
        }
        try {
            Constructor<?> constructor = benchmarkClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            s = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException ignore) {
            throw new UserException.AbstractBenchmarkException(benchmarkClass);
        }
        catch (NoSuchMethodException ignore) {
            throw new UserException.NoParameterlessConstructorException(benchmarkClass);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            throw new UserException.ExceptionFromUserCodeException(e.getCause());
        }
        if (!(s instanceof Benchmark)) {
            throw new UserException.DoesntImplementBenchmarkException(benchmarkClass);
        }
        this.suite = (Benchmark)s;
    }

    private static Class<?> getClassByName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            String newName = className.replaceFirst("\\.([^.]+)$", "\\$$1");
            return Class.forName(newName);
        }
    }

    private Multimap<String, String> computeUserParameters() {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (String key : this.suite.parameterNames()) {
            Collection userValues = this.userParameterArguments.get((Object)key);
            if (!userValues.isEmpty()) {
                result.putAll((Object)key, (Iterable)userValues);
                continue;
            }
            Set<String> values = this.suite.parameterValues(key);
            if (values.isEmpty()) {
                throw new ConfigurationException(key + " has no values. " + "Did you forget a -D" + key + "=<value> command line argument?");
            }
            result.putAll((Object)key, values);
        }
        return result;
    }

    private List<Scenario> createScenarios() {
        ArrayList<ScenarioBuilder> builders = new ArrayList<ScenarioBuilder>();
        builders.add(new ScenarioBuilder());
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
        variables.put("vm", this.userVms.isEmpty() ? VmFactory.defaultVms() : this.userVms);
        variables.put("trial", this.newListOfSize(this.trials));
        variables.putAll(this.userParameters.asMap());
        variables.putAll(this.vmParameters.asMap());
        for (Map.Entry entry : variables.entrySet()) {
            Iterator values = ((Collection)entry.getValue()).iterator();
            if (!values.hasNext()) {
                throw new ConfigurationException("Not enough values for " + entry);
            }
            String firstValue = (String)values.next();
            for (ScenarioBuilder builder : builders) {
                builder.variables.put((String)entry.getKey(), firstValue);
            }
            int size = builders.size();
            while (values.hasNext()) {
                String alternate = (String)values.next();
                for (int s = 0; s < size; ++s) {
                    ScenarioBuilder copy = ((ScenarioBuilder)builders.get(s)).copy();
                    copy.variables.put((String)entry.getKey(), alternate);
                    builders.add(copy);
                }
            }
        }
        ArrayList<Scenario> result = new ArrayList<Scenario>();
        for (ScenarioBuilder builder : builders) {
            result.add(this.normalizeScenario(builder.build()));
        }
        return result;
    }

    private Collection<String> newListOfSize(int count) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            result.add(Integer.toString(i));
        }
        return result;
    }

    private static class ScenarioBuilder {
        final Map<String, String> variables = new LinkedHashMap<String, String>();

        private ScenarioBuilder() {
        }

        ScenarioBuilder copy() {
            ScenarioBuilder result = new ScenarioBuilder();
            result.variables.putAll(this.variables);
            return result;
        }

        public Scenario build() {
            return new Scenario(this.variables);
        }
    }
}

