/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;

namespace LocaleInpector
{

internal sealed class LocaleToPo
{


private PoEntryCollection m_po;

private LocaleToPo(PoEntryCollection.Duplicates method)
{
    m_po = new PoEntryCollection(method);
}

public static void Create(string xpiOriginal, string xpiTranslated, string poOutput)
{
    XpiList resOriginal = new XpiList(xpiOriginal);
    XpiList resTranslated = null;


    if (xpiTranslated == null) {
        Console.WriteLine("Exporting {0} as POT file {1}.", xpiOriginal, poOutput);
    } else {
        Console.WriteLine("Exporting {0} + {1} as PO file {2}.", xpiOriginal, xpiTranslated, poOutput);
        resTranslated = new XpiList(xpiTranslated);
    }

    //if (resOriginal.IsDir) {
    //    LocaleToPo instance = new LocaleToPo();
    //    xpiOriginal = Config.FixDirPath(xpiOriginal);
    //    instance.CreateCore(xpiOriginal, xpiTranslated, poOutput);

    //} else {

    if (resOriginal.Exists == false) {
        Console.WriteLine("{0} not found.", xpiOriginal);
        return;
    }

    //)) {
    LocaleToPo instance = new LocaleToPo(PoEntryCollection.Duplicates.Split);
    instance.CreateCore(resOriginal, resTranslated, poOutput);

    //} else {
    //    throw(new System.InvalidOperationException());
    //}
}

private void CreateCore(XpiList resOriginal, XpiList resTranslated, string poOutput)
{
    Status stat = new Status();

    for (int idx = 0; idx < resOriginal.Count; idx++) {
        // mailinglistheader-0.1.xpi|chrome/messenger-mailinglistheader.jar|locale/en/messenger-mailinglistheader/messenger-mailinglistheader.properties
        stat.Add(this.ParseFile(resOriginal, resTranslated, idx));
    }

    if (stat.Comparisons == 0) {
        Console.WriteLine("Locale not found.");
        return;
    }

    using (System.IO.StringWriter txt = new System.IO.StringWriter()) {

        txt.WriteLine(@"# Summary");
        txt.WriteLine(@"# =======");
        txt.WriteLine(@"# Files:   {0}", stat.Files);
        txt.WriteLine(@"# Phrases: {0}", stat.Comparisons);
        txt.WriteLine();
        txt.WriteLine(@"msgid """"");
        txt.WriteLine(@"msgstr """"");
        txt.WriteLine(@"""MIME-Version: 1.0\n""");
        txt.WriteLine(@"""Content-Type: text/plain; charset=UTF-8\n""");
        txt.WriteLine(@"""Content-Transfer-Encoding: 8bit\n""");
        txt.WriteLine(@"""X-Generator: po-locale\n""");
        txt.WriteLine();
        m_po.Serialize(txt);
        txt.WriteLine();

        //System.Text.StringBuilder src = txt.GetStringBuilder();
        BPIO.Save(txt.ToString(), poOutput, BPIO.UTF8);
    }

    //Console.WriteLine(" OK");
}

private Status ParseFile(XpiList xpiOriginal, XpiList translatedInputDir, int idxOriginal)
{
    Status stat = new Status();
    string file = xpiOriginal.GetFile(idxOriginal);
    NameValueFile originalFile = NameValueFile.Load(file);
    if (originalFile == null) {
        // unknown format (binary, html, ...)
        return stat;
    }
    Dictionary<string, string> originalKeys = originalFile.LoadHashtableDecoded();

    NameValueFile translatedFile = null;
    Dictionary<string, string> translatedKeys = null;

    if (translatedInputDir != null) {
        string myFile = translatedInputDir.GetFile(file);
        if (myFile != null) {
            translatedFile = NameValueFile.LoadTranslated(myFile);
            if (translatedFile != null) {
                translatedKeys = translatedFile.LoadHashtableDecoded();
            }
        }
    }


    if (translatedFile == null) {
        // translated file not specified or is empty
        translatedKeys = new Dictionary<string, string>();
    }




    stat.Files++;

/*
    Dictionary<string, string>.Enumerator originalKeyNames = originalKeys.GetEnumerator();
    Dictionary<string, string>            origWithAccessKeys = new Dictionary<string, string>();

    // join accesskeys+labels
    while (originalKeyNames.MoveNext()) {
        string keyTest = originalKeyNames.Current.Key;
        if (origWithAccessKeys.ContainsValue(keyTest)) {
            continue;
        }

        string accesskeyKeyLabelTest = AccessKey.GetAccesskeyKey(originalKeys, keyTest);
        if (accesskeyKeyLabelTest != null) {
            if (origWithAccessKeys.ContainsKey(accesskeyKeyLabelTest)) {
                origWithAccessKeys.Remove(accesskeyKeyLabelTest);
            }
        }
        origWithAccessKeys.Add(keyTest, accesskeyKeyLabelTest);
    }
    Dictionary<string, string>.Enumerator allKeys = origWithAccessKeys.GetEnumerator();
*/
    Dictionary<string, string>.Enumerator allKeys = GetXXX(originalKeys);

    // add to m_pot
    while (allKeys.MoveNext()) {

        string valueKey = allKeys.Current.Key;
        string akKey    = allKeys.Current.Value;

        string origVal = originalKeys[valueKey];
        string tranVal = translatedKeys.ContainsKey(valueKey) ? translatedKeys[valueKey] : string.Empty;
        string comment = "Position:" + System.Environment.NewLine + file + " -> " + valueKey;

        // no access key
        if (akKey == null) {
            if (m_po.AddEntry(file, valueKey, origVal, tranVal, comment)) {
                stat.Comparisons++;
            }
            continue;
        }

        // access key
        string originalAccesskey = originalKeys[akKey];
        if (originalAccesskey.Length > 1) {
            throw(new System.InvalidOperationException(origVal));
        }

        origVal = InsertAccesskey(origVal, originalAccesskey);


        string aktrans = translatedKeys.ContainsKey(akKey) ? translatedKeys[akKey] : string.Empty;
        tranVal = InsertAccesskey(tranVal, aktrans);

        if (m_po.AddEntry(file, valueKey + "*" + akKey, origVal, tranVal, comment)) {
            stat.Comparisons++;
        }

    }

    return stat;
}


private static Dictionary<string, string>.Enumerator GetXXX(Dictionary<string, string> originalKeys)
{
    Dictionary<string, string>.Enumerator originalKeyNames = originalKeys.GetEnumerator();
    Dictionary<string, string>            origWithAccessKeys = new Dictionary<string, string>();

    // join accesskeys+labels
    while (originalKeyNames.MoveNext()) {
        string keyTest = originalKeyNames.Current.Key;
        if (origWithAccessKeys.ContainsValue(keyTest)) {
            continue;
        }

        string accesskeyKeyLabelTest = AccessKey.GetAccesskeyKey(originalKeys, keyTest);
        if (accesskeyKeyLabelTest != null) {
            if (origWithAccessKeys.ContainsKey(accesskeyKeyLabelTest)) {
                origWithAccessKeys.Remove(accesskeyKeyLabelTest);
            }
        }
        origWithAccessKeys.Add(keyTest, accesskeyKeyLabelTest);
    }
    return origWithAccessKeys.GetEnumerator();
}


private static string InsertAccesskey(string val, string ak)
{
    if (ak.Length == 0) {
        return val;
    }
    int idx;
    idx = val.IndexOf(ak);
    if (idx > -1) {
        return val.Insert(idx, "&");
    }
    string lower = val.ToLower();
    idx = lower.IndexOf(ak.ToLower());
    if (idx > -1) {
        return val.Insert(idx, "&");
    }
    return val + "(&" + ak + ")";
}


}//class
}//ns