var fileList = new Array ( );
var partitionList = new Array ( );
var currLocation;

function xulfmInit() {
	
	var partitionTestArray = ["a","b","c","d","e","f","g","h","i"];
	var dir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
	for(var i=0; i<8; ++i) {
		dir.initWithPath(partitionTestArray[i] + ":\\");
		if(dir.exists())
			partitionList.push(partitionTestArray[i]);
		
	}
	
	readFolder("root");
	
	// Developer Features, to be disabled
	window.setTimeout(function(){toOpenWindowByType("global:console", "chrome://global/content/console.xul");}, 100);
	document.getElementById("menu_FilePopup").parentNode.setAttribute("onclick", "if(event.button == 1) goQuitApplication();");
	
}

function xulfmShutdown() {
	
	
}

function changeLocationOrOpen(newLocation) {
	
	var file = getLocalFileFromNativePathOrUrl(newLocation);
	if(file.isFile()) {
		file.launch();
	}
	else {
		readFolder(newLocation);
	}
}

function readFolder(location) {
	
	var start = ( new Date() ).getTime();
	
	// Clear current contents (by removing the filebox element and adding it back - prob faster than removing all the file children)
	var appcontent = document.getElementById("appcontent");
	appcontent.removeChild(appcontent.firstChild);  // cant use document.getElementById("filebox") ?
	var fileBox = document.createElement("hbox");
	fileBox.setAttribute("flex", "1");
	fileBox.setAttribute("style", "display:block; overflow:auto; background-color:white;");
	fileBox.setAttribute("id", "filebox");
	fileBox.setAttribute("currDir", location);
	appcontent.appendChild(fileBox);
	
	if(location == "root") {
		makeRootDir();
		setBackLinks(location);
		return;
	}
	var dir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
	dir.initWithPath(location);
	d(dir.path);
	
	var currFiles = dir.directoryEntries;
	var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
	var fileProtHandler = ioService.getProtocolHandler("file").QueryInterface(Components.interfaces.nsIFileProtocolHandler);
	var filesArray = new Array ( );
	
	// Go though adding the folders to the view and putting the files in an array
	while (currFiles.hasMoreElements()) {
				
		var file = currFiles.getNext().QueryInterface(Components.interfaces.nsILocalFile);
		
		var button = document.createElement("button");
		button.setAttribute("label", " " + file.leafName);
		url = fileProtHandler.getURLSpecFromFile(file);
		button.setAttribute("url", url);
		//button.setAttribute("image", "moz-icon:" + url);  // takes too long
		button.setAttribute("filepath", file.path);
		button.setAttribute("ondblclick", "changeLocationOrOpen(this.getAttribute('filepath'));");

		if(file.isDirectory()) {
			button.setAttribute("image", "chrome://xulfm/skin/folder.png");
			fileBox.appendChild(button);
		}
		else {
			button.setAttribute("image", "chrome://xulfm/skin/unknown.png");
			//button.setAttribute("image", "moz-icon:" + button.getAttribute("url"));
			filesArray.push(button);
		}
			
	}
	// now add the files to the view
	for (var i = 0; i < filesArray.length; ++i) {
		fileBox.appendChild(filesArray[i]);
	}
	
	fileList = filesArray;
	
	setIcons(0);
	try{
		window.setTimeout(function(){setIcons(40);}, 0);	
	} catch(e){}
	
	setBackLinks(location);
	
	currLocation = location;
	
	var end = ( new Date() ).getTime();
	d("elapsed time: " + (end-start));
}

function setIcons(currIndex) {

	try {
		for(var i=currIndex; i<currIndex+40; ++i) {
			var button = fileList[i];
			button.setAttribute("image", "moz-icon:" + button.getAttribute("url"));
		}
		window.setTimeout(function(){setIcons(currIndex+40);}, 0);
	} catch (e) {}
	
}

function setBackLinks(location) {
	
	var selector = document.getElementById("locSelector");

	// Clear out existing
	var oldChildren = selector.childNodes;
	var oldLength = oldChildren.length;
	for(var i=0; i<oldLength; ++i) {
		selector.removeChild(oldChildren[0]);
	}
	
	if(location == "root") {
		button = document.createElement("button");
		button.setAttribute("label", "root");
		selector.appendChild(button);
		return;
	}
	
	var folderHier = location.split("\\");
	var button;
	for(var j=0; j<folderHier.length; ++j) {
		if(folderHier[j] != "") {
			button = document.createElement("button");
			button.setAttribute("label",folderHier[j]);
			button.setAttribute("orderNum", j);
			button.setAttribute("onclick", "navigateBackLink(this.getAttribute('orderNum'))");
			selector.appendChild(button);
		}
	}
}

function navigateBackLink(num) {

	var ordinal = parseInt(num);
	var folderHier = currLocation.split("\\");
	var newLocation = folderHier[0];
	for(var i=1; i<ordinal+1; ++i) {
		newLocation = newLocation + "\\" + folderHier[i];
	}
	readFolder(newLocation);
}

function makeRootDir() {
	
	var fileBox = document.getElementById("filebox");
	
	for(var i=0; i<partitionList.length; ++i) {
		
		var button = document.createElement("button");
		button.setAttribute("label", " " + partitionList[i] + ":");
		button.setAttribute("url", "file:///" + partitionList[i] + ":/");
		button.setAttribute("image", "chrome://xulfm/skin/folder.png");
		button.setAttribute("filepath", partitionList[i] + ":\\");
		button.setAttribute("ondblclick", "changeLocationOrOpen(this.getAttribute('filepath'));");
		fileBox.appendChild(button);
	}
	
	
}

function test() {
	
	d(document.getElementById("filebox").lastChild.getAttribute("url"));
	
	//document.getElementById("content").webNavigation.loadURI("d:", nsIWebNavigation.LOAD_FLAGS_NONE, null, null, null);
	var fileBox = document.getElementById("filebox");
	var button = document.createElement("button");
	button.setAttribute("label","A Button");
	fileBox.appendChild(button);
}

function goUp() {
	
	var dir = getLocalFileFromNativePathOrUrl(document.getElementById("filebox").getAttribute("currDir"));
	if(dir.path.length == 2) // Windows assumption "c:" or "d:"
		readFolder("root");
	else
		readFolder(dir.parent.path);
	
}

function customizeToolbar() {
  // Disable the toolbar context menu items
  var menubar = document.getElementById("main-menubar");
  for (var i = 0; i < menubar.childNodes.length; ++i)
    menubar.childNodes[i].setAttribute("disabled", true);
    
  //var cmd = document.getElementById("cmd_CustomizeToolbars");
  //cmd.setAttribute("disabled", "true");
  
  window.openDialog("chrome://global/content/customizeToolbar.xul", "CustomizeToolbar",
                    "chrome,all,dependent", document.getElementById("navigator-toolbox"));
}

// this function and following comments from firefox 1.0.4 download manager 
// we should be using real URLs all the time, but until 
// bug 239948 is fully fixed, this will do...
function getLocalFileFromNativePathOrUrl(aPathOrUrl) {
  if (aPathOrUrl.substring(0,7) == "file://") {

    // if this is a URL, get the file from that
    ioSvc = Components.classes["@mozilla.org/network/io-service;1"]
      .getService(Components.interfaces.nsIIOService);

    // XXX it's possible that using a null char-set here is bad
    const fileUrl = ioSvc.newURI(aPathOrUrl, null, null).
      QueryInterface(Components.interfaces.nsIFileURL);
    return fileUrl.file.clone().
      QueryInterface(Components.interfaces.nsILocalFile);

  } else {

    // if it's a pathname, create the nsILocalFile directly
    var f = Components.classes["@mozilla.org/file/local;1"].
      createInstance(Components.interfaces.nsILocalFile);
    f.initWithPath(aPathOrUrl);

    return f;
  }
}

// Dump a message to Javascript Console
function d(msg){
	var acs = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
	acs.logStringMessage(msg);
}