/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _EPHY_AUTOMATION_H_
#define _EPHY_AUTOMATION_H_

#include "EphyAutomation.h"

#include <bonobo/bonobo-control.h>
#include <bonobo/bonobo-object.h>

G_BEGIN_DECLS

#define EPHY_AUTOMATION_TYPE         (ephy_automation_get_type ())
#define EPHY_AUTOMATION(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), EPHY_AUTOMATION_TYPE, EphyAutomation))
#define EPHY_AUTOMATION_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), EPHY_AUTOMATION_TYPE, EphyAutomationClass))
#define EPHY_AUTOMATION_IS_OBJECT(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), EPHY_AUTOMATION_TYPE))
#define EPHY_AUTOMATION_IS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), EPHY_AUTOMATION_TYPE))
#define EPHY_AUTOMATION_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), EPHY_AUTOMATION_TYPE, EphyAutomationClass))

typedef struct {
        BonoboObject parent;
} EphyAutomation;

typedef struct {
        BonoboObjectClass parent_class;

        POA_GNOME_EphyAutomation__epv epv;
} EphyAutomationClass;

GType          ephy_automation_get_type (void);

BonoboObject  *ephy_automation_new      (void);

G_END_DECLS

#endif /* _EPHY_AUTOMATION_H_ */
