/*$Id: fkLoadGroup.h,v 1.4 2007/08/16 12:06:19 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKLOADGROUP_H
#define FKLOADGROUP_H

#include "nsISupports.h"
#include "nsISupportsUtils.h"


#include "nsILoadGroup.h"
#include "nsIRequestObserver.h"
#include "nsIRequest.h"
#include "nsIChannel.h"

#include "nsWeakReference.h"
#include "nsInterfaceHashtable.h"

#include "fkILoadGroupProxy.h"

#include "Error.h"
#include "fkCallbacks.h"

/*
  fkLoadGroup is a proxy that passes calls to oryginal fkRequest's
  LoadGroup. It is needed to change nsIRequest argument in
  OnStopRequest and OnStartRequest methods to fkRequest.
  Without this Firefox can't identify request that has started or
  stopped.
*/
class fkLoadGroup: public nsILoadGroup
                 , public nsIRequestObserver
                 , public fkILoadGroupProxy
                 , public nsSupportsWeakReference
{
 public:
	NS_DECL_ISUPPORTS
        NS_DECL_NSILOADGROUP
        NS_DECL_NSIREQUEST
        NS_DECL_NSIREQUESTOBSERVER
        NS_DECL_FKILOADGROUPPROXY

        fkLoadGroup(nsILoadGroup *);

	virtual ~fkLoadGroup();

	NS_IMETHODIMP init();

private:
	//nsCOMPtr<nsIRequest> fkRequest;
	//nsCOMPtr<nsIChannel> fkChannel;

	nsCOMPtr<nsIRequestObserver> origObserver;
	nsCOMPtr<nsILoadGroup> origLoadGroup;
	nsCOMPtr<nsIRequest> origRequest;

	nsInterfaceHashtable<nsISupportsHashKey, nsIRequest> *proxyRequests;
	nsInterfaceHashtable<nsISupportsHashKey, nsIRequest> *origRequests;

	nsCOMPtr<nsIInterfaceRequestor> callbacksProxy;

	void checkResult(nsresult rv, const char *iname){
#ifdef DEBUG
		if (NS_FAILED(rv))
			TRACE("fkLoadGroup Can't get reference to %s interface %d",
			      iname, rv);
#endif
	}
};

#endif
