/*$Id: fkStreamListener.h,v 1.19 2008/05/18 10:29:01 jwrobel Exp $*/

/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006,2007,2008 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKSTREAMLISTENER_H
#define FKSTREAMLISTENER_H

#include "nsIChannel.h"
#include "nsIHttpChannel.h"
#include "fkSentence.h"
#include "fkRequestExaminator.h"

#include "nsISupports.h"
#include "nsISupportsUtils.h"
#include "nsWeakReference.h"
#include "nsIStreamListenerTee.h"
#include "nsIRequestObserver.h"
#include "nsIHttpHeaderVisitor.h"

#include "nsEmbedString.h"

#include "ActiveRuleSet.h"


#define BODY_INIT_SIZE    4096
#define HEADERS_INIT_SIZE 1024

/*StreamListener that checks data available for reading and
  if it is ok, passes it to oryginal StreamListener*/
class fkStreamListener : public nsIStreamListenerTee
                       , public nsIHttpHeaderVisitor
{
public:
	fkStreamListener();
	virtual ~fkStreamListener();

	NS_DECL_ISUPPORTS
        NS_DECL_NSISTREAMLISTENERTEE
        NS_DECL_NSISTREAMLISTENER
        NS_DECL_NSIREQUESTOBSERVER
        NS_DECL_NSIHTTPHEADERVISITOR

private:
	NS_IMETHODIMP checkBody();
	NS_IMETHODIMP do_OnDataAvailable(nsIRequest *request, nsISupports* acontext);
	NS_IMETHODIMP do_LastOnDataAvailable(nsIRequest *request, nsISupports* acontext);
	
	
	NS_IMETHODIMP headers_append(const char *src, PRUint32 len);
	NS_IMETHODIMP expandBuf(char **buf, PRUint32 len, PRUint32 end, 
				PRUint32 &max_size);

	NS_IMETHODIMP InitRequest(nsIRequest *request);
	void checkHeaders();
	
	void drawFlushPoint();
	void drawNoFlushPoint();
	const char* getURL();

	nsCOMPtr<nsIStreamListener> origListener;
	nsCOMPtr<nsIChannel> channel;	
	nsCOMPtr<nsIHttpChannel> httpChannel;	
	fkRequestExaminator *examinator;

	/*Fragment of received body*/
	char *body;
	
	/*Received headers*/
	char *headers;
	/*Url of channel that transmits data through this stream*/
	nsEmbedCString url;
	
	/*length of body in a buffer and headers*/
	PRUint32 body_len, headers_len;
	
	/*size of a body and headers buffer*/
	PRUint32 body_max, headers_max;
	PRUint32 offset;
	const fkSentence* sentence;

	bool debugNoHeaders;
	/*How much body to read before passing it to the oryginal listener.*/
	PRUint32 flush_point;
	/*How many bytes from the end of a body fragment append to the 
	  beginning of a next fragment.*/
	PRUint32 no_flush_point;
};

#endif
