/*$Id: Rules.h,v 1.1 2006/08/20 16:39:04 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef RULES_H
#define RULES_H

#include "Common.h"
#include "Rule.h"
#include "Error.h"
#include "str_search.h"


struct ltstr
{
  bool operator()(const char* s1, const char* s2) const
  {
    return strcmp(s1, s2) < 0;
  }
};

/*action_id -> set of rules with this action*/
typedef map<int, set<Rule *> > RuleSet;

//typedef map<int, list<Rule *>, ltstr> RuleSet;

#define URL_CONTENT     0
#define HEADERS_CONTENT 1
#define BODY_CONTENT    2

#define NACTIONS 3
extern const char *knownActions[];
/*TODO: more configurable*/

extern SearchAPI *searchAPI;


class Rules
{
 private:	
	RuleSet ruleSet;
	RuleSet noContentRules;	


	/*used to inform http channel that new rules are loaded 
	  and old shouldn't be used*/
	unsigned int rulesVersion;

 public:
	Rules();
	int init();
	~Rules();
	
	RuleSet* getNoContentRuleSet();
	void addRule(Rule *);	
	void resetRules();	
	
	unsigned int getRulesVersion();
};

#endif
