/*$Id: RuleSyntax.h,v 1.5 2006/08/20 16:39:04 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef RULE_SYNTAX_H
#define RULE_SYNTAX_H
/*
alert (msg: " "; url_content: ; header_content: ; body_conent: ; url_re:; header_re: ; body_re: ; reference:cve,2004-0258; reference:bugtraq,9579; fid:2439; rev:5;)
pass   
drop
*/


const char *rulePattern = "\
(?x)         #turn on extended syntax \n\
^            #whole line must match \n\
[[:space:]]* #white spaces at the beginning of a rule are ok\n\
(            \
[[:word:]]+  #action\n\
)            \
[[:space:]]* \
\\(          \
(            \
.*           #rule options \n\
)            \
\\)          \
[[:space:]]* #white spaces at the end of a rule are ok\n\
$            \
";

#define OPTION_VALUE         "[[:space:]]*\"(.*?[^\\\\])\"[[:space:]]*;"
#define OPTION_VALUE_WITH_QT "[[:space:]]*(\".*?[^\\\\]\")[[:space:]]*;"

const char *msgPattern = "msg:" OPTION_VALUE;

const char *referencePattern = "\
(?x)                             \
reference:                       #pointer to site that has more info about alert\n\
[[:space:]]*                     \
(bugtraq|cve|nessus|mcafee|url)  #same systems that Snort supports.\n\
[[:space:]]*,[[:space:]]*        \
(.*?)                            \
[[:space:]]*;                    \
";

const char *fidPattern = "fid:[[:space:]]*([[:digit:]]+)[[:space:]]*;";
const char *revPattern = "rev:[[:space:]]*([[:digit:]]+)[[:space:]]*;";

#define OPTIONAL_NOCASE "([[:space:]]*nocase[[:space:]]*;)?"

const char *urlContentPattern = "url_content:" OPTION_VALUE_WITH_QT OPTIONAL_NOCASE;
const char *headersContentPattern = "headers_content:" OPTION_VALUE_WITH_QT OPTIONAL_NOCASE;
const char *bodyContentPattern = "body_content:" OPTION_VALUE_WITH_QT OPTIONAL_NOCASE;

const char *headersRegPattern = "headers_re:" OPTION_VALUE;

const char *bodyRegPattern = "body_re:" OPTION_VALUE;

const char *urlRegPattern = "url_re:" OPTION_VALUE;


#endif
