/*
 * Decompiled with CFR 0.152.
 */
package org.l10nZilla.writer;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.l10nZilla.Phrase;
import org.l10nZilla.TranslationFile;
import org.l10nZilla.writer.translationsWriter;

public class mozHTMLWriter
extends translationsWriter {
    private String languageCode;
    private String fileName;
    private OutputStream fout;
    private BufferedOutputStream bout;
    private OutputStreamWriter out;
    private boolean closeTableFlag;

    public mozHTMLWriter(String install, String destination) {
        super(install, destination);
        try {
            this.fout = new FileOutputStream(destination);
            this.bout = new BufferedOutputStream(this.fout);
            this.out = new OutputStreamWriter((OutputStream)this.bout, "UTF-8");
            this.out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
            this.out.write("\r\n");
            this.out.write("\"http://www.w3.org/TR/html4/loose.dtd\">");
            this.out.write("\r\n");
            this.out.write("<html>");
            this.out.write("\r\n");
            this.out.write("<head>");
            this.out.write("\r\n");
            this.out.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            this.out.write("\r\n");
            this.out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"lpdiff.css\">");
            this.out.write("\r\n");
            this.out.write("<title>Mozilla Language Pack Diff</title>");
            this.out.write("\r\n");
            this.out.write("</head>");
            this.out.write("\r\n");
            this.out.write("<body>");
            this.out.write("\r\n");
            this.out.write("<br>");
            this.out.write("\r\n");
            this.out.write("Copyright \u00a9 2003 by Welsh Language Pack Contributors under the <a href=\"http://www.mozilla.org/MPL/\">");
            this.out.write("\r\n");
            this.out.write("Mozilla Public License</a> .  All Rights Reserved.<br>");
            this.out.write("\r\n");
            this.out.write("<br>");
            this.out.write("\r\n");
            this.out.write("\r\n");
            this.out.write("<u>Welsh Language Pack Contibutors</u><br>");
            this.out.write("\r\n");
            this.out.write("<ul>");
            this.out.write("\r\n");
            this.out.write("<li>Dewi Jones (DewiJones@gwelywiwr.org)</li>");
            this.out.write("\r\n");
            this.out.write("<li>Rhoslyn Prys (RhoslynPrys@gwelywiwr.org)</li>");
            this.out.write("\r\n");
            this.out.write("<li>Delyth Prys</li>");
            this.out.write("\r\n");
            this.out.write("</ul>");
        }
        catch (Exception e) {
            System.out.println("Error constructing HTML writer. Does destination directory exist?");
            System.exit(1);
        }
    }

    public void prepareExportFile() {
    }

    public void exportFile(TranslationFile currentFile) {
        try {
            if (!currentFile.getFileName().endsWith("rdf")) {
                this.out.write("\r\n");
                this.out.write("<div class=\"name\">");
                this.out.write("<p>");
                this.out.write(String.valueOf(String.valueOf(currentFile.getFilePath())).concat(String.valueOf(String.valueOf(currentFile.getFileName()))));
                this.out.write("</p>");
                this.out.write("</div>");
                this.out.write("<table>");
                this.out.write("<tr>");
                this.out.write(String.valueOf(String.valueOf(new StringBuffer("<th>Status(Quality)</th><th>Label</th><th>Source (en)</th><th>Target (").append(this.getTargetLanguageCode()).append(")</th>"))));
                this.out.write("</tr>");
                this.closeTableFlag = true;
            } else {
                this.closeTableFlag = false;
            }
        }
        catch (Exception e) {
            System.out.println("Trouble with closing file tag");
            System.exit(1);
        }
    }

    public void exportPhrase(Phrase currentPhrase) {
        String sourceText = currentPhrase.getText();
        String targetText = currentPhrase.getTranslatedText();
        sourceText = this.replacePredefinedEntity("&", sourceText, "&amp;");
        sourceText = this.replacePredefinedEntity("<", sourceText, "&lt;");
        sourceText = this.replacePredefinedEntity(">", sourceText, "&gt;");
        sourceText = this.replacePredefinedEntity("'", sourceText, "&apos;");
        sourceText = this.replacePredefinedEntity("\"", sourceText, "&quot;");
        targetText = this.replacePredefinedEntity("&", targetText, "&amp;");
        targetText = this.replacePredefinedEntity("<", targetText, "&lt;");
        targetText = this.replacePredefinedEntity(">", targetText, "&gt;");
        targetText = this.replacePredefinedEntity("'", targetText, "&apos;");
        targetText = this.replacePredefinedEntity("\"", targetText, "&quot;");
        try {
            this.out.write("\r\n");
            this.out.write("<tr class=\"");
            if (!currentPhrase.isTranslationNeeded() && currentPhrase.getTranslationQuality() < 6) {
                this.out.write("match");
            } else {
                this.out.write("modify");
            }
            this.out.write("\">");
            this.out.write("\r\n");
            this.out.write(String.valueOf(String.valueOf(new StringBuffer("<td>").append(currentPhrase.getTranslationQualityName()).append("</td>").append("<td>").append(currentPhrase.getKey()).append("</td><td>").append(sourceText).append("</td><td>").append(targetText).append("</td></tr>"))));
        }
        catch (Exception e) {
            System.out.println("Error writing HTML entry");
            System.exit(1);
        }
    }

    public void concludeExportFile() {
        try {
            if (this.closeTableFlag) {
                this.out.write("</table>");
            }
        }
        catch (Exception e) {
            System.out.println("Problem with closing file tag");
            System.exit(1);
        }
    }

    public void close() {
        try {
            this.out.write("</body></html>");
            this.out.flush();
            this.out.close();
        }
        catch (Exception e) {
            System.out.println("Error closing HTML file ");
            System.exit(1);
        }
    }

    public String getTargetLanguageCode() {
        return this.languageCode;
    }

    public void setTargetLanguageCode(String targetLanguage) {
        this.languageCode = targetLanguage;
    }

    public boolean needTranslatorObject() {
        return true;
    }

    private String replacePredefinedEntity(String entity, String someText, String replacement) {
        String resultText = "";
        for (int i = 0; i < someText.length(); ++i) {
            String ch = someText.substring(i, i + 1);
            resultText = ch.equalsIgnoreCase(entity) ? String.valueOf(String.valueOf(resultText)).concat(String.valueOf(String.valueOf(replacement))) : String.valueOf(String.valueOf(resultText)).concat(String.valueOf(String.valueOf(ch)));
        }
        return resultText;
    }
}

