#!/bin/sh

version=`cat version.txt`

cd ../downloads
sed -e "s/@VERSION@/$version/g" < update.rdf.template > update.rdf

cp mailredirectalternative-cvs.xpi mailredirectalternative.xpi

# create tar.gz
cd ../src
rm -rf mailredirectalternative
mkdir mailredirectalternative
cp -al content locale install.js.template install.rdf.template BUGS Changelog skin skin-moz version.txt 1-cvs.sh 2-release.sh make-lang.sh chrome.manifest mailredirectalternative 
tar cvf - mailredirectalternative | gzip -9c > "../downloads/src/mailredirectalternative-src-$version.tar.gz"
rm -rf mailredirectalternative

cd ../downloads/src
rm -f mailredirectalternative-src-latest.tar.gz
ln -s "mailredirectalternative-src-$version.tar.gz" mailredirectalternative-src-latest.tar.gz

