#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <sysexits.h>
#include <signal.h>
#include <stdarg.h>
#include <npapi.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <errno.h>
#include <sys/time.h>
#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <sys/socket.h>

#define DEBUG_FILENAME "/tmp/mozdebug"

#ifndef MAXINT
#define MAXINT 0x7fffffff
#endif

/*****************************************************************************
 * Swallow loop parameters
 *****************************************************************************/
#define SWALLOW_LOOPS     4000
/* Do not increase this wait time or the swallow will not work
 * correctly on some computers. */
#define SWALLOW_WAIT_TIME 500

/*****************************************************************************
 * Options
 *****************************************************************************/
#define H_LOOP 		0x1
#define H_MANY 		0x2
#define H_STREAM 	0x4
#define H_NOISY 	0x8
#define H_REPEATCOUNT 	0x10
#define H_NOFULL 	0x20
#define H_DAEMON 	0x40
#define H_EXITS 	0x80
#define H_IGNORE_ERRORS 0x100
#define H_SWALLOW 	0x200
#define H_MAXASPECT 	0x400
#define H_FILL 		0x800
#define H_EVENT_SWALLOW 0x1000

/*****************************************************************************
 * mozplugger-common.c functions
 *****************************************************************************/
#ifdef DEBUG
void close_debug();
#endif
void D(char *fmt, ...);
void my_kill(int pid);
void maximize_window(int flags, Display *display, int victim, int w, int h);
