/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.multexi.taglib;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.mozdev.multexi.IConstants;
import org.mozdev.multexi.taglib.DefaultTableTag;
import org.mozdev.multexi.taglib.TabTableContentTag;

public class TabTableTag
extends DefaultTableTag {
    private static final long serialVersionUID = 1L;
    private String defaultTab = null;
    private String tableName = null;
    private String activeTabId = null;
    private String switchTabForward = null;
    private String tableUrl = null;
    private Hashtable tabContentTags = new Hashtable();

    public void registerContentTag(TabTableContentTag.TabTableContent contentTag) {
        this.tabContentTags.put(contentTag.getTabId(), contentTag);
    }

    public int doStartTag() throws JspException {
        return 6;
    }

    public int doEndTag() throws JspException {
        TabTableContentTag.TabTableContent contentTag;
        this.activeTabId = this.determineTabId();
        StringBuffer output = new StringBuffer();
        MessageResources i18n = MessageResources.getMessageResources((String)IConstants.RESOURCE_BOUNDLE);
        int tabCount = this.tabContentTags.size();
        if (tabCount == 0) {
            return 5;
        }
        output.append("<p class=\"content_menu_secondary\">\n");
        Enumeration tabs = this.tabContentTags.elements();
        while (tabs.hasMoreElements()) {
            contentTag = (TabTableContentTag.TabTableContent)tabs.nextElement();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            ModuleConfig config = (ModuleConfig)this.pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE");
            String url = String.valueOf(request.getContextPath()) + config.getPrefix() + "/" + this.tableUrl;
            output.append("<a class=\"menu_secondary\" href=\"" + url + "?tabId=" + contentTag.getTabId() + "\">");
            output.append(i18n.getMessage(contentTag.getTabLangKey()));
            output.append("</a>\n");
        }
        output.append("</p><p class=\"content_main\">");
        TagUtils.getInstance().write(this.pageContext, output.toString());
        tabs = this.tabContentTags.elements();
        while (tabs.hasMoreElements()) {
            contentTag = (TabTableContentTag.TabTableContent)tabs.nextElement();
            if (!this.activeTabId.equals(contentTag.getTabId())) continue;
            try {
                this.pageContext.include(contentTag.getPage());
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        output.setLength(0);
        output.append("</p>");
        TagUtils.getInstance().write(this.pageContext, output.toString());
        return 6;
    }

    protected String determineTabId() throws JspException {
        String tabName = (String)this.pageContext.getSession().getAttribute(String.valueOf(this.tableName) + "::currentTab");
        if (this.pageContext.getRequest().getParameter("tabId") != null) {
            tabName = this.pageContext.getRequest().getParameter("tabId");
            this.pageContext.getSession().setAttribute(String.valueOf(this.tableName) + "::currentTab", (Object)tabName);
        } else if (tabName == null) {
            this.pageContext.getSession().setAttribute(String.valueOf(this.tableName) + "::currentTab", (Object)this.defaultTab);
            return this.defaultTab;
        }
        return tabName;
    }

    public String getDefaultTab() {
        return this.defaultTab;
    }

    public void setDefaultTab(String defaultTab) {
        this.defaultTab = defaultTab;
    }

    public String getActiveTabId() {
        return this.activeTabId;
    }

    public void setActiveTabId(String activeTabId) {
        this.activeTabId = activeTabId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSwitchTabForward() {
        return this.switchTabForward;
    }

    public void setSwitchTabForward(String switchTabForward) {
        this.switchTabForward = switchTabForward;
    }

    public String getTableUrl() {
        return this.tableUrl;
    }

    public void setTableUrl(String tableUrl) {
        this.tableUrl = tableUrl;
    }
}

