gManagerWindow.init = function()
{
  this._windowType = "multizilla:permissionmanager";
  this._helpProperties = "chrome://multiviews/locale/permission-manager/permissionManager.properties";
  this._helpPage = "helpPages-PermissionManager";
  this._helpDelimiter = "helpDelimiter-PermissionManager";
  this._chromeBaseURL = "chrome://multiviews/content/permission-manager/panels/";
  this._linuxStylesheetURL = "chrome://multiviews/content/permission-manager/linux/permissionManager.css";
  this._bundle = gPermissionManager.init();
  this.initPrefWindow();
}

gManagerWindow.selectPanel = function()
{
  if (hPrefWindow) {
    hPrefWindow.selectPanel();
    gPermissionManager.selectPanel();
  }
}


var gPermissionManager =
{
  _addButton                    : null,
  _addTextbox                   : null,
  _bundle                       : null,
  _cm                           : null,
  _category                     : "",
  _categoryBar                  : null,
  _cbFileName                   : null,
  _documentTitle                : "",
  _foggyView                    : null,
  _hasImportOverlay             : false,
  _isCached                     : [],
  _isInitialised                : false,
  _importOverlayURL             : "chrome://multiviews/content/permission-manager/import/importOverlay.xul",
  _nsIIOService                 : null,
  _panelName                    : "",
  _patternPrefPrefix            : "multizilla.content-blocker.pattern.for.",
  _patternTypeNumbers           : [2, 3, 4, 5, 6], // skip: cookies, popups and install
  _pmCache                      : [null, null, null, null, null, null, null, null],
  _pref                         : null,
  _prefPanelNames               : null,
  _permissions                  : [],
  _permissionTypes              : ["cookie", "popup", "image", "object",
                                   "script", "document", "frame", "install"],
  _pm                           : null,
  _promptService                : null,
  _lastHost                     : "",
  _lastSortColumn               : "",
  _lastSortAscending            : "",
  _mainDeck                     : null,
  _rememberConfirmation         : false,
  _tree                         : null,
  // used in getCapabilityString only
  _ASK                          : "pmRequireAction",
  _CAN                          : "pmCanStr",
  _CANNOT                       : "pmCannotStr",
  _CANSESSION                   : "pmCanSession",
  _DEFAULT                      : "pmUseDefault",
  _DOMAINONLY                   : "pmDomainOnly",
  _REDIRECT                     : "pmWillRedirect",
    
  _view:
  {
    _rowCount: 0,
    _category: "",

    get rowCount() 
    { 
      return this._rowCount; 
    },

    getCellText: function(aRow, aColumn)
    {
      if (aRow >= 0) {
        // dump("\ngetCellText - row: " + aRow + " column: " + aColumn.id);
        if (aColumn.id == this._category + "DomainColumn")
          return gPermissionManager._permissions[aRow].domain;
        else if (aColumn.id == this._category + "CapabilityColumn")
          return gPermissionManager._permissions[aRow].capability;
      }
      return "";
    },

    cycleHeader : function(aColumn) {},
    getCellProperties : function(aRow, aColumn, aProp) {},
    getCellValue : function(aRow, aColumn) {},
    getColumnProperties : function(aColumn, aProp) {},
    getImageSrc : function(aRow, aColumn) {},
    getParentIndex : function(aRow) {return -1; },
    getProgressMode : function(aRow, aColumn) {},
    getRowProperties : function(aRow, aProp) {},
    isContainer : function(index) {return false;},
    isEditable: function(aRow, aColumn) { return true; },
    isSeparator : function(aIndex) {return false; },
    isSorted: function() {return false; },
    selectionChanged: function() {},
    setTree: function(aTree) {}
  },

  observe: function (aSubject, aTopic, aData) 
  {
    /* dump("\nobserve: triggered!" +
         "\naSubject: " + aSubject +
         "\naTopic  : " + aTopic +
         "\naData   : " + aData); */
    if (aSubject instanceof Ci.nsIPermission) {
      if (aTopic == "perm-changed") {
        var pObj = aSubject.QueryInterface(Ci.nsIPermission);

        if (aData == "changed") {
          for (var i = 0; i < this._permissions.length; ++i) {
            if (this._permissions[i].host == pObj.host) {
              var categoryNumber = this._permissionTypes.indexOf(pObj.type);
              this._permissions[i].capability = this.getCapabilityString(categoryNumber, pObj.capability);
              this._permissions[i].permission = pObj.capability;
              break;
            }
          }
          if (this._lastSortColumn.id == "StatusColumn") {
            gTreeUtils.sort(this._tree, this._view, this._permissions, 
                            this._lastSortColumn, this._lastSortAscending);
          }
          this._tree.treeBoxObject.invalidate();
        }
        else if (aData == "added") {
          this.cachePermission(pObj);
          ++this._view._rowCount;
          this._tree.treeBoxObject.rowCountChanged(this._view.rowCount - 1, 1);        
          // Re-do the sort, since we inserted this new item at the end. 
          gTreeUtils.sort(this._tree, this._view, this._permissions, 
                          this._lastSortColumn, this._lastSortAscending);        
        }
      }
    }
    else if (aData == "cleared") {
      this._permissions = [];
      var oldRowCount = this._view._rowCount;
      var category = this._category;
      var categoryIndex = this._permissionTypes.indexOf(pObj.type);
      this._pmCache[categoryIndex] = [];
      this._view._rowCount = 0;
      this._tree.treeBoxObject.rowCountChanged(0, -oldRowCount);
      this._view.selection.clearSelection();
    }
    else if (aData == "sort") {
      this.setFoggyViewTo(4);
      this.updateActionButtons(true);
    }
    else if (aData == "sorted") {
      this.setFoggyViewTo(0);
      this.updateActionButtons();
    }
  },

  init: function()
  {
    this._documentTitle = document.title;
    this._bundle = document.getElementById("permManagerPanelBundle");

    this._mainDeck = document.getElementById("mainDeck");
    this._mainView = document.getElementById("mainView"); // do we still need this?
    this._importView = document.getElementById("importView"); // do we still need this?
    this._categoryBar = document.getElementById("prefsTree");

    this._pm = Cc["@mozilla.org/permissionmanager;1"].getService(Ci.nsIPermissionManager);
    this._cm = Cc["@mozilla.org/cookiemanager;1"].getService(Ci.nsICookieManager),

    this._nsIIOService = gManagerWindow._nsIIOService;
    this._promptService = gManagerWindow._promptService;
    this._pref = gManagerWindow._pref;
    this._obs = gManagerWindow._obs;

    this._obs.addObserver(this, "perm-changed", false);
    this._prefPanelNames = this._bundle.getString("prefPanelNames").split(",");
    this._foggyView = document.getElementById("foggyView");

    return this._bundle;
  },

  postInit: function()
  {
    gPermissionManager.setFoggyViewTo(3);
    function _inner() {
      gPermissionManager.initPermissionsCache();
    }
    window.setTimeout(_inner, 0);
  },

  initPermissionsCache: function()
  {
    gPermissionManager.setFoggyViewTo(2);

    for (var i = 0; i < 8; i++)
      this._pmCache[i] = new Array();

    var enumerator = this._pm.enumerator;

    while (enumerator.hasMoreElements()) {
      var permission = enumerator.getNext().QueryInterface(Ci.nsIPermission);
      this.cachePermission(permission);
    }
    /* dump("\n\nCache statistics: " +
         "\n0: " + this._pmCache[0].length +
         "\n1: " + this._pmCache[1].length +
         "\n2: " + this._pmCache[2].length +
         "\n3: " + this._pmCache[3].length +
         "\n4: " + this._pmCache[4].length +
         "\n5: " + this._pmCache[5].length +
         "\n6: " + this._pmCache[6].length +
         "\n7: " + this._pmCache[7].length ); */

    this._isInitialised = true;
    this.loadPermissions();
    // sqlite.morkToSQLite();
    // sqlite.filterPrefsToSQLite();
  },

  cachePermission: function(aPermissionObj)
  {
    var host = aPermissionObj.host;
    var domain = (host.charAt(0) == ".") ? host.substring(1, host.length) : host;
    var capability = aPermissionObj.capability;
    var type = aPermissionObj.type
    var categoryNumber = this._permissionTypes.indexOf(type);

    if (categoryNumber >= 0 && categoryNumber < this._permissionTypes.length) {
      var capabilityString = this.getCapabilityString(categoryNumber, capability);
      var permObj = { host        : host,
                      domain      : domain,
                      type        : type,
                      capability  : capabilityString,
                      permission  : capability
                    };
      this._pmCache[categoryNumber].push(permObj);
    }
    else {
      /* dump("\nUnknown permission found! " +
           "\ntype       : " + aPermissionObj.type +
           "\nhost       : " + aPermissionObj.host +
           "\ndomain     : " + aPermissionObj.domain +
           "\ncapability : " + aPermissionObj.permission );
      this._pm.remove(aPermissionObj.host, aPermissionObj.type); */
    }
  },

  getCapabilityString: function(aCategoryNumber, aCapability)
  {
    var stringKey;
    /***
      * Possible capabilities:
      * 0 = Default (based on pref)
      * 1 = Allow
      * 2 = Block
      * 3 = Redirect to new tab
      * 4 = Ask
      * 8 = Domain only  / Session Cookie only
      */
    if (aCapability == 8)
      stringKey = (aCategoryNumber == 0) ? this._CANSESSION : this._DOMAINONLY;
    else if (aCapability < 3)
      stringKey = (aCapability == 0) ? this._DEFAULT : (aCapability == 1) ? this._CAN : this._CANNOT;
    else 
      stringKey = (aCapability == 3) ? this._REDIRECT : this._ASK;

    var categoryName = this._prefPanelNames[aCategoryNumber];
    return this._bundle.getFormattedString(stringKey, [categoryName], 1);
  },

  /* Permissions Panel */
  selectPanel: function()
  {
    this._permissions = [];
    this._view._rowCount = 0;
    this._lastSortColumn = "";
    this._lastSortAscending = "";

    if (this._tree)
      this._tree.treeBoxObject.view = null;

    var index = this._categoryBar.selectedIndex;
    this._panelName = this._prefPanelNames[index];

    var category = this._permissionTypes[index];

    this._category = category;
    this._view._category = category;

    var scope = this;
    var attempts = 0;
    var skipCheck = (index == this._permissionTypes.length);

    function _load() {
      if (skipCheck)
        scope.loadPermissions(index);
      else {
        scope._tree = document.getElementById(category + "PermissionsTree");

        if (scope._tree) {
          scope._addTextbox = document.getElementById(category + "AddTextbox");
          scope._addButton = document.getElementById(category + "AddButton");
          scope.loadPermissions(index);
        }
        else
          _delayedLoad(attempts++);
      }
    }
    function _delayedLoad() {
      // dump("\nattempts: " + attempts);
      if (attempts < 20)
        setTimeout(_load, 10);
      else {
        gManagerWindow.onPreloadError(index);
        return;
      }
    }
    if (this._isCached.indexOf(category))
      _load();
    else
      _delayedLoad();
  },

  loadPermissions: function(aIndex)
  {
    if (this._isInitialised) {
      this.setFoggyViewTo(1);
      var category = this._category;

      if (category == undefined)
        this.setFoggyViewTo(0);
      else {
        var index = (aIndex) ? aIndex : this._permissionTypes.indexOf(category);
        this._permissions = this._pmCache[index];
        var permCount = this._permissions.length;
        this._view._rowCount = permCount;
        this._tree.treeBoxObject.view = this._view;

        if (permCount && this._isCached.indexOf(category) == -1) {
          function _innerSort() {
            gPermissionManager.columnSort(category + "DomainColumn", "", true);
            gPermissionManager.setFoggyViewTo(0);
          }
          if (permCount < 2000)
            _innerSort();
          else {
            var delay = (permCount / 1000) * 2;
            // dump("\npermCount: " + permCount);
            // dump("\ndelay: " + delay);
            window.setTimeout(_innerSort, delay);
          }
        }
        else {
          this.setFoggyViewTo(0);
        }
        this._isCached.push(category);
      }
    }
    else { // First call, right after startup!
      this.setFoggyViewTo(4);
      this.postInit();
    }
  },

  setFoggyViewTo: function(aStage)
  {
    // dump("\naStage: " + aStage);
    switch(aStage) {
      case 4:
        this._foggyView.removeAttribute("disabled");
        this._foggyView.style.opacity = 0.4;
        break;
      case 3:
        this._foggyView.style.opacity = 0.3;
        break;
      case 2:
        this._foggyView.style.opacity = 0.2;
        break;
      case 1:
        this._foggyView.style.opacity = 0.1;
        break;
      case 0:
        this._foggyView.setAttribute("disabled", "true");
    }
  },

  updateActionButtons: function(aDisableFlag)
  {
    /* dump("\nupdateActionButtons" + 
         "\n_view.rowCount     : " + this._view.rowCount +
         "\ntree.currentIndex  : " + tree.currentIndex +
         "\nselectedRows.length: " + selectedRows.length); */

    var tree = this._tree;
    var category = this._category;
    var panelID = category + "Permissions";
    var permPanel = document.getElementById(panelID);
    var selectedRows = gTreeUtils._getTreeSelections(this._view);
    var disableAll = (aDisableFlag || this._view.rowCount < 1 ||
                      tree.currentIndex < 0 || selectedRows.length == 0);

    if (disableAll) {
      for (var i = 0; i < permPanel.mActionButtonBox.childNodes.length; i++)
        permPanel.mActionButtonBox.childNodes[i].disabled = true;

      permPanel.deleteButton.setAttribute("disabled", "true");
    }
    else {
      var capability = this._permissions[tree.currentIndex].permission;

      if (category == "popup") {
        var redirectorEnabled = this._pref.getBoolPref("multizilla.window-open.redirector");
        permPanel.redirectButton.disabled = (!redirectorEnabled || (capability == 3));
        permPanel.askmeButton.disabled = (redirectorEnabled && (capability != 4));
      }
      else if (category == "cookie") {
        permPanel.sessionButton.disabled = (capability == 8); // nsICookiePermission.ACCESS_SESSION);
      }
      if (selectedRows.length == 1) {
        permPanel.blockButton.disabled = (capability == this._pm.DENY_ACTION);
        permPanel.acceptButton.disabled = (capability == this._pm.ALLOW_ACTION);
        permPanel.domainButton.disabled = (capability == 8);
        permPanel.askmeButton.disabled = (capability == 4);
      }
      permPanel.deleteButton.removeAttribute("disabled");
    }
  },

  initContextMenu: function(aEvent)
  {
    const CM_SELECT_ALL     = 0;
    const CM_SELECT_NONE    = 1;
    const CM_SEPARATOR_1    = 2;
    const CM_BLOCK          = 3;
    const CM_ACCEPT         = 4;
    const CM_ACCEPT_SITE    = 5;
    const CM_SESSION_COOKIE = 6;
    const CM_SEPARATOR_2    = 7;
    const CM_REDIRECT       = 8;
    const CM_ASK_ME         = 9;
    const CM_SEPARATOR_3    = 10;
    const CM_REMOVE         = 11;

    var bundle = this._bundle;
    var category = this._category;
    var index = this._permissionTypes.indexOf(category);
    var panelName = [this._prefPanelNames[index]];
    var contextMenuItems = aEvent.originalTarget.childNodes;

    // if (category != this._previousCategory) {
      contextMenuItems[CM_BLOCK].label = bundle.getFormattedString("pmBlock", panelName, 1);
      contextMenuItems[CM_ACCEPT].label = bundle.getFormattedString("pmAllow", panelName, 1);
      contextMenuItems[CM_SESSION_COOKIE].label = bundle.getFormattedString("pmSession", panelName, 1);
      contextMenuItems[CM_ASK_ME].label = bundle.getFormattedString("pmAsk", panelName, 1);
      contextMenuItems[CM_REMOVE].label = bundle.getString("pmDelete");
    // }
    // this._previousCategory = category;
    var i, rowCount = this._view.rowCount;

    if (!rowCount) {
      for (i = 0; i < contextMenuItems.length; i++)
        contextMenuItems[i].setAttribute("disabled", "true");
    }
    else {
      var selectedRows = gTreeUtils._getTreeSelections(this._view).length;

      if (selectedRows > 1) {
        contextMenuItems[CM_SELECT_ALL].setAttribute("disabled", "true");
        contextMenuItems[CM_SELECT_NONE].removeAttribute("disabled");

        // Disable the Block, Accept and Accept Site menu items
        for (i = CM_SEPARATOR_1; i < CM_SEPARATOR_2; i++)
          contextMenuItems[i].setAttribute("disabled", "true");
      }
      else { // NO_ROWS_SELECTED || SINGLE_ROW_SELECTED
        if (rowCount > 1) 
          contextMenuItems[CM_SELECT_ALL].removeAttribute("disabled");
        contextMenuItems[CM_SELECT_NONE].setAttribute("disabled", "true");

        if (selectedRows == 0) {
          // Disable the Block, Accept and Accept Site menu items
          for (i = CM_SEPARATOR_1; i < CM_SEPARATOR_2; i++)
            contextMenuItems[i].setAttribute("disabled", "true");

          contextMenuItems[CM_REMOVE].setAttribute("disabled", "true");
        }
        else  {
          // Enable some of menu items, based on the permission for the currentIndex
          var capability = this._permissions[this._tree.currentIndex].permission;
          contextMenuItems[CM_BLOCK].setAttribute("disabled", (capability == this._pm.DENY_ACTION) ? "true" : "false");
          contextMenuItems[CM_ACCEPT].setAttribute("disabled", (capability == this._pm.ALLOW_ACTION) ? "true" : "false");
          contextMenuItems[CM_ACCEPT_SITE].setAttribute("disabled", (capability == 8) ? "true" : "false");
          contextMenuItems[CM_SESSION_COOKIE].setAttribute("disabled", (capability == 8) ? "true" : "false");
          contextMenuItems[CM_REMOVE].removeAttribute("disabled");
          // Keep this array in sync with the context menu items and permissions!
          var permissionMenuIndex = [ 0, 0, 0, 2, 1, 0, 8, 0, 3, 4, 0, 0, 0, 0, 0 ];
          // locate menu item that should display the radio dot 
          for (i = 3; i < 10; i ++) {
            if (permissionMenuIndex[i] == 0) // Skip unwanted menu items
              continue;
            else {
              if (permissionMenuIndex[i] == capability) {
                contextMenuItems[i].setAttribute("checked", "true");
              }
              else 
                contextMenuItems[i].removeAttribute("checked");
            }
          }
        }
      }
    }
    contextMenuItems[CM_ACCEPT_SITE].setAttribute("hidden", "true"); // hidden for now!

    if (category == "popup") {
      contextMenuItems[CM_REDIRECT].removeAttribute("hidden");
      contextMenuItems[CM_SEPARATOR_2].removeAttribute("hidden");
      // Enable MultiZilla's 'New Window Redirector' menu items based on pref setting
      var redirectorEnabled = this._pref.getBoolPref("multizilla.window-open.redirector");
      contextMenuItems[CM_REDIRECT].setAttribute("disabled", (!redirectorEnabled || capability == 3) ? "true" : "false");
      contextMenuItems[CM_ASK_ME].setAttribute("disabled", (!redirectorEnabled || capability == 4) ? "true" : "false");
    }
    else {
      contextMenuItems[CM_REDIRECT].setAttribute("hidden", "true");
      contextMenuItems[CM_SEPARATOR_2].setAttribute("hidden", "true");
    }
    if (category == "cookie") {
      contextMenuItems[CM_SESSION_COOKIE].removeAttribute("hidden");
    }
    else {
      contextMenuItems[CM_SESSION_COOKIE].setAttribute("hidden", "true");
    }
    contextMenuItems[CM_ASK_ME].hidden = (category == "cookie" || category == "install");
  },

  /* contextMenuTimer: function(aEvent)
  {
    if (aEvent.originalTarget.localName == "menupopup") {
      if (aEvent.type == "mouseover" && this._contextMenuTimer)
        window.clearTimeout(this._contextMenuTimer); 
      else if (aEvent.type == "mouseout") {
        if (aEvent.originalTarget.localName == "menupopup") {
          var popupMenu = document.getElementById("permissionsContextMenu");
          this._contextMenuTimer = window.setTimeout(function _inner(aPopupMenu){aPopupMenu.hidePopup();}, 2000, popupMenu);
        }
      }
    }
  }, */

  onHostInput: function(aTextbox)
  {
    this._addButton.disabled = (aTextbox.value == "");
  },

  columnSort: function(aColumnID, aUpdateSelectionFlag, aStartupFlag)
  {
    var sortColumn = document.getElementById(aColumnID);

    if (!sortColumn)
      return;

    var sortDirection = sortColumn.getAttribute("sortDirection");
    aColumnID = aColumnID.match(/DomainColumn/) ? "domain" : "capability";

    if (aStartupFlag) {
      var treeColumn = sortColumn.parentNode.firstChild;

      while (treeColumn) {
        if (treeColumn.localName == "treecol" && treeColumn.hasAttribute("sortActive")
                                              && treeColumn.getAttribute("sortActive") == "true") {
          aColumnID = treeColumn.id;
          sortColumn = treeColumn;
          sortDirection = sortColumn.getAttribute("sortDirection");
          this._lastSortAscending = (sortDirection != "ascending");
          break;
        }
        treeColumn = treeColumn.nextSibling;
      }
      aColumnID = aColumnID.match(/DomainColumn/) ? "domain" : "capability";
    }
    this._lastSortColumn = aColumnID;
    this._lastSortAscending = gTreeUtils.sort(this._tree, this._view,
                                              this._permissions, aColumnID, 
                                              this._lastSortColumn,
                                              this._lastSortAscending);

    // set attribute 'sortActive' and 'sortDirection' on the index column
    if (!aStartupFlag) {
      var direction = this._lastSortAscending ? "ascending" : "descending";
      sortColumn.setAttribute("sortActive", "true");
      sortColumn.setAttribute("sortDirection", direction);
    }
    // remove 'sortActive' and 'sortDirection' from the rest of the columns
    var currentCol = sortColumn.parentNode.firstChild;

    while (currentCol) {
      if (currentCol != sortColumn && currentCol.localName == "treecol") {
        currentCol.removeAttribute("sortDirection");
        currentCol.removeAttribute("sortActive");
      }
      currentCol = currentCol.nextSibling;
    }
  },

  addPermission: function(aCapability)
  {
    var tree = this._tree;

    if (aCapability) {
      this.addHostPermission(this._permissions[tree.currentIndex].host, aCapability);
    }
    else { // Add button and ENTER in textfield
      var prefValue = -1;
      var url = this._addTextbox.value;
      var capability = this._pm.DENY_ACTION;

      switch(this._category) {
        case "cookie":
            prefValue = this._pref.getIntPref("network.cookie.cookieBehavior");
            capability = (prefValue == this._pm.ALLOW_ACTION) ? this._pm.ALLOW_ACTION
                                                              : this._pm.DENY_ACTION;
            break;
        case "popup":
            prefValue = this._pref.getBoolPref("dom.disable_open_during_load");
            capability = (prefValue == this._pm.ALLOW_ACTION) ? this._pm.ALLOW_ACTION
                                                              : this._pm.DENY_ACTION;
            break;
        case "install":
            capability = this._pm.ALLOW_ACTION;
            break;
        default:
            var prefString = "multizilla.content-blocker.behavior." + this._category;
            prefValue = this._pref.getIntPref(prefString);
            capability = (prefValue == 4) ? this._pm.ALLOW_ACTION
                                          : this._pm.DENY_ACTION;
      }
      if (this._category == "cookie") { // Check 'lifetimePolicy' for Cookies
        var lifetimePolicy;

        try { // Only available in mozilla build 20040309 and up, and will be removed!
          lifetimePolicy = this._pref.getIntPref("network.cookie.lifetimePolicy");
        } catch(ex) {
        }
        capability = (lifetimePolicy == 2) ? this._cm.ACCESS_SESSION : capability;
      }
      else if (this._category != "popup") { // Skipped for Popups
        var uri = Cc['@mozilla.org/network/standard-url;1'].createInstance(Ci.nsIURI);
        uri.spec = url;
        capability = this.isFiltered(uri, this._category) ? this._pm.ALLOW_ACTION
                                                          : capability; // this._pm.DENY_ACTION;
      }
      this.addHostPermission(url, capability);
      var entry = this.isNewHost(url);
      tree.currentIndex = (entry == -1) ? entry : tree.currentIndex;
      gTreeUtils.doSelect('none', tree);
      tree.view.selection.select(tree.currentIndex);
      tree.treeBoxObject.ensureRowIsVisible(tree.currentIndex);
      // Clear entry field and disable Add Button
      this._lastHost = "";
      this._addTextbox.value = "";
      this.updateLastHost();
      tree.focus();
    }
    if (tree.currentIndex > -1)
      tree.treeBoxObject.ensureRowIsVisible(tree.currentIndex);

    this.updateActionButtons();
  },

  addHostPermission: function(aHost, aCapability)
  {
    var category = this._category;

    if (aCapability == -1) { // Toggle permission (true = 1 / false = 0)
      var capability = this._pm.testPermission(URI, category);
      var newCapability = (capability == this._pm.ALLOW_ACTION) ? this._pm.DENY_ACTION
                                                                : this._pm.ALLOW_ACTION;
      capability = newCapability;
    }
    else
      capability = aCapability;

    var uri = this.getHostURI(aHost);
    dump("\nuri       : " + uri.spec +
         "\ncategory  : " + category +
         "\ncapability: " + capability);

    this._pm.add(uri, category, capability);
  },

  deletePermission: function()
  {
    if (!gManagerWindow.getConfirmation("pmConfirmRemovalTitle", "pmConfirmRemovalText", null))
      return;

    var deletedPermissions = [];

    gTreeUtils.deleteSelectedItems(this._tree, this._view, this._permissions, deletedPermissions);

    /* if (deletedPermissions.length == this._permissions.length) {
      this._pm.removeAll();
      this._permissions = [];
    }
    else { */
      for (var i = 0; i < deletedPermissions.length; i++) {
        var p = deletedPermissions[i];
        this._pm.remove(p.host, p.type);
      }
    // }
    deletedPermissions = [];
  },

  toggleState: function(aEvent)
  {
    var row, eType = aEvent.originalTarget.localName;
    dump("\neType: " + eType);
    /* if (eType != "treechildren" && (eType == "treechildren" && aEvent.button != 0) ||
        eType != "tree" && (eType == "tree" && aEvent.keyCode != 32)) */

    if (eType != "tree" && eType != "treechildren" ||
        eType == "tree" && aEvent.keyCode != 32 ||
        eType == "treechildren" && aEvent.button != 0)
      return;

    if (eType == "treechildren") {
      var X = aEvent.pageX;
      var Y = aEvent.pageY;
      row = this._tree.treeBoxObject.getRowAt(X, Y);
    }
    else if (eType == "tree")
      row = this._tree.currentIndex;

    dump("\nrow: " + row);
    var host = this._permissions[row].host;
    var uri = this.getHostURI(host);

    if (uri) {
      var category = this._category;
      var capability = this._pm.testPermission(uri, category);
      var newCapability = (capability == this._pm.ALLOW_ACTION) ? this._pm.DENY_ACTION
                                                                : this._pm.ALLOW_ACTION;
      this._pm.add(uri, category, newCapability);
    }
  },

  isFiltered: function(aURI, aType)
  {
    var patterns = new Array();
    var type = (aType) ? aType : this._category;
    var url = aURI.spec.match(/^www./i) ? aURI.spec : "." + aURI.spec;

    try {
      var pattern = pref.getComplexValue("multizilla.content-blocker.pattern.for." + type, Ci.nsISupportsString);
      patterns = pattern.data.replace(/\s/g, '').replace(/\./g, '\.+').replace(/\*/g, '.*');
      patterns = patterns.split(',');
      patterns = patterns.sort();
    } catch(ex) {
      return false;
    }
    if (patterns.length > 0) {
      for (var index = 0; index < patterns.length; index++) {
        var regexp = new RegExp();

        if (url.match(regexp.compile(patterns[index]),'i'))
          return true;
      }
    }
    return false;
  },

  isNewHost: function(aHost)
  {
    aHost = aHost.replace(/file:/, 'scheme:file');
    var count = this._permissions.length;

    for (var i = 0; i < count; i++) {
      if (this._permissions[i].host == aHost)
        return i;
    }
    return -1;
  },
  
  updateLastHost: function()
  {
    var tree = this._tree;
    var view = this._view;

    if (view.rowCount > 0 && tree.currentIndex > -1) {
      if (tree.currentIndex <= view.rowCount) {
        var selectedRows = gTreeUtils._getTreeSelections(view);

        if (selectedRows.length == 1)
          this._lastHost = this._permissions[tree.currentIndex].domain || null;
      }
    }
    var currentHost = this._addTextbox.value;

    if (currentHost != "" && currentHost != this._lastHost)
      this._addTextbox.value = "";
    this._addButton.disabled = (currentHost == "");
  },

  getHostURI: function(aHost)
  {
    var isFileScheme = aHost.match(/(scheme:file|file:)/i);
    aHost = aHost.replace(/^\s*([-\w]*:\/+)?/, ""); // trim any leading space and scheme
    var url = isFileScheme ? 'file:' : 'http://' + aHost;

    return this._nsIIOService.newURI(url, null, null);
  },

  initTreeTooltip: function(aEvent)
  {
    var node = document.tooltipNode; // <tree>, <treecols>, <treecol>, <splitter>, <treechildren>, <menupoup>, <menuitem>
    var nodeName = node.localName; // 'tree', 'treecols', 'treecol', 'splitter', 'treechildren', 'menupoup', 'menuitem'

    if (nodeName == "tree" || nodeName.match("menu")) { // for <menupopup> and <menuitem> nodes
      aEvent.preventDefault();
      return false;
    }
    var cookieList = (this._category == "cookie" && nodeName == "treechildren" 
                     && node.parentNode.id == "CookiesList");

    var tooltipNode = aEvent.target; // <tooltip>
    tooltipNode.firstChild.hidden = (!node.hasAttribute("sort") || nodeName != "treecol");
    tooltipNode.childNodes[1].hidden = (nodeName != "treecols");
    tooltipNode.childNodes[2].hidden = (nodeName != "splitter");
    tooltipNode.childNodes[3].hidden = (cookieList || nodeName != "treechildren");
    tooltipNode.lastChild.hidden = (nodeName != "treechildren");
    return true;
  },

  handlePermissionKeyPress: function(aEvent)
  {
    if (aEvent.keyCode == 32) // space
      this.toggleState(aEvent);
    else if (aEvent.keyCode == 45) { // insert
      this._tree.view.selection.clearSelection();
      this._addTextbox.focus();
    }
    else if (aEvent.keyCode == 46) // delete
      this.deletePermission();
  },

  /* Import View */
  showMainView: function()
  {
    document.title = this._documentTitle;
    this._mainDeck.selectedIndex = 0;
    document.getElementById('importStatsLabel').hidden = true;
  },

  showImportView: function()
  {
    document.title = "Permission Manager : Import View - MultiZilla"
    this._mainDeck.selectedIndex = 1;

    if (!this._hasImportOverlay)
      this._loadImportOverlay();
    else {
      gImportPanel.init();
    }
  },

  _loadImportOverlay: function()
  {
    function OverlayLoadObserver() {
    }
    OverlayLoadObserver.prototype = {
      _outer: this,

      observe: function (aSubject, aTopic, aData) {
        this._outer._hasImportOverlay = true;
        this._outer.showImportView();
      }
    };
    var oberver = new OverlayLoadObserver();
    window.__mozilla__loadOverlay(this._importOverlayURL, oberver);
  },

  importFilters: function(aTitle, aMode)
  {
    if(!this._isInitialised)
      this.init();

    var status = this.selectFile(aTitle, aMode);

    if (status == 1) // Cancel
      return;

    if (this._cbFileName.match(".rdf") == null)
      this._cbFileName += ".rdf";

    this._cbDatasource = mzGetNewOrCurrentDSByFilename(this._cbFileName, true, null, true);
    this._dsStats = this.getDataSourceStatistics();

    if (this._dsStats == null) {
      this._promptService.alert(window,
                                this._bundle.getString("cbImportFileErrorTitle"),
                                this._bundle.getString("cbImportFileErrorText")
                               );
      return;
    }
    this.showImportView();
  },

  exportFilters: function(aTitle, aMode)
  {
    var state = this.selectFile(aTitle, aMode);

    if (state == 1) // Cancel
      return;
    else if (state == 2) { // Ok, overwrite existing file, ask for confirmation
      if (!gManagerWindow.getConfirmation("cbExportManager", "cbExportConfirm"))
        return;
    }
    if (this._cbFileName.match(".rdf") == null)
      this._cbFileName += ".rdf";

    this._cbDatasource = mzGetNewOrCurrentDSByFilename(this._cbFileName, true, null, true);
    var saved = 0;
    // Scan through the array for valid type numbers (skips cookies/popups)
    for (var i = 0; i < this._patternTypeNumbers.length; i++) {
      var index = this._patternTypeNumbers[i];
      var resourceID = "multizilla:content-blocker:" + this._permissionTypes[index];
      var patterns = this.getPatternPrefFor(this._permissionTypes[index]);

      if (patterns.length >= 1)
        saved += this.writePatternsFor(this._permissionTypes[index], resourceID, patterns, state);
    }
    title = this._bundle.getString("cbExportManager");
    var text = this._bundle.getFormattedString("pmSavedFilterNotification", [saved], 1);
    this._promptService.alert(window, title, text);
    this._cbDatasource = null;
  },

  selectFile: function(aTitle, aMode)
  {
    var nsIFilePicker = Ci.nsIFilePicker;
    var filePicker = Cc["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

    aMode = (aMode == "open") ? nsIFilePicker.modeOpen : nsIFilePicker.modeSave;

    filePicker.init(window, aTitle, aMode);
    filePicker.appendFilter("RDF", "*.rdf");
    filePicker.defaultString = "content-blocker.rdf";
    window.filePickerParent = window;
    var filePickerState = filePicker.show();

    if (filePickerState != nsIFilePicker.returnCancel) {
      if (filePicker.fileURL.spec && filePicker.fileURL.spec.length > 0)
        this._cbFileName = filePicker.fileURL.spec;
    }
    return filePickerState;
  },

  writePatternsFor: function(aType, aResourceID, patterns, aOverWriteFlag)
  {
    var index = 0
    var patternCount = patterns.length;
    // alert(type + "\n" + aResourceID + "\n" + patternCount + "\n" + aOverWriteFlag);
    if (aOverWriteFlag == 2)
      this.removeEntriesFor(aType);
		
    try {
      var entries = mzConstructRDFContainer(this._cbDatasource, 'seq', aResourceID, false);

      for (; index < patternCount; index++) {
        var property = RDF.GetLiteral(patterns[index]);
        entries.InsertElementAt(property, (index + 1), true);
      }
    } catch(ex) {
      // continue
    }
    this._cbDatasource.QueryInterface(Ci.nsIRDFRemoteDataSource).Flush();
    return(index);
  },

  getPatternPrefFor: function(aType)
  {
    var patterns = new Array();

    try {
      var prefIdentifier = this._patternPrefPrefix + aType;
      var prefValue = this._pref.getComplexValue(prefIdentifier, Ci.nsISupportsString);
      patterns = prefValue.data.replace(/\s/g, '').split(',');
      patterns = patterns.sort();
    } catch(ex) {
      dump("\nERROR: Initializing patterns for: " + aType + " Failed... \nRecovering...");
      var str = Cc["@mozilla.org/supports-string;1"].createInstance(Ci.nsISupportsString);
      str.data = "";
      this._pref.setComplexValue(prefIdentifier, Ci.nsISupportsString, str);
    }
    return patterns;
  },
 
  getDataSourceStatistics: function()
  {
    var failures = 0;
    var dsStatistics = new Array();

    for (var i = 0; i < this._patternTypeNumbers.length; i++) {
      var index = this._patternTypeNumbers[i];
      var resourceID = "multizilla:content-blocker:" + this._permissionTypes[index];
      var resource = RDF.GetResource(resourceID);
      var seqStats = new Object();

      seqStats.typeID = this._permissionTypes[index];
      seqStats.resourceID = resourceID;

      if (mzRDFCUtils.IsSeq(this._cbDatasource, resource))
        seqStats.entries = this.cbEntries(resourceID).GetCount();
      else {
        seqStats.entries = 0;
        failures++;
      }
      dsStatistics.push(seqStats);
    }
    return (failures == 7) ? null : dsStatistics;
  },

  cbEntries: function(aResourceID)
  {
    var entries = mzRDFCUtils.MakeSeq(this._cbDatasource, RDF.GetResource(aResourceID));

    if (!entries)
      return null;
    if (!entries.GetElements())
      return null;
    return entries;
  },
 
  removeEntriesFor: function(aPermissionType)
  {
    var resourceIDs = new Array();
    resourceIDs.push("urn:" + aPermissionType);
    resourceIDs.push("multizilla:content-blocker:" + aPermissionType);

    for (var i = 0; i < resourceIDs.length; i++) {
      var resource = RDF.GetResource(resourceIDs[i]);
      // alert(resourceIDs[i]);
      if (mzRDFCUtils.IsEmpty(this._cbDatasource, resource))
        continue; // Skip empty Seq's
      else if (mzRDFCUtils.IsSeq(this._cbDatasource, resource)) {
        var index = this.cbEntries(resourceIDs[i]).GetCount();

        for (index; index > 0; index--)
          this.cbEntries(resourceIDs[i]).RemoveElementAt(index, true);
      }
    }
    this._cbDatasource.QueryInterface(Ci.nsIRDFRemoteDataSource).Flush();
  },

  onUnload: function(aEvent) 
  {
    var os = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService);

    if (os.enumerateObservers("perm-changed").hasMoreElements())
      os.removeObserver(gPermissionManager, "perm-changed");

    window.removeEventListener("unload", gPermissionManager.onUnload, false);
  }

  /* onError: function(aEvent) 
  {
    dump("\nonError");
  },
  onAbort: function(aEvent) 
  {
    dump("\nonAbort");
  } */
};


var gTreeUtils =
{
  _observerService: Cc["@mozilla.org/observer-service;1"]
                     .getService(Ci.nsIObserverService),

  _getTreeSelections: function(aView)
  {
    var selections = [];
    var select = aView.selection;

    if (select) {
      var count = select.getRangeCount();
      var min = new Object();
      var max = new Object();

      for (var i = 0; i< count; i++) {
        select.getRangeAt(i, min, max);

        for (var k = min.value; k <= max.value; k++) {
          if (k != -1)
            selections[selections.length] = k;
        }
      }
    }
    return selections;
  },

  doSelect: function(aSelection, aTree)
  {
    if (aTree == undefined)
      aTree = gPermissionManager._tree;

    switch (aSelection) {
      case "none": // Called from the context menu, or Ctrl+Z ?
           aTree.treeBoxObject.view.selection.clearSelection();
           aTree.treeBoxObject.view.selection.select(aTree.currentIndex);
           break;
      case "all": // Called from the context menu, or Ctrl+A ?
      default   :
           aTree.treeBoxObject.view.selection.selectAll();
           break;
    }
  },

  sort: function(aTree, aView, aDataSet, aColumn, aLastSortColumn, aLastSortAscending) 
  {
    /* dump("\naColumn           : " + aColumn +
         "\naLastSortColumn   : " + aLastSortColumn +
         "\naLastSortAscending: " + aLastSortAscending); */
    // this._observerService.notifyObservers(gPermissionManager, "perm-changed", "sort");
    var state = gPermissionManager.setFoggyViewTo(4);
    var ascending = (aColumn == aLastSortColumn) ? !aLastSortAscending : true;
    aDataSet.sort(function(a,b){return a[aColumn].toLowerCase().localeCompare(b[aColumn].toLowerCase());});

    if (!ascending)
      aDataSet.reverse();
    
    aTree.view.selection.select(-1);
    aTree.view.selection.select(0);
    aTree.treeBoxObject.invalidate();
    aTree.treeBoxObject.ensureRowIsVisible(0);
    
    // this._observerService.notifyObservers(gPermissionManager, "perm-changed", "sorted");
    state = gPermissionManager.setFoggyViewTo(0);
    return ascending;
  },

  deleteAll: function(aTree, aView, aItems, aDeletedItems)
  {
    for (var i = 0; i < aItems.length; ++i)
      aDeletedItems.push(aItems[i]);

    aItems.splice(0);
    var oldCount = aView.rowCount;
    aView._rowCount = 0;
    aTree.treeBoxObject.rowCountChanged(0, -oldCount);
  },

  deleteSelectedItems: function (aTree, aView, aItems, aDeletedItems)
  {
    var selection = aTree.view.selection;
    selection.selectEventsSuppressed = true;
    
    var rangeCount = selection.getRangeCount();

    for (var i = 0; i < rangeCount; ++i)
    {
      var min = {};
      var max = {};
      selection.getRangeAt(i, min, max);

      for (var j = min.value; j <= max.value; ++j) {
        aDeletedItems.push(aItems[j]);
        aItems[j] = null;
      }
    }
    var nextSelection = 0;

    for (i = 0; i < aItems.length; ++i)
    {
      if (!aItems[i])
      {
        var j = i;

        while (j < aItems.length && !aItems[j])
          ++j;

        aItems.splice(i, j - i);
        nextSelection = (j < aView.rowCount) ? (j - 1) : (j - 2);
        aView._rowCount -= (j - i);
        aTree.treeBoxObject.rowCountChanged(i, (i - j));
      }
    }
    if (aItems.length) {
      selection.select(nextSelection);
      aTree.treeBoxObject.ensureRowIsVisible(nextSelection);
      aTree.focus();
    }
    selection.selectEventsSuppressed = false;
  }
};

var sqlite =
{
  _getFile: function(aFileName)
  {
    var file = Cc["@mozilla.org/file/directory_service;1"]
                .getService(Ci.nsIProperties).get("ProfD", Ci.nsIFile);
    file.append(aFileName);
    return file;
  },
  
  _getConnection: function(aFile)
  {
    return Cc["@mozilla.org/storage/service;1"]
            .getService(Ci.mozIStorageService).openDatabase(aFile);
  },

  morkToSQLite: function()
  {
    var file = this._getFile("hostperm.sqlite");
    var connection = this._getConnection(file);

    if (!connection.tableExists("moz_hosts")) {
      connection.createTable("moz_hosts", "id INTEGER PRIMARY KEY, host TEXT, type TEXT, permission INTEGER");

      try {
        connection.beginTransaction();

        var id = 1;
        var statement = connection.createStatement("INSERT INTO moz_hosts " +
                                                  "(id, host, type, permission) " +
                                                   "VALUES (?1, ?2, ?3, ?4)");

        for each (var permissions in gPermissionManager._pmCache) {
          for each (var permObj in permissions) {
            statement.bindInt64Parameter(0, id++);
            statement.bindUTF8StringParameter(1, permObj.host);
            statement.bindUTF8StringParameter(2, permObj.type);
            statement.bindInt32Parameter(3, permObj.permission);
            statement.execute();
          }
        }
        connection.commitTransaction();
      } finally {
        if (Ci.mozIStorageService.number == "{e42f0655-cdc3-47c6-824a-cdb88c731cb9}")
          connection.close();
        else {
          statement.reset();
          // statement.finalize();
        }
      }
    }
  },

  filterPrefsToSQLite: function()
  {
    var file = this._getFile("filters.sqlite");
    var connection = this._getConnection(file);
    var categories = ["image", "object", "script", "document", "frame"];

    for each (var category in categories) {
      // dump("\ncategory: " + category);
      if (!connection.tableExists(category)) {
        connection.createTable(category, "id INTEGER PRIMARY KEY, filter TEXT, host TEXT, timestamp INTEGER, hit INTEGER, description TEXT");

        try {
          connection.beginTransaction();

          var id = 1;  
          var now = new Date().getTime();
          var statement = connection.createStatement("INSERT INTO " + category +
                                                     " (id, filter, host, timestamp, hit, description) " +
                                                     "VALUES (?1, ?2, ?3, ?4, ?5, ?6)");

          var prefString = gPermissionManager._patternPrefPrefix + category;
          var filters = gPermissionManager._pref.getComplexValue(prefString, Ci.nsISupportsString);
          filters = filters.data.replace(/\s/g, "").replace(/\*/g, ".*");
          filters = filters.split(',');
          filters = filters.sort();

          for each (var filter in filters) {
            statement.bindInt64Parameter(0, id++);
            statement.bindUTF8StringParameter(1, filter);
            statement.bindUTF8StringParameter(2, "unknown");
            statement.bindUTF8StringParameter(3, now);
            statement.bindUTF8StringParameter(4, 0);
            statement.bindUTF8StringParameter(5, "Automatic conversion");
            statement.execute();
          }
          connection.commitTransaction();
        } finally {
          if (Ci.mozIStorageService.number == "{e42f0655-cdc3-47c6-824a-cdb88c731cb9}")
            connection.close();
          else {
            statement.reset();
            // statement.finalize();
          }
        }
      }
    }
  }
};

window.addEventListener("unload", gPermissionManager.onUnload, false);
/* window.addEventListener("abort", gPermissionManager.onAbort, false);
window.addEventListener("error", gPermissionManager.onError, false); */