using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CoreSync;

namespace SmartSync
{
    public partial class frmConflictSolver : Form
    {
        public frmConflictSolver()
        {
            InitializeComponent();
        }
        public static String showMe(Contact local, Contact remote)
        {
            frmConflictSolver frm = new frmConflictSolver();
            frm.setup(local, remote);
            DialogResult result=frm.ShowDialog();
            switch (result)
            {
                case DialogResult.OK:
                    return Actions.UPDATE;
                case DialogResult.Cancel:
                    return Actions.UPDATEPPC;
                case DialogResult.Ignore:
                    return Actions.NOTHING;
                default:
                    return Actions.QUESTION;
            }
        }

        public void setup(Contact local, Contact remote)
        {
            lblLocal_email1.Text = local.email;
            lblLocal_FullName.Text = local.fullName;
            lblLocal_MobileTel.Text = local.mobileTel;
            lblPPC_email1.Text = remote.email;
            lblPPC_FullName.Text = remote.fullName;
            lblPPC_MobileTel.Text = remote.mobileTel;
        }

        private void btnCopyToLocal_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void btnCopyToRemote_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void btnIgnore_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Ignore;
            this.Close();
        }
    }

}