/***********************************************************************
*                           XML Schema Reader
*                             (XMLSchema.js)
*                              version 0.40
************************************************************************
*
* Description:
* ============
* This script reads an XML Schema file and keeps it as a DOM. 
* This script provides a specific programatic interface to the
* schema through the DOM.
*
* Contributors
* ============
* Franklin de Graaf (original author)
*
* API
* ===
* getElementTypes()
* getElementAttributes(ElementType)
* getAttributeValues(ElementType, Attribute)
* 
*
* ISSUES (bugs/problems)
* ======
*     
* NOTES
* =====
*
* CHANGE LOG (for Version x.xx) 
* ==========
*
* Resolved Issues
* ---------------
*
* Enhancements
* ------------
* TODO
* ====
* minor
* -----
* major
* -----
***********************************************************************/
if(TRACE_LOADING){ alert("Start loading: XMLSchema.js"); }



//======================================================================
//  XMLSchema
//======================================================================

function XMLSchema() {
	trace("XMLSchema::XMLSchema", "BEGIN" );

//------------------------
// XMLSchema::Constants
//------------------------

const VERSION = "0.10";

//------------------------
// XMLSchema::Variables
//------------------------

var schemaDOM; // The DOM (node tree) representation of the XUL Schema
var XPathResult = null;


	trace("XMLSchema::XMLSchema", "END" );
}


//----------------------------------------------------------------------
// XMLSchema::openFile()
//----------------------------------------------------------------------
XMLSchema.prototype.openFile = function(aSchemaFile) {

      trace( "XMLSchema::openFile", "BEGIN");
	//if (browserMode) { setSecurity(); }
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
		netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
		trace( "XMLSchema::openFile", "INFO", "Set security for XMLSchema. ");
	} catch (e) {
		trace( "XMLSchema::openFile", "ERROR", "Could NOT set security for XMLSchema. " + e);
	}

	if(aSchemaFile) {

		// Read XML Schema file (XML text)
	      trace( "XMLSchema::openFile", "MSG", "opening file: " + aSchemaFile);
		var file; 
		var xmlString;
		try {
			file = new File(aSchemaFile); 
			trace( "XMLSchema::openFile", "MSG", "created file (handle)");
			file.open("r");
			trace( "XMLSchema::openFile", "MSG", "opened file for read.");
			xmlString = file.read();
			trace( "XMLSchema::openFile", "MSG", "read: " + xmlString);
			file.close();
			trace( "XMLSchema::openFile", "MSG", "closed file.");
		} catch (e) {
			alert("XMLSchema::openFile() Create, Open, Read, or Close ERROR - " + e);
		}

		// Parse XML Schema string
		if (xmlString) {
     			var aParser = new DOMParser();
			trace( "XMLSchema::openFile", "MSG", "Created DOMParser");
			try {
				this.schemaDOM = aParser.parseFromString( xmlString , "text/xml" ) ;
				//this.schemaDOM = aParser.parseFromString( xmlString , "application-x/xml" ) ;
				trace( "XMLSchema::openFile", "MSG", "Parsed the XML Schema string.");
			} catch (e) {
				alert(e);
			}
			
/*
			//displayProperties(listProperties(this.schemaDOM)); //dialog window to display properties
			var sample = this.schemaDOM.getElementById('window1'); 
			if (!sample) {
				alert("XMLSchema: element with id='window1' is missing. Parser may have failed.");  //<<<<<<<<<<<<<<<<we get a null here
			}
			var nodelist = this.schemaDOM.getElementsByTagName("element");
			if(nodelist) {
				var elementNameList = "ElementNameList:\n";
				for (var i=0;i<nodelist.length;i++) {
					elementNameList += nodelist[i].getAttribute("name") + "\n";
				}
				alert(elementNameList);
			} else {
				alert("XMLSchema: We have an empty nodelist");
			}
*/
		}

	}
	trace( "XMLSchema::openFile", "END");
}


//----------------------------------------------------------------------
// XMLSchema::display()
//----------------------------------------------------------------------
XMLSchema.prototype.display = function() {
	displayProperties(listProperties(this.schemaDOM)); //dialog window to display properties
	popupWindow = window.openDialog('about:', '_blank', 'chrome,all,dialog');
	//var re = /\n/g;
	//str = str.replace(re,"</br>"); // replace linefeed with html break element
	popupWindow.title = "XML Schema DOM (use DOM Inspector to view)";
	//popupWindow.document = this.schemaDOM;

}

//----------------------------------------------------------------------
// XMLSchema::displayXPathResults()
//----------------------------------------------------------------------
XMLSchema.prototype.displayXPathResults = function(aXPathExpression) {
	try {
		// Documentation for XPath comes from "http://www.w3.org/TR/2002/WD-DOM-Level-3-XPath-20020328/"
		// >>> evaluate(expression, contextNode, resolver, type, result);
		this.XPathResult = this.schemaDOM.evaluate(aXPathExpression, this.schemaDOM, null, null, this.XPathResult);
		var label, result = "", node;

/*
		for (var i in this.XPathResult) {
			var prop;
			if (this.XPathResult[i]) { prop = this.XPathResult[i]; } else { prop = "null"; }
			alert("XPathResult[" + i + "]=" + prop);
		}
*/

		switch (this.XPathResult.resultType) {
		case 1: label = "number"; result = this.XPathResult.numberValue; break;
		case 2: label = "string"; result = this.XPathResult.stringValue; break;
		case 3: label = "boolean"; result = this.XPathResult.booleanValue; break;
		case 4:
			label = "unordered list";
			//result = "nodecount=" + this.XPathResult.length;
			//while (node = this.XPathResult.iterateNext()) {
				node = this.XPathResult.iterateNext();
				displayProperties(listProperties(node));
			//}
			break;
		case 5:
			label = "ordered list";
			for (var i in this.XPathResult) {
				result += i + ":" + this.XPathResult[i];
			}
			break;
		default: label ="other"; result = "undetermined"; break;
		}
		alert("XPath: " + aXPathExpression
		+	"\n  ResultType: " + label
		+     "\n  ResultValue: " + result
		);
	} catch (e) {
		alert("XMLSchema: evaluate ERROR: " + e);
	}
}

//----------------------------------------------------------------------
// XMLSchema::getElementTypes()
//----------------------------------------------------------------------
XMLSchema.prototype.getElementTypes = function() {
      trace( "XMLSchema::getElementTypes", "BEGIN");
	try {
			var nodelist = this.schemaDOM.getElementsByTagName("element");
			if(nodelist) {
				var elementNameList = "ElementNameList:\n";
				for (var i=0;i<nodelist.length;i++) {
					elementNameList += nodelist[i].getAttribute("name") + "\n";
				}
				alert(elementNameList);
			} else {
				alert("XMLSchema: We have an empty nodelist");
			}
		//alert("window element tagname: " + this.schemaDOM.getElementById('window1').tagName );
		//   (For some reason it can't find the element with the id='window1')

		// Documentation for XPath comes from "http://www.w3.org/TR/2002/WD-DOM-Level-3-XPath-20020328/"
		// >>> evaluate(expression, contextNode, resolver, type, result);


		this.displayXPathResults("count(/schema)");
		this.displayXPathResults("count(element)");
		this.displayXPathResults("count(element[1])");
		this.displayXPathResults("/schema");
		this.displayXPathResults("namespace(.)");



	} catch (e) {
		alert("XMLSchema::getElementTypes() Exception: " + e);
	}
      trace( "XMLSchema::getElementTypes", "END");
}

//----------------------------------------------------------------------
// XMLSchema::getElementAttributes()
//----------------------------------------------------------------------
XMLSchema.prototype.getElementAttributes = function(aElementType) {
      trace( "XMLSchema::getElementAttributes", "BEGIN");
      trace( "XMLSchema::getElementAttributes", "END");
}

//----------------------------------------------------------------------
// XMLSchema::getAttributeValues()
//----------------------------------------------------------------------
XMLSchema.prototype.getAttributeValues = function(aElementType,aAttribute) {
      trace( "XMLSchema::getAttributeValues", "BEGIN");
      trace( "XMLSchema::getAttributeValues", "END");
}

/***********************************************************************
if(TRACE_LOADING){ alert("Continuing loading: XMLSchema.js"); }
***********************************************************************/
if(TRACE_LOADING){ alert("Finished loading: XMLSchema.js"); }

