/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.filter.insn;

import eu.bibl.banalysis.filter.ConstantFilter;
import eu.bibl.banalysis.filter.OpcodeFilter;
import eu.bibl.banalysis.filter.insn.OpcodeInstructionFilter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;

public class FieldInstructionFilter
extends OpcodeInstructionFilter {
    private ConstantFilter<String> ownerFilter;
    private ConstantFilter<String> nameFilter;
    private ConstantFilter<String> descFilter;

    public FieldInstructionFilter(OpcodeFilter filter, String owner, String name, String desc) {
        super(filter);
        this.ownerFilter = this.createFilter(owner);
        this.nameFilter = this.createFilter(name);
        this.descFilter = this.createFilter(desc);
    }

    public FieldInstructionFilter(int opcode, String owner, String name, String desc) {
        super(new OpcodeFilter(opcode));
        this.ownerFilter = this.createFilter(owner);
        this.nameFilter = this.createFilter(name);
        this.descFilter = this.createFilter(desc);
    }

    private ConstantFilter<String> createFilter(String s) {
        if (s == null) {
            return new ConstantFilter<String>();
        }
        return new ConstantFilter<String>(s);
    }

    @Override
    public boolean accept(AbstractInsnNode t) {
        if (!(t instanceof FieldInsnNode)) {
            return false;
        }
        if (!this.opcodeFilter.accept(t)) {
            return false;
        }
        FieldInsnNode fin = (FieldInsnNode)t;
        if (!this.ownerFilter.accept(fin.owner)) {
            return false;
        }
        if (!this.nameFilter.accept(fin.name)) {
            return false;
        }
        return this.descFilter.accept(fin.desc);
    }
}

