package the.bytecode.club.bytecodeviewer.malwarescanner.impl;

import java.util.regex.Pattern;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.malwarescanner.MalwareCodeScanner;
import the.bytecode.club.bytecodeviewer.malwarescanner.MalwareScan;
import the.bytecode.club.bytecodeviewer.malwarescanner.util.SearchableString;

import static the.bytecode.club.bytecodeviewer.Constants.nl;

/***************************************************************************
 * Bytecode Viewer (BCV) - Java & Android Reverse Engineering Suite        *
 * Copyright (C) 2014 Kalen 'Konloch' Kinloch - http://bytecodeviewer.com  *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

/**
 * Scans strings for common URL patterns:
 *  Any string containing www
 *  Any string containing http://
 *  Any string containing https://
 *  Any string matching an IP pattern
 *
 * @author Konloch
 * @author WaterWolf
 * @since 10/02/2011
 */
public class URLScanner extends MalwareCodeScanner
{
	private static final Pattern ipPattern = Pattern.compile("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b");
	
	@Override
	public void scanFieldString(MalwareScan scan, ClassNode cn, FieldNode field, SearchableString string)
	{
		if (string.searchable.contains("www.")
				|| string.searchable.contains("http://")
				|| string.searchable.contains("https://")
				|| ipPattern.matcher(string.searchable).matches())
			foundLDC(scan, string.original, "at field " + fieldToString(cn, field) + nl);
	}
	
	@Override
	public void scanMethodString(MalwareScan scan, ClassNode cn, MethodNode method, SearchableString string)
	{
		if (string.searchable.contains("www.")
				|| string.searchable.contains("http://")
				|| string.searchable.contains("https://")
				|| ipPattern.matcher(string.searchable).matches())
			foundLDC(scan, string.original, "at method " + methodToString(cn, method) + nl);
	}
	
	@Override
	public void scanMethodInstruction(MalwareScan scan, ClassNode cn, MethodNode method, AbstractInsnNode instruction) { }
}
