#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config
import os
import sys

from sphinx_github_style.utils.linkcode import get_linkcode_resolve

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#

# -- Project information -----------------------------------------------------

project = "transmission-rpc"
copyright = "2018-2023, Trim21 <trim21me@gmail.com>"
author = "Trim21 <trim21me@gmail.com>"

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon",
    "sphinx_copybutton",
    "furo.sphinxext",
    "sphinx.ext.linkcode",
    "sphinx_new_tab_link",
]

napoleon_numpy_docstring = False

# Add any paths that contain templates here, relative to this directory.
templates_path = []

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    "source_edit_link": "https://github.com/trim21/transmission-rpc/blob/master/docs/{filename}",
    # "source_view_link": "https://github.com/trim21/transmission-rpc/blob/master/{filename}",
    "source_repository": "https://github.com/trim21/transmission-rpc/",
    "source_branch": "master",
    "source_directory": "docs/",
}

html_copy_source = False

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []
autodoc_member_order = "bysource"
autodoc_class_signature = "separated"
autodoc_typehints = "signature"

autodoc_default_options = {
    "special-members": "",
    "exclude-members": "__new__",
}

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "transmission-rpc doc"

ref = "master"

if os.environ.get("READTHEDOCS"):
    sys.path.insert(0, os.path.normpath(".."))

    if os.environ["READTHEDOCS_VERSION_TYPE"] == "tag":
        ref = os.environ["READTHEDOCS_GIT_IDENTIFIER"]
    else:
        ref = os.environ["READTHEDOCS_GIT_COMMIT_HASH"]

linkcode_resolve = get_linkcode_resolve(
    "https://github.com/trim21/transmission-rpc/blob/" + ref + "/{filepath}#L{linestart}"
)
