#ifndef _LCT_LOCAL_H
#define _LCT_LOCAL_H

#define _GNU_SOURCE

#include <config.h>

#include <locale.h>


#ifdef HAVE_LOCALE_H
# include <libintl.h>
# define _(String) gettext (String)
# ifdef gettext_noop
#  define N_(String) gettext_noop (String)
# else
#  define N_(String) (String)
# endif
#else
/* rough approximation of the functions */
# define _(String) (String)
# define N_(String) (String)
# define textdomain(Domain)
# define bindtextdomain(Package, Directory)
#endif


#endif /* _LCT_LOCAL_H */
