/*
 *  Copyright (C) 2005 David J. Kessler <dkessler@kopsisengineering.com>
 *
 *  Derived from kbdd by Nils Faerber:
 *  Copyright (C) 2004,2005 Nils Faerber <nils.faerber@kernelconcepts.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>

#include "lua-x/include/lua.h"
#include "lua-x/include/lualib.h"
#include "lua-x/include/lauxlib.h"

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

struct driver_info {
	char identifier[16];
	char full_name[80];
	char version[80];
	int (* driver)(void);
};

typedef struct driver_info driver_info_t;

void send_z_key(unsigned short keycode, unsigned int key_down);
int open_serial(char *port, speed_t  baud);

#if !defined(MAIN)
extern char TTY_PORT[PATH_MAX];
extern char debug;
extern char uindev;
extern lua_State* L;
#endif

