# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250605193635;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97\\d
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441989", "Ross\-on\-Wye",
"44286", "Northern\ Ireland",
"442891", "Bangor\ \(Co\.\ Down\)",
"441491", "Henley\-on\-Thames",
"4412297", "Millom",
"441271", "Barnstaple",
"441360", "Killearn",
"441871", "Castlebay",
"441974", "Llanon",
"441983", "Isle\ of\ Wight",
"441955", "Wick",
"441376", "Braintree",
"441775", "Spalding",
"441754", "Skegness",
"441702", "Southend\-on\-Sea",
"4418902", "Coldstream",
"441257", "Coppull",
"441857", "Sanday",
"4414307", "Market\ Weighton",
"441352", "Mold",
"441304", "Dover",
"4419754", "Alford\ \(Aberdeen\)",
"441406", "Holbeach",
"441604", "Northampton",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441652", "Brigg",
"4418514", "Great\ Bernera",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441797", "Rye",
"441529", "Sleaford",
"441838", "Dalmally",
"441340", "Craigellachie\ \(Aberlour\)",
"441539", "Kendal",
"441474", "Gravesend",
"441455", "Hinckley",
"441483", "Guildford",
"442883", "Northern\ Ireland",
"441676", "Meriden",
"441294", "Ardrossan",
"441880", "Tarbert",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441828", "Coupar\ Angus",
"4416863", "Llanidloes",
"44238", "Southampton",
"4419649", "Hornsea",
"442889", "Fivemiletown",
"441489", "Bishops\ Waltham",
"441228", "Carlisle",
"441592", "Kirkcaldy",
"441912", "Tyneside",
"441280", "Buckingham",
"441461", "Gretna",
"442837", "Armagh",
"441379", "Diss",
"441747", "Shaftesbury",
"441778", "Bourne",
"441986", "Bungay",
"44247", "Coventry",
"441373", "Frome",
"441384", "Dudley",
"4414238", "Harrogate",
"441844", "Thame",
"44114707", "Sheffield",
"4415395", "Grange\-over\-Sands",
"441909", "Worksop",
"441542", "Keith",
"442827", "Ballymoney",
"441427", "Gainsborough",
"441903", "Worthing",
"441244", "Chester",
"441782", "Stoke\-on\-Trent",
"441403", "Horsham",
"441550", "Llandovery",
"441526", "Martin",
"441235", "Abingdon",
"441409", "Holsworthy",
"441140", "Sheffield",
"442841", "Rostrevor",
"441835", "St\ Boswells",
"441767", "Sandy",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441200", "Clitheroe",
"441825", "Uckfield",
"442886", "Cookstown",
"4419646", "Patrington",
"441673", "Market\ Rasen",
"441684", "Malvern",
"441721", "Peebles",
"441264", "Andover",
"441458", "Glastonbury",
"4415075", "Spilsby\ \(Horncastle\)",
"441536", "Kettering",
"441937", "Wetherby",
"441864", "Abington\ \(Crawford\)",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441562", "Kidderminster",
"441225", "Bath",
"441690", "Betws\-y\-Coed",
"44151", "Liverpool",
"441904", "York",
"441952", "Telford",
"441243", "Chichester",
"441306", "Dorking",
"441772", "Preston",
"4412294", "Barrow\-in\-Furness",
"441843", "Thanet",
"4416861", "Newtown\/Llanidloes",
"4416865", "Newtown",
"441440", "Haverhill",
"441141", "Sheffield",
"442840", "Banbridge",
"441249", "Chippenham",
"4414348", "Hexham",
"441730", "Petersfield",
"441788", "Rugby",
"4418909", "Ayton",
"441577", "Kinross",
"441355", "East\ Kilbride",
"441720", "Isles\ of\ Scilly",
"441383", "Dunfermline",
"441756", "Skipton",
"4414304", "North\ Cave",
"4414373", "Clynderwen\ \(Clunderwen\)",
"4416860", "Newtown\/Llanidloes",
"4418478", "Thurso",
"441548", "Kingsbridge",
"441389", "Dumbarton",
"441691", "Oswestry",
"4419757", "Strathdon",
"441689", "Orpington",
"441863", "Ardgay",
"4418517", "Stornoway",
"441460", "Chard",
"441269", "Ammanford",
"4416974", "Raughton\ Head",
"441896", "Galashiels",
"441869", "Bicester",
"441674", "Montrose",
"441683", "Moffat",
"441655", "Maybole",
"441476", "Grantham",
"441296", "Aylesbury",
"441263", "Cromer",
"4419642", "Hornsea",
"441568", "Leominster",
"441915", "Sunderland",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441606", "Northwich",
"441404", "Honiton",
"441452", "Gloucester",
"441708", "Romford",
"441246", "Chesterfield",
"4415073", "Louth",
"441303", "Folkestone",
"441309", "Forres",
"441341", "Barmouth",
"441358", "Ellon",
"441984", "Watchet\ \(Williton\)",
"441386", "Evesham",
"441785", "Stafford",
"441753", "Slough",
"4418906", "Ayton",
"441661", "Prudhoe",
"441637", "Newquay",
"441545", "Llanarth",
"441759", "Pocklington",
"441534", "Jersey",
"441479", "Grantown\-on\-Spey",
"442879", "Magherafelt",
"441866", "Kilchrenan",
"441832", "Clopton",
"441299", "Bewdley",
"44116", "Leicester",
"442890", "Belfast",
"441490", "Corwen",
"441337", "Ladybank",
"441270", "Crewe",
"441361", "Duns",
"442884", "Northern\ Ireland",
"441484", "Huddersfield",
"441473", "Ipswich",
"441870", "Isle\ of\ Benbecula",
"441293", "Crawley",
"441899", "Biggar",
"441609", "Northallerton",
"441565", "Knutsford",
"441641", "Strathy",
"441598", "Lynton",
"441918", "Tyneside",
"441603", "Norwich",
"441822", "Tavistock",
"441524", "Lancaster",
"4413398", "Aboyne",
"441327", "Daventry",
"4419752", "Alford\ \(Aberdeen\)",
"441987", "Ebbsfleet",
"4418512", "Stornoway",
"441586", "Campbeltown",
"4413882", "Stanhope\ \(Eastgate\)",
"4415078", "Alford\ \(Lincs\)",
"441808", "Tomatin",
"441558", "Llandeilo",
"441634", "Medway",
"441436", "Helensburgh",
"441208", "Bodmin",
"441462", "Hitchin",
"441746", "Bridgnorth",
"44141", "Glasgow",
"44281", "Northern\ Ireland",
"441503", "Looe",
"441450", "Hawick",
"441885", "Pencombe",
"4419647", "Patrington",
"442826", "Northern\ Ireland",
"441624", "Isle\ of\ Man",
"441259", "Alloa",
"441942", "Wigan",
"441509", "Loughborough",
"441665", "Alnwick",
"441698", "Motherwell",
"441859", "Harris",
"441253", "Blackpool",
"441285", "Cirencester",
"4412299", "Millom",
"441793", "Swindon",
"441442", "Hemel\ Hempstead",
"442842", "Kircubbin",
"441766", "Porthmadog",
"4414230", "Harrogate\/Boroughbridge",
"441398", "Dulverton",
"441732", "Sevenoaks",
"441527", "Redditch",
"441926", "Warwick",
"441950", "Sandwick",
"441799", "Saffron\ Walden",
"441324", "Falkirk",
"441770", "Isle\ of\ Arran",
"441962", "Winchester",
"4414235", "Harrogate",
"4414231", "Harrogate\/Boroughbridge",
"441561", "Laurencekirk",
"441334", "St\ Andrews",
"4418904", "Coldstream",
"441487", "Warboys",
"442887", "Dungannon",
"4413393", "Aboyne",
"441722", "Salisbury",
"4414309", "Market\ Weighton",
"4413873", "Langholm",
"441555", "Lanark",
"441583", "Carradale",
"441439", "Helmsley",
"441872", "Truro",
"441805", "Torrington",
"441749", "Shepton\ Mallet",
"44114708", "Sheffield",
"441377", "Driffield",
"441433", "Hathersage",
"441348", "Fishguard",
"441830", "Kirkwhelpington",
"441145", "Sheffield",
"441743", "Shrewsbury",
"442892", "Lisburn",
"441492", "Colwyn\ Bay",
"441205", "Boston",
"4414343", "Haltwhistle",
"4417687", "Keswick",
"441506", "Bathgate",
"44115", "Nottingham",
"441856", "Orkney",
"442823", "Northern\ Ireland",
"441888", "Turriff",
"441288", "Bude",
"441429", "Hartlepool",
"442829", "Kilrea",
"4418473", "Thurso",
"441668", "Bamburgh",
"4414378", "Haverfordwest",
"441695", "Skelmersdale",
"441256", "Basingstoke",
"441929", "Wareham",
"441395", "Budleigh\ Salterton",
"441368", "Dunbar",
"441796", "Pitlochry",
"4412296", "Barrow\-in\-Furness",
"441763", "Royston",
"441923", "Watford",
"441651", "Oldmeldrum",
"441407", "Holyhead",
"441769", "South\ Molton",
"441933", "Wellingborough",
"441911", "Tyneside\/Durham\/Sunderland",
"441591", "Llanwrtyd\ Wells",
"441992", "Lea\ Valley",
"44114705", "Sheffield",
"4414306", "Market\ Weighton",
"441677", "Bedale",
"441939", "Wem",
"441278", "Bridgwater",
"441465", "Girvan",
"442898", "Belfast",
"4419759", "Alford\ \(Aberdeen\)",
"4413391", "Aboyne\/Ballater",
"4418519", "Great\ Bernera",
"441342", "East\ Grinstead",
"4413395", "Aboyne",
"441650", "Cemmaes\ Road",
"441424", "Hastings",
"441626", "Newton\ Abbot",
"442824", "Northern\ Ireland",
"441878", "Lochboisdale",
"4414233", "Boroughbridge",
"441579", "Liskeard",
"441636", "Newark\-on\-Trent",
"441945", "Wisbech",
"4413390", "Aboyne\/Ballater",
"4419644", "Patrington",
"441744", "St\ Helens",
"441590", "Lymington",
"441910", "Tyneside\/Durham\/Sunderland",
"44161", "Manchester",
"441282", "Burnley",
"441584", "Ludlow",
"441573", "Kelso",
"441882", "Kinloch\ Rannoch",
"441387", "Dumfries",
"4419467", "Gosforth",
"441687", "Mallaig",
"4412292", "Barrow\-in\-Furness",
"441267", "Carmarthen",
"441700", "Rothesay",
"441934", "Weston\-super\-Mare",
"442845", "Northern\ Ireland",
"441445", "Gairloch",
"44131", "Edinburgh",
"441362", "Dereham",
"441821", "Kinrossie",
"441924", "Wakefield",
"441725", "Rockbourne",
"441350", "Dunkeld",
"4418907", "Ayton",
"441326", "Falmouth",
"441642", "Middlesbrough",
"4414302", "North\ Cave",
"441764", "Crieff",
"441629", "Matlock",
"4419756", "Strathdon",
"4418516", "Great\ Bernera",
"441142", "Sheffield",
"442868", "Kesh",
"441495", "Pontypool",
"442895", "Belfast",
"441275", "Clevedon",
"441254", "Blackburn",
"441202", "Bournemouth",
"441854", "Ullapool",
"441875", "Tranent",
"441951", "Colonsay",
"44292", "Cardiff",
"441623", "Mansfield",
"441771", "Maud",
"441307", "Forfar",
"4417684", "Pooley\ Bridge",
"441633", "Newport",
"441560", "Moscow",
"441692", "North\ Walsham",
"441948", "Whitchurch",
"441977", "Pontefract",
"441639", "Neath",
"441576", "Lockerbie",
"44114700", "Sheffield",
"441757", "Selby",
"4418475", "Thurso",
"441297", "Axminster",
"4418471", "Thurso\/Tongue",
"442877", "Limavady",
"441477", "Holmes\ Chapel",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441392", "Exeter",
"441738", "Perth",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"442848", "Northern\ Ireland",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441451", "Stow\-on\-the\-Wold",
"441728", "Saxmundham",
"4414345", "Haltwhistle",
"441323", "Eastbourne",
"441780", "Stamford",
"4416868", "Newtown",
"4418470", "Thurso\/Tongue",
"441794", "Romsey",
"441540", "Kingussie",
"441968", "Penicuik",
"441329", "Fareham",
"441995", "Garstang",
"441357", "Strathaven",
"441949", "Whatton",
"441502", "Lowestoft",
"441554", "Llanelli",
"441575", "Kirriemuir",
"441852", "Kilmelford",
"441638", "Newmarket",
"441252", "Aldershot",
"441204", "Bolton",
"4413397", "Ballater",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441943", "Guiseley",
"441144", "Sheffield",
"441371", "Great\ Dunmow",
"441707", "Welwyn\ Garden\ City",
"441260", "Congleton",
"441628", "Maidenhead",
"44117", "Bristol",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441876", "Lochmaddy",
"441469", "Killingholme",
"441496", "Port\ Ellen",
"441694", "Church\ Stretton",
"442896", "Belfast",
"441276", "Camberley",
"441463", "Inverness",
"441729", "Settle",
"441917", "Sunderland",
"4416869", "Newtown",
"441597", "Llandrindod\ Wells",
"4419643", "Patrington",
"441394", "Felixstowe",
"441963", "Wincanton",
"441723", "Scarborough",
"441380", "Devizes",
"44114703", "Sheffield",
"441328", "Fakenham",
"441969", "Leyburn",
"441671", "Newton\ Stewart",
"4418900", "Coldstream\/Ayton",
"441733", "Peterborough",
"441840", "Camelford",
"441792", "Swansea",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441443", "Pontypridd",
"4418905", "Ayton",
"4418901", "Coldstream\/Ayton",
"4414234", "Boroughbridge",
"441449", "Stowmarket",
"442849", "Northern\ Ireland",
"441787", "Sudbury",
"441578", "Lauder",
"441600", "Monmouth",
"441422", "Halifax",
"442822", "Northern\ Ireland",
"441344", "Bracknell",
"441547", "Knighton",
"441635", "Newbury",
"441946", "Whitehaven",
"4419758", "Strathdon",
"442899", "Northern\ Ireland",
"441499", "Inveraray",
"4418518", "Stornoway",
"441279", "Bishops\ Stortford",
"4415072", "Spilsby\ \(Horncastle\)",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"442870", "Coleraine",
"441582", "Luton",
"441290", "Cumnock",
"441884", "Tiverton",
"441873", "Abergavenny",
"441981", "Wormbridge",
"441625", "Macclesfield",
"441493", "Great\ Yarmouth",
"442893", "Ballyclare",
"441273", "Brighton",
"441284", "Bury\ St\ Edmunds",
"441432", "Hereford",
"441466", "Huntly",
"44239", "Portsmouth",
"442866", "Enniskillen",
"441664", "Melton\ Mowbray",
"441879", "Scarinish",
"4417683", "Appleby",
"441364", "Ashburton",
"441993", "Witney",
"441531", "Ledbury",
"4416866", "Newtown",
"441567", "Killin",
"441932", "Weybridge",
"441726", "St\ Austell",
"441750", "Selkirk",
"441325", "Darlington",
"4418477", "Tongue",
"442881", "Newtownstewart",
"441481", "Guernsey",
"441970", "Aberystwyth",
"441335", "Ashbourne",
"441736", "Penzance",
"441644", "New\ Galloway",
"442846", "Northern\ Ireland",
"441446", "Barry",
"441300", "Cerne\ Abbas",
"44280", "Northern\ Ireland",
"441922", "Walsall",
"4414347", "Hexham",
"442894", "Antrim",
"441494", "High\ Wycombe",
"441255", "Clacton\-on\-Sea",
"441283", "Burton\-on\-Trent",
"441274", "Bradford",
"441530", "Coalville",
"4418903", "Coldstream",
"441663", "New\ Mills",
"441889", "Rugeley",
"4414379", "Haverfordwest",
"441428", "Haslemere",
"442828", "Larne",
"4419640", "Hornsea\/Patrington",
"441751", "Pickering",
"441289", "Berwick\-upon\-Tweed",
"4413394", "Ballater",
"441505", "Johnstone",
"441572", "Oakham",
"442880", "Carrickmore",
"441480", "Huntingdon",
"441883", "Caterham",
"441855", "Ballachulish",
"441874", "Brecon",
"441971", "Scourie",
"441669", "Rothbury",
"441343", "Elgin",
"441438", "Stevenage",
"442838", "Portadown",
"441206", "Colchester",
"441748", "Richmond",
"4415076", "Louth",
"441146", "Sheffield",
"441301", "Arrochar",
"441777", "Retford",
"441349", "Dingwall",
"441588", "Bishops\ Castle",
"441957", "Mid\ Yell",
"441556", "Castle\ Douglas",
"4419641", "Hornsea\/Patrington",
"4419645", "Hornsea",
"441520", "Lochcarron",
"441806", "Shetland",
"441457", "Glossop",
"4416862", "Llanidloes",
"441938", "Welshpool",
"441643", "Minehead",
"441369", "Dunoon",
"441928", "Runcorn",
"4415242", "Hornby",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"442871", "Londonderry",
"441291", "Chepstow",
"441980", "Amesbury",
"441994", "St\ Clears",
"441363", "Crediton",
"4415396", "Sedbergh",
"4414237", "Harrogate",
"441795", "Sittingbourne",
"441768", "Penrith",
"441286", "Caernarfon",
"441258", "Blandford",
"441666", "Malmesbury",
"441464", "Insch",
"441381", "Fortrose",
"441858", "Market\ Harborough",
"441508", "Brooke",
"44118", "Reading",
"441670", "Morpeth",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"4414376", "Haverfordwest",
"442825", "Ballymena",
"441425", "Ringwood",
"4415079", "Alford\ \(Lincs\)",
"441745", "Rhyl",
"441346", "Fraserburgh",
"441841", "Newquay\ \(Padstow\)",
"441559", "Llandysul",
"441435", "Heathfield",
"441944", "West\ Heslerton",
"441809", "Tomdoun",
"441143", "Sheffield",
"441241", "Arbroath",
"441209", "Redruth",
"441400", "Honington",
"441553", "Kings\ Lynn",
"441803", "Torquay",
"441622", "Maidstone",
"441322", "Dartford",
"441900", "Workington",
"441827", "Tamworth",
"4414308", "Market\ Weighton",
"441227", "Canterbury",
"4418474", "Thurso",
"441935", "Yeovil",
"441444", "Haywards\ Heath",
"442844", "Downpatrick",
"441646", "Milford\ Haven",
"441237", "Bideford",
"441724", "Scunthorpe",
"441261", "Banff",
"44287", "Northern\ Ireland",
"441925", "Warrington",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"4412298", "Barrow\-in\-Furness",
"441798", "Pulborough",
"441332", "Derby",
"441765", "Ripon",
"441366", "Downham\ Market",
"441837", "Okehampton",
"4414344", "Bellingham",
"441359", "Pakenham",
"4416867", "Llanidloes",
"441947", "Whitby",
"441546", "Lochgilphead",
"441353", "Ely",
"441978", "Wrexham",
"441786", "Stirling",
"441758", "Pwllheli",
"4418476", "Tongue",
"442821", "Martinstown",
"441709", "Rotherham",
"441431", "Helmsdale",
"441845", "Thirsk",
"441467", "Inverurie",
"4416973", "Wigton",
"442867", "Lisnaskea",
"441245", "Chelmsford",
"4414232", "Harrogate",
"441581", "New\ Luce",
"4414346", "Hexham",
"441982", "Builth\ Wells",
"441308", "Bridport",
"441599", "Kyle",
"441919", "Durham",
"441608", "Chipping\ Norton",
"441727", "St\ Albans",
"441234", "Bedford",
"442882", "Omagh",
"441570", "Lampeter",
"441482", "Kingston\-upon\-Hull",
"441913", "Durham",
"441593", "Lybster",
"4414303", "North\ Cave",
"4419755", "Alford\ \(Aberdeen\)",
"4414374", "Clynderwen\ \(Clunderwen\)",
"4413885", "Stanhope\ \(Eastgate\)",
"4418515", "Stornoway",
"441566", "Launceston",
"441931", "Shap",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"4418511", "Great\ Bernera\/Stornoway",
"441834", "Narberth",
"441967", "Strontian",
"4413399", "Ballater",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441298", "Buxton",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441824", "Ruthin",
"441685", "Merthyr\ Tydfil",
"441653", "Malton",
"4412293", "Millom",
"441522", "Lincoln",
"441737", "Redhill",
"441224", "Aberdeen",
"441761", "Temple\ Cloud",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"4418510", "Great\ Bernera\/Stornoway",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"442847", "Northern\ Ireland",
"441659", "Sanquhar",
"441865", "Oxford",
"4420", "London",
"441789", "Stratford\-upon\-Avon",
"4418908", "Coldstream",
"441543", "Cannock",
"441356", "Brechin",
"4418479", "Tongue",
"441320", "Fort\ Augustus",
"441501", "Harthill",
"441902", "Wolverhampton",
"441388", "Bishop\ Auckland",
"441549", "Lairg",
"441954", "Madingley",
"441277", "Brentwood",
"441330", "Banchory",
"441848", "Thornhill",
"441497", "Hay\-on\-Wye",
"442897", "Saintfield",
"442311", "Southampton",
"44283", "Northern\ Ireland",
"441372", "Esher",
"441305", "Dorchester",
"4414349", "Bellingham",
"441706", "Rochdale",
"441877", "Callander",
"4415394", "Hawkshead",
"441248", "Bangor\ \(Gwynedd\)",
"441672", "Marlborough",
"441569", "Stonehaven",
"441997", "Strathpeffer",
"4413396", "Ballater",
"441916", "Tyneside",
"441630", "Market\ Drayton",
"441563", "Kilmarnock",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"4415074", "Alford\ \(Lincs\)",
"441656", "Bridgend",
"441475", "Greenock",
"441454", "Chipping\ Sodbury",
"441295", "Banbury",
"441268", "Basildon",
"441620", "North\ Berwick",
"441895", "Uxbridge",
"441908", "Milton\ Keynes",
"441382", "Dundee",
"4414300", "North\ Cave\/Market\ Weighton",
"441887", "Aberfeldy",
"4416864", "Llanidloes",
"4412291", "Barrow\-in\-Furness\/Millom",
"441287", "Guisborough",
"4412295", "Barrow\-in\-Furness",
"44291", "Cardiff",
"441631", "Oban",
"441667", "Nairn",
"44114709", "Sheffield",
"441242", "Cheltenham",
"4419753", "Strathdon",
"4418513", "Stornoway",
"441773", "Ripley",
"441784", "Staines",
"4414301", "North\ Cave\/Market\ Weighton",
"441621", "Maldon",
"4414305", "North\ Cave",
"441953", "Wymondham",
"441985", "Warminster",
"4414239", "Boroughbridge",
"441347", "Easingwold",
"441779", "Peterhead",
"441842", "Thetford",
"4412290", "Barrow\-in\-Furness\/Millom",
"441790", "Spilsby",
"441959", "Westerham",
"441544", "Kington",
"441226", "Barnsley",
"441250", "Blairgowrie",
"441647", "Moretonhampstead",
"441535", "Keighley",
"4413392", "Aboyne",
"441678", "Bala",
"4414377", "Haverfordwest",
"441453", "Dursley",
"441485", "Hunstanton",
"442885", "Ballygawley",
"44114702", "Sheffield",
"441367", "Faringdon",
"44241", "Coventry",
"442310", "Portsmouth",
"44113", "Leeds",
"441862", "Tain",
"441564", "Lapworth",
"441262", "Bridlington",
"441408", "Golspie",
"441236", "Coatbridge",
"44121", "Birmingham",
"441525", "Leighton\ Buzzard",
"441752", "Plymouth",
"441704", "Southport",
"441571", "Lochinver",
"441905", "Worcester",
"441972", "Glenborrodale",
"44114704", "Sheffield",
"441697", "Brampton",
"4418472", "Thurso",
"441354", "Chatteris",
"441375", "Grays\ Thurrock",
"441988", "Wigtown",
"441302", "Doncaster",
"441776", "Stranraer",
"441807", "Ballindalloch",
"441920", "Ware",
"441557", "Kirkcudbright",
"441207", "Consett",
"441760", "Swaffham",
"4414236", "Harrogate",
"4414342", "Bellingham",
"441223", "Cambridge",
"441538", "Ipstones",
"4419648", "Hornsea",
"44114701", "Sheffield",
"441829", "Tarporley",
"442888", "Northern\ Ireland",
"441488", "Hungerford",
"441823", "Taunton",
"441456", "Glenurquhart",
"441675", "Coleshill",
"441654", "Machynlleth",
"441420", "Alton",
"442820", "Ballycastle",
"441740", "Sedgefield",
"441914", "Tyneside",
"441594", "Lydney",
"441239", "Cardigan",
"441892", "Tunbridge\ Wells",
"4415077", "Louth",
"442830", "Newry",
"441397", "Fort\ William",
"441833", "Barnard\ Castle",
"441528", "Laggan",
"441233", "Ashford\ \(Kent\)",
"441405", "Goole",
"441472", "Grimsby",
"441580", "Cranbrook",
"441292", "Ayr",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([0-24-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;