/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.UnknownChannelException;
import com.rabbitmq.utility.IntAllocator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ChannelManager {
    private final Map<Integer, ChannelN> _channelMap = Collections.synchronizedMap(new HashMap());
    private final IntAllocator channelNumberAllocator;
    public final int _channelMax;

    public int getChannelMax() {
        return this._channelMax;
    }

    public ChannelManager(int channelMax) {
        if (channelMax == 0) {
            channelMax = 65535;
        }
        this._channelMax = channelMax;
        this.channelNumberAllocator = new IntAllocator(1, channelMax);
    }

    public ChannelN getChannel(int channelNumber) {
        ChannelN result = this._channelMap.get(channelNumber);
        if (result == null) {
            throw new UnknownChannelException(channelNumber);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSignal(ShutdownSignalException signal) {
        HashSet<ChannelN> channels;
        Map<Integer, ChannelN> map = this._channelMap;
        synchronized (map) {
            channels = new HashSet<ChannelN>(this._channelMap.values());
        }
        for (ChannelN channel : channels) {
            this.disconnectChannel(channel);
            channel.processShutdownSignal(signal, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection connection) throws IOException {
        int channelNumber;
        ChannelManager channelManager = this;
        synchronized (channelManager) {
            channelNumber = this.channelNumberAllocator.allocate();
            if (channelNumber == -1) {
                return null;
            }
        }
        return this.createChannelInternal(connection, channelNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection connection, int channelNumber) throws IOException {
        boolean reserved;
        ChannelManager channelManager = this;
        synchronized (channelManager) {
            reserved = this.channelNumberAllocator.reserve(channelNumber);
        }
        if (reserved) {
            return this.createChannelInternal(connection, channelNumber);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelN createChannelInternal(AMQConnection connection, int channelNumber) throws IOException {
        ChannelN ch;
        ChannelManager channelManager = this;
        synchronized (channelManager) {
            if (this._channelMap.containsKey(channelNumber)) {
                throw new IllegalStateException("We have attempted to create a channel with a number that is already in use. This should never happen. Please report this as a bug.");
            }
            ch = new ChannelN(connection, channelNumber);
            this.addChannel(ch);
        }
        ch.open();
        return ch;
    }

    private void addChannel(ChannelN chan) {
        this._channelMap.put(chan.getChannelNumber(), chan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnectChannel(ChannelN channel) {
        int channelNumber = channel.getChannelNumber();
        Map<Integer, ChannelN> map = this._channelMap;
        synchronized (map) {
            ChannelN existing = this._channelMap.remove(channelNumber);
            if (existing == null) {
                return;
            }
            if (existing != channel) {
                this._channelMap.put(channelNumber, existing);
                return;
            }
            this.channelNumberAllocator.free(channelNumber);
        }
    }
}

