# Generated by default/object.tt
package Paws::Macie2::Range;
  use Moose;
  has End => (is => 'ro', isa => 'Int', request_name => 'end', traits => ['NameInRequest']);
  has Start => (is => 'ro', isa => 'Int', request_name => 'start', traits => ['NameInRequest']);
  has StartColumn => (is => 'ro', isa => 'Int', request_name => 'startColumn', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::Range

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::Range object:

  $service_obj->Method(Att1 => { End => $value, ..., StartColumn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::Range object:

  $result = $service_obj->Method(...);
  $result->Att1->End

=head1 DESCRIPTION

Specifies the location of an occurrence of sensitive data in a
non-binary text file, such as an HTML, TXT, or XML file.

=head1 ATTRIBUTES


=head2 End => Int

The number of lines from the beginning of the file to the end of the
sensitive data.


=head2 Start => Int

The number of lines from the beginning of the file to the beginning of
the sensitive data.


=head2 StartColumn => Int

The number of characters, with spaces and starting from 1, from the
beginning of the first line that contains the sensitive data (start) to
the beginning of the sensitive data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

