# Generated by default/object.tt
package Paws::Macie2::Statistics;
  use Moose;
  has ApproximateNumberOfObjectsToProcess => (is => 'ro', isa => 'Num', request_name => 'approximateNumberOfObjectsToProcess', traits => ['NameInRequest']);
  has NumberOfRuns => (is => 'ro', isa => 'Num', request_name => 'numberOfRuns', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::Statistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::Statistics object:

  $service_obj->Method(Att1 => { ApproximateNumberOfObjectsToProcess => $value, ..., NumberOfRuns => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::Statistics object:

  $result = $service_obj->Method(...);
  $result->Att1->ApproximateNumberOfObjectsToProcess

=head1 DESCRIPTION

Provides processing statistics for a classification job.

=head1 ATTRIBUTES


=head2 ApproximateNumberOfObjectsToProcess => Num

The approximate number of objects that the job has yet to process
during its current run.


=head2 NumberOfRuns => Num

The number of times that the job has run.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

