# Generated by default/object.tt
package Paws::Robomaker::UploadConfiguration;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Path => (is => 'ro', isa => 'Str', request_name => 'path', traits => ['NameInRequest'], required => 1);
  has UploadBehavior => (is => 'ro', isa => 'Str', request_name => 'uploadBehavior', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Robomaker::UploadConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Robomaker::UploadConfiguration object:

  $service_obj->Method(Att1 => { Name => $value, ..., UploadBehavior => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Robomaker::UploadConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Provides upload configuration information. Files are uploaded from the
simulation job to a location you specify.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

A prefix that specifies where files will be uploaded in Amazon S3. It
is appended to the simulation output location to determine the final
path.

For example, if your simulation output location is C<s3://my-bucket>
and your upload configuration name is C<robot-test>, your files will be
uploaded to
C<s3://my-bucket/E<lt>simidE<gt>/E<lt>runidE<gt>/robot-test>.


=head2 B<REQUIRED> Path => Str

Specifies the path of the file(s) to upload. Standard Unix glob
matching rules are accepted, with the addition of C<**> as a I<super
asterisk>. For example, specifying C</var/log/**.log> causes all .log
files in the C</var/log> directory tree to be collected. For more
examples, see Glob Library (https://github.com/gobwas/glob).


=head2 B<REQUIRED> UploadBehavior => Str

Specifies when to upload the files:

=over

=item UPLOAD_ON_TERMINATE

Matching files are uploaded once the simulation enters the
C<TERMINATING> state. Matching files are not uploaded until all of your
code (including tools) have stopped.

If there is a problem uploading a file, the upload is retried. If
problems persist, no further upload attempts will be made.

=item UPLOAD_ROLLING_AUTO_REMOVE

Matching files are uploaded as they are created. They are deleted after
they are uploaded. The specified path is checked every 5 seconds. A
final check is made when all of your code (including tools) have
stopped.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Robomaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

