/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.EPSGName;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

@XmlTransient
public final class Affine
extends AbstractProvider {
    private static final long serialVersionUID = 649555815622129472L;
    public static final String NAME = "Affine parametric transformation";
    private static volatile Affine EPSG_METHOD;
    public static final int EPSG_DIMENSION = 2;
    private static final int MAX_CACHED_DIMENSION = 6;
    private static final Affine[] cached;
    private static final Map<String, ?> IDENTIFICATION_EPSG;
    private static final Map<String, ?> IDENTIFICATION_OGC;

    public Affine() {
        super(IDENTIFICATION_EPSG, 2, 2, (ParameterDescriptorGroup)new Descriptor(IDENTIFICATION_EPSG, Arrays.copyOfRange(TensorParameters.ALPHANUM.getAllDescriptors(2, 3), 2, 8)));
        EPSG_METHOD = this;
    }

    private Affine(int n, int n2) {
        super(IDENTIFICATION_OGC, n, n2, (ParameterDescriptorGroup)new Descriptor(IDENTIFICATION_OGC, TensorParameters.WKT1.getAllDescriptors(n2 + 1, n + 1)));
    }

    @Override
    public final boolean isInvertible() {
        return true;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        return MathTransforms.linear(TensorParameters.WKT1.toMatrix(parameterValueGroup));
    }

    @Override
    public OperationMethod redimension(int n, int n2) {
        return Affine.getProvider(n, n2, false);
    }

    private static int cacheIndex(int n, int n2) {
        if (--n >= 0 && n < 6 && --n2 >= 0 && n2 < 6) {
            return n * 6 + n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Affine getProvider(int n, int n2, boolean bl) {
        Affine[] affineArray;
        Affine affine;
        if (bl && n == 2 && n2 == 2) {
            affine = EPSG_METHOD;
            if (affine != null) return affine;
            return new Affine();
        }
        int n3 = Affine.cacheIndex(n, n2);
        if (n3 >= 0) {
            affineArray = cached;
            // MONITORENTER : cached
            affine = cached[n3];
            // MONITOREXIT : affineArray
            if (affine != null) {
                return affine;
            }
        }
        affine = new Affine(n, n2);
        if (n3 < 0) return affine;
        affineArray = cached;
        // MONITORENTER : cached
        Affine affine2 = cached[n3];
        if (affine2 != null) {
            // MONITOREXIT : affineArray
            return affine2;
        }
        Affine.cached[n3] = affine;
        // MONITOREXIT : affineArray
        return affine;
    }

    public static ParameterValueGroup identity(int n) {
        ParameterValueGroup parameterValueGroup = TensorParameters.WKT1.createValueGroup(Collections.singletonMap("name", "Affine"));
        parameterValueGroup.parameter("num_col").setValue(++n);
        parameterValueGroup.parameter("num_row").setValue(n);
        return parameterValueGroup;
    }

    public static ParameterValueGroup parameters(Matrix matrix) {
        Map<String, ?> map;
        TensorParameters<Double> tensorParameters;
        int n = matrix.getNumCol() - 1;
        int n2 = matrix.getNumRow() - 1;
        if (n == 2 && n2 == 2 && Matrices.isAffine(matrix)) {
            tensorParameters = TensorParameters.ALPHANUM;
            map = IDENTIFICATION_EPSG;
        } else {
            tensorParameters = TensorParameters.WKT1;
            map = IDENTIFICATION_OGC;
        }
        return tensorParameters.createValueGroup(map, matrix);
    }

    static {
        cached = new Affine[36];
        NamedIdentifier namedIdentifier = new NamedIdentifier(Citations.OGC, "OGC", (CharSequence)"Affine", null, null);
        IDENTIFICATION_OGC = Collections.singletonMap("name", namedIdentifier);
        IDENTIFICATION_EPSG = EPSGName.properties(9624, NAME, namedIdentifier);
    }

    private static final class Descriptor
    extends DefaultParameterDescriptorGroup {
        private static final long serialVersionUID = 8320799650519834830L;

        Descriptor(Map<String, ?> map, ParameterDescriptor<?>[] parameterDescriptorArray) {
            super(map, 1, 1, parameterDescriptorArray);
        }

        @Override
        public ParameterValueGroup createValue() {
            return TensorParameters.WKT1.createValueGroup(IDENTIFICATION_OGC);
        }
    }
}

