/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.DataTransfer;
import org.apache.sis.internal.storage.io.MemoryDataTransfer;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.resources.Errors;

public final class HyperRectangleReader {
    private final DataTransfer reader;
    public final long origin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperRectangleReader(byte by, ChannelDataInput channelDataInput, long l) throws DataStoreException {
        switch (by) {
            case 3: {
                ChannelDataInput channelDataInput2 = channelDataInput;
                channelDataInput2.getClass();
                this.reader = channelDataInput2.new ChannelDataInput.BytesReader(null);
                break;
            }
            case 2: {
                ChannelDataInput channelDataInput3 = channelDataInput;
                channelDataInput3.getClass();
                this.reader = channelDataInput3.new ChannelDataInput.CharsReader((char[])null);
                break;
            }
            case 4: {
                ChannelDataInput channelDataInput4 = channelDataInput;
                channelDataInput4.getClass();
                this.reader = channelDataInput4.new ChannelDataInput.ShortsReader((short[])null);
                break;
            }
            case 5: {
                ChannelDataInput channelDataInput5 = channelDataInput;
                channelDataInput5.getClass();
                this.reader = channelDataInput5.new ChannelDataInput.IntsReader((int[])null);
                break;
            }
            case 6: {
                ChannelDataInput channelDataInput6 = channelDataInput;
                channelDataInput6.getClass();
                this.reader = channelDataInput6.new ChannelDataInput.LongsReader((long[])null);
                break;
            }
            case 7: {
                ChannelDataInput channelDataInput7 = channelDataInput;
                channelDataInput7.getClass();
                this.reader = channelDataInput7.new ChannelDataInput.FloatsReader((float[])null);
                break;
            }
            case 8: {
                ChannelDataInput channelDataInput8 = channelDataInput;
                channelDataInput8.getClass();
                this.reader = channelDataInput8.new ChannelDataInput.DoublesReader((double[])null);
                break;
            }
            default: {
                throw new DataStoreContentException(Errors.format((short)149, by));
            }
        }
        this.origin = l;
        ByteBuffer byteBuffer = channelDataInput.buffer;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        try {
            byteBuffer.position(0).limit(byteBuffer.capacity());
            this.reader.createView();
        }
        finally {
            byteBuffer.limit(n2).position(n);
        }
    }

    public HyperRectangleReader(String string, Buffer buffer) throws IOException {
        this.reader = new MemoryDataTransfer(string, buffer).reader();
        this.origin = 0L;
    }

    public String filename() {
        return this.reader.filename();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Region region) throws IOException {
        int n = region.targetLength(region.contiguousDataDimension);
        long[] lArray = new long[region.getDimension() - region.contiguousDataDimension];
        int[] nArray = new int[lArray.length];
        int n2 = this.reader.dataSizeShift();
        long l = this.origin + (region.startAt << n2);
        int n3 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = region.skips[i + region.contiguousDataDimension] + (long)n << n2;
            assert (lArray[i] > 0L) : i;
        }
        try {
            this.reader.createDataArray(region.targetLength(region.getDimension()));
            Buffer buffer = this.reader.view();
            block4: while (true) {
                this.reader.seek(l);
                assert (this.reader.view() == buffer);
                this.reader.readFully(buffer, n3, n);
                for (int i = 0; i < nArray.length; ++i) {
                    int n4 = i;
                    nArray[n4] = nArray[n4] + 1;
                    if (nArray[n4] < region.targetSize[region.contiguousDataDimension + i]) {
                        l += lArray[i];
                        n3 += n;
                        continue block4;
                    }
                    nArray[i] = 0;
                }
                break;
            }
            Object object = this.reader.dataArray();
            return object;
        }
        finally {
            this.reader.setDest(null);
        }
    }
}

