/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.UML;

final class PropertyComparator
implements Comparator<Method> {
    private static final String IS = "is";
    private static final String GET = "get";
    static final String SET = "set";
    private final Map<Object, Integer> order = new HashMap<Object, Integer>();
    private final Class<?> implementation;

    PropertyComparator(Class<?> clazz, Class<?> clazz2) {
        PropertyComparator.defineOrder(clazz, this.order);
        if (this.order.isEmpty() && clazz2 != null && !clazz2.isAssignableFrom(clazz)) {
            clazz = clazz2;
            PropertyComparator.defineOrder(clazz, this.order);
        }
        this.implementation = clazz;
    }

    private static void defineOrder(Class<?> clazz, Map<Object, Integer> map) {
        do {
            XmlType xmlType;
            if ((xmlType = clazz.getAnnotation(XmlType.class)) == null) continue;
            String[] stringArray = xmlType.propOrder();
            int n = stringArray.length;
            while (--n >= 0) {
                Integer n2 = map.put(stringArray[n], map.size());
                if (n2 == null) continue;
                map.put(stringArray[n], n2);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    static boolean isDeprecated(Class<?> clazz, Method method) {
        if (method.isAnnotationPresent(Deprecated.class)) {
            return true;
        }
        if (method.getDeclaringClass() == clazz) {
            return false;
        }
        try {
            method = clazz.getMethod(method.getName(), null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        return method.isAnnotationPresent(Deprecated.class);
    }

    @Override
    public int compare(Method method, Method method2) {
        boolean bl = PropertyComparator.isDeprecated(this.implementation, method);
        if (bl != PropertyComparator.isDeprecated(this.implementation, method2)) {
            return bl ? 1 : -1;
        }
        int n = this.indexOf(method2) - this.indexOf(method);
        if (n == 0) {
            UML uML = method.getAnnotation(UML.class);
            UML uML2 = method2.getAnnotation(UML.class);
            if (uML != null) {
                if (uML2 == null) {
                    return 1;
                }
                n = PropertyComparator.order(uML) - PropertyComparator.order(uML2);
                if (n == 0) {
                    n = uML.identifier().compareToIgnoreCase(uML2.identifier());
                }
                return n;
            }
            if (uML2 != null) {
                return -1;
            }
            n = method.getName().compareToIgnoreCase(method2.getName());
        }
        return n;
    }

    private static int order(UML uML) {
        Obligation obligation = uML.obligation();
        if (obligation != null) {
            switch (obligation) {
                case MANDATORY: {
                    return 1;
                }
                case CONDITIONAL: {
                    return 2;
                }
                case OPTIONAL: {
                    return 3;
                }
                case FORBIDDEN: {
                    return 4;
                }
            }
        }
        return 5;
    }

    private int indexOf(Method method) {
        Integer n = this.order.get(method);
        if (n == null) {
            UML uML;
            String string = method.getName();
            n = this.order.get(string = PropertyComparator.toPropertyName(string, PropertyComparator.prefix(string).length()));
            if (n == null && ((uML = method.getAnnotation(UML.class)) == null || (n = this.order.get(uML.identifier())) == null)) {
                n = -1;
            }
            this.order.put(method, n);
        }
        return n;
    }

    static String prefix(String string) {
        if (string.startsWith(GET)) {
            return GET;
        }
        if (string.startsWith(IS)) {
            return IS;
        }
        if (string.startsWith(SET)) {
            return SET;
        }
        return "";
    }

    private static boolean isAcronym(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.codePointAt(n);
            if (Character.isLowerCase(n3)) {
                return false;
            }
            n += Character.charCount(n3);
        }
        return true;
    }

    static String toPropertyName(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            int n3;
            int n4;
            string = PropertyComparator.isAcronym(string, n) ? string.substring(n) : ((n4 = string.codePointAt(n)) != (n3 = Character.toLowerCase(n4)) ? new StringBuilder(n2 - n).appendCodePoint(n3).append(string, n + Character.charCount(n4), n2).toString() : string.substring(n));
        }
        return string.intern();
    }
}

