/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DataIdentification_Type", propOrder={"languages", "characterSets", "topicCategory", "environmentDescription", "extent", "supplementalInformation"})
@XmlRootElement(name="MD_DataIdentification")
public class DefaultDataIdentification
extends AbstractIdentification
implements DataIdentification {
    private static final long serialVersionUID = 6104637930243499850L;
    private Collection<Locale> languages;
    private Collection<CharacterSet> characterSets;
    private InternationalString environmentDescription;
    private InternationalString supplementalInformation;

    public DefaultDataIdentification() {
    }

    public DefaultDataIdentification(Citation citation, CharSequence charSequence, Locale locale, TopicCategory topicCategory) {
        super(citation, charSequence);
        this.languages = this.singleton(locale, Locale.class);
        super.setTopicCategories(this.singleton(topicCategory, TopicCategory.class));
    }

    public DefaultDataIdentification(DataIdentification dataIdentification) {
        super(dataIdentification);
        if (dataIdentification != null) {
            this.languages = this.copyCollection(dataIdentification.getLanguages(), Locale.class);
            this.characterSets = this.copyCollection(dataIdentification.getCharacterSets(), CharacterSet.class);
            this.environmentDescription = dataIdentification.getEnvironmentDescription();
            this.supplementalInformation = dataIdentification.getSupplementalInformation();
        }
    }

    public static DefaultDataIdentification castOrCopy(DataIdentification dataIdentification) {
        if (dataIdentification == null || dataIdentification instanceof DefaultDataIdentification) {
            return (DefaultDataIdentification)dataIdentification;
        }
        return new DefaultDataIdentification(dataIdentification);
    }

    @Override
    @XmlElement(name="language", required=true)
    public Collection<Locale> getLanguages() {
        this.languages = this.nonNullCollection(this.languages, Locale.class);
        return this.languages;
    }

    public void setLanguages(Collection<? extends Locale> collection) {
        this.languages = this.writeCollection(collection, this.languages, Locale.class);
    }

    @Override
    @XmlElement(name="characterSet")
    public Collection<CharacterSet> getCharacterSets() {
        this.characterSets = this.nonNullCollection(this.characterSets, CharacterSet.class);
        return this.characterSets;
    }

    public void setCharacterSets(Collection<? extends CharacterSet> collection) {
        this.characterSets = this.writeCollection(collection, this.characterSets, CharacterSet.class);
    }

    @Override
    @XmlElement(name="environmentDescription")
    public InternationalString getEnvironmentDescription() {
        return this.environmentDescription;
    }

    public void setEnvironmentDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.environmentDescription = internationalString;
    }

    @Override
    @XmlElement(name="supplementalInformation")
    public InternationalString getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public void setSupplementalInformation(InternationalString internationalString) {
        this.checkWritePermission();
        this.supplementalInformation = internationalString;
    }

    @XmlElement(name="topicCategory")
    private Collection<TopicCategory> getTopicCategory() {
        return this.getTopicCategories();
    }

    private void setTopicCategory(Collection<? extends TopicCategory> collection) {
        this.setTopicCategories(collection);
    }

    @XmlElement(name="extent")
    private Collection<Extent> getExtent() {
        return this.getExtents();
    }

    private void setExtent(Collection<? extends Extent> collection) {
        this.setExtents(collection);
    }
}

